/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.helpers;

import carpetfixes.CarpetFixesServer;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_7165;
import org.jetbrains.annotations.Nullable;

public class MemEfficientNeighborUpdater
implements class_7165 {
    private static final int UPDATE_AMT = field_37839.length;
    protected static final int MAX_UPDATE_DATA_SIZE = 9;
    protected int[] queuedUpdates;
    protected int[] pendingUpdates;
    protected int maxSize;
    protected int pointer = 0;
    protected int pendingPointer = 0;
    protected int minSize;
    protected int effectiveSize;
    protected int pendingEffectiveSize;
    private final class_1937 world;
    public boolean processing;

    public MemEfficientNeighborUpdater(class_1937 world, int maxSize) {
        this(world, maxSize, 16384);
    }

    public MemEfficientNeighborUpdater(class_1937 world) {
        this(world, 100000000, 16384);
    }

    public MemEfficientNeighborUpdater(class_1937 world, int maxSize, int minSize) {
        this.maxSize = maxSize;
        this.world = world;
        this.minSize = minSize;
        this.effectiveSize = minSize;
        this.pendingEffectiveSize = minSize;
        this.queuedUpdates = new int[9 * minSize];
        this.pendingUpdates = new int[9 * minSize];
    }

    public void method_42392(class_2350 dir, class_2680 state, class_2338 blockPos, class_2338 sourcePos, int i, int j) {
        this.enqueue(new int[]{dir.method_10146() | 0x40000000, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), sourcePos.method_10263(), sourcePos.method_10264(), sourcePos.method_10260(), MemEfficientNeighborUpdater.getID(state), i});
    }

    public void method_41704(class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos) {
        this.enqueue(new int[]{MemEfficientNeighborUpdater.createDataType(sourceBlock, 0), pos.method_10263(), pos.method_10264(), pos.method_10260(), sourcePos.method_10263(), sourcePos.method_10264(), sourcePos.method_10260()});
    }

    public void method_41703(class_2680 state, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        this.enqueue(new int[]{MemEfficientNeighborUpdater.createDataType(sourceBlock, 1), pos.method_10263(), pos.method_10264(), pos.method_10260(), sourcePos.method_10263(), sourcePos.method_10264(), sourcePos.method_10260(), MemEfficientNeighborUpdater.getID(state), notify ? 1 : 0});
    }

    public void method_41705(class_2338 pos, class_2248 sourceBlock, @Nullable class_2350 except) {
        int id = except == null ? 6 : except.method_10146();
        this.enqueue(new int[]{MemEfficientNeighborUpdater.createDataType(sourceBlock, 3), pos.method_10263(), pos.method_10264(), pos.method_10260(), id, 0});
    }

    public void enqueue(int[] data) {
        if (this.pointer + this.pendingPointer + 1 > this.maxSize) {
            CarpetFixesServer.LOGGER.error("Too many chained neighbor updates. Skipping the rest.");
            return;
        }
        if (this.pointer == 0 && this.pendingPointer == 0) {
            System.arraycopy(data, 0, this.queuedUpdates, 0, data.length);
            ++this.pointer;
        } else {
            try {
                if (this.pendingPointer + 1 > this.pendingEffectiveSize) {
                    this.resizePending();
                }
                System.arraycopy(data, 0, this.pendingUpdates, this.getPendingPointer(), data.length);
                ++this.pendingPointer;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.runLoop();
    }

    public void copy() {
        int newSize = (this.pointer + this.pendingPointer) * 9;
        if (newSize > this.queuedUpdates.length) {
            this.resize(newSize);
        }
        System.arraycopy(this.pendingUpdates, this.getPendingPointer() + 9, this.queuedUpdates, this.getPointer(), this.pendingPointer * 9);
        this.pointer += this.pendingPointer;
        this.pendingPointer = 0;
        this.pendingEffectiveSize = this.minSize;
        this.pendingUpdates = new int[this.minSize * 9];
    }

    public void runLoop() {
        if (!this.processing) {
            this.processing = true;
            while (this.pointer != 0) {
                this.processBlock();
                if (this.pendingPointer == 0) continue;
                this.copy();
            }
            if (this.effectiveSize != this.minSize) {
                this.queuedUpdates = new int[this.minSize * 9];
                this.effectiveSize = this.minSize;
            }
            this.processing = false;
        }
    }

    private void processBlock() {
        --this.pointer;
        int header = this.queuedUpdates[this.getPointer()];
        int type = MemEfficientNeighborUpdater.getHeader(header);
        if (type == 0) {
            class_2338 pos = this.getPos(this.getPointer() + 1);
            class_7165.method_41708((class_1937)this.world, (class_2680)this.world.method_8320(pos), (class_2338)this.getPos(this.getPointer() + 1), (class_2248)MemEfficientNeighborUpdater.fromHeader(header), (class_2338)this.getPos(this.getPointer() + 4), (boolean)false);
        } else if (type == 1) {
            class_7165.method_41708((class_1937)this.world, (class_2680)MemEfficientNeighborUpdater.getState(this.queuedUpdates[this.getPointer() + 7]), (class_2338)this.getPos(this.getPointer() + 1), (class_2248)MemEfficientNeighborUpdater.fromHeader(header), (class_2338)this.getPos(this.getPointer() + 4), (this.queuedUpdates[this.getPointer() + 8] == 1 ? 1 : 0) != 0);
        } else if (type == 2) {
            class_7165.method_42393((class_1936)this.world, (class_2350)class_2350.method_10143((int)(header & 7)), (class_2680)MemEfficientNeighborUpdater.getState(this.queuedUpdates[this.getPointer() + 7]), (class_2338)this.getPos(this.getPointer() + 1), (class_2338)this.getPos(this.getPointer() + 4), (int)this.queuedUpdates[this.getPointer() + 8], (int)512);
        } else if (type == 3) {
            int dir = this.queuedUpdates[this.getPointer() + 4];
            int currentDirIndex = this.queuedUpdates[this.getPointer() + 5];
            if (dir != 6 && currentDirIndex < UPDATE_AMT && field_37839[currentDirIndex] == class_2350.method_10143((int)dir)) {
                ++currentDirIndex;
            }
            this.queuedUpdates[this.getPointer() + 5] = currentDirIndex + 1;
            if (currentDirIndex == UPDATE_AMT) {
                return;
            }
            class_2338 pos = this.getPos(this.getPointer() + 1);
            class_2338 blockPos = pos.method_10093(field_37839[currentDirIndex]);
            if (currentDirIndex != UPDATE_AMT) {
                ++this.pointer;
            }
            this.world.method_8320(blockPos).method_26181(this.world, blockPos, MemEfficientNeighborUpdater.fromHeader(header), pos, false);
        } else {
            throw new RuntimeException("Unknown update type: " + type + ", something went wrong.");
        }
    }

    private class_2338 getPos(int offset) {
        return new class_2338(this.queuedUpdates[offset], this.queuedUpdates[offset + 1], this.queuedUpdates[offset + 2]);
    }

    private int getPointer() {
        return this.pointer * 9;
    }

    private int getPendingPointer() {
        return (this.pendingUpdates.length / 9 - this.pendingPointer - 1) * 9;
    }

    private void resize(int size) {
        int newSize = Math.min(size, this.maxSize * 9);
        if (newSize != this.queuedUpdates.length) {
            int[] newArr = new int[newSize];
            System.arraycopy(this.queuedUpdates, 0, newArr, 0, this.queuedUpdates.length);
            this.queuedUpdates = newArr;
            this.effectiveSize = newSize / 9;
        }
    }

    private void resizePending() {
        int newSize = Math.min(this.pendingUpdates.length * 2, this.maxSize * 9);
        if (newSize != this.pendingUpdates.length) {
            int[] newArr = new int[newSize];
            System.arraycopy(this.pendingUpdates, 0, newArr, newSize - this.pendingUpdates.length, this.pendingUpdates.length);
            this.pendingUpdates = newArr;
            this.pendingEffectiveSize = newSize / 9;
        }
    }

    public void setDepth(int depth) {
        this.pointer = depth;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    private static int createDataType(class_2248 block, int extra) {
        return MemEfficientNeighborUpdater.getID(block.method_9564()) | extra << 29;
    }

    public static int getID(class_2680 blockState) {
        return class_2248.method_9507((class_2680)blockState);
    }

    public static class_2248 fromHeader(int val) {
        return MemEfficientNeighborUpdater.getBlock(val & 0x1FFFFFFF);
    }

    public static int getHeader(int val) {
        return val >> 29;
    }

    public static class_2248 getBlock(int val) {
        return MemEfficientNeighborUpdater.getState(val).method_26204();
    }

    public static class_2680 getState(int val) {
        return class_2248.method_9531((int)val);
    }
}

