/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.helpers;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;

public class RuleScheduler {
    private static final List<RuleChange<?>> scheduledRuleChanges = new ArrayList();

    public void addRule(RuleChange<?> ruleChange) {
        scheduledRuleChanges.add(ruleChange);
    }

    public <T> void addRule(Validator<T> validator, CarpetRule<T> currentRule, T newValue, String string) {
        this.addRule(new RuleChange<T>(validator, currentRule, newValue, string));
    }

    public <T> void addDefaultRule(Validator<T> validator, CarpetRule<T> currentRule, T newValue, String string, Function<MinecraftServer, T> setDefault) {
        this.addRule(new RuleChange<T>(validator, currentRule, newValue, string, setDefault));
    }

    public void onWorldLoaded(MinecraftServer server) {
        for (RuleChange<?> ruleChange : scheduledRuleChanges) {
            ruleChange.triggerValidator(server);
        }
        scheduledRuleChanges.clear();
    }

    static class RuleChange<T> {
        private final Validator<T> validator;
        private final CarpetRule<T> currentRule;
        private final T newValue;
        private final String string;
        private final Function<MinecraftServer, T> setDefault;

        public RuleChange(Validator<T> validator, CarpetRule<T> currentRule, T newValue, String string, Function<MinecraftServer, T> setDefault) {
            this.validator = validator;
            this.currentRule = currentRule;
            this.newValue = newValue;
            this.string = string;
            this.setDefault = setDefault;
        }

        public RuleChange(Validator<T> validator, CarpetRule<T> currentRule, T newValue, String string) {
            this(validator, currentRule, newValue, string, null);
        }

        public void triggerValidator(MinecraftServer server) {
            T newValue = this.newValue;
            if (this.setDefault != null) {
                newValue = this.setDefault.apply(server);
            }
            this.validator.validate(server.method_3739(), this.currentRule, newValue, this.string);
        }
    }
}

