/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.helpers;

import carpetfixes.CarpetFixesServer;
import carpetfixes.settings.CarpetFixesMixinConfigPlugin;
import java.lang.reflect.Method;
import java.util.function.Function;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static boolean isMCVersionCompat(String versionPredicate) {
        try {
            return VersionPredicate.parse((String)versionPredicate).test((Object)CarpetFixesMixinConfigPlugin.MINECRAFT_VERSION);
        }
        catch (NoClassDefFoundError e) {
            try {
                Class<?> clazz = Class.forName("net.fabricmc.loader.util.version.VersionPredicateParser");
                Method matches = clazz.getMethod("matches", Version.class, String.class);
                return (Boolean)matches.invoke(null, CarpetFixesMixinConfigPlugin.MINECRAFT_VERSION, versionPredicate);
            }
            catch (Exception ex) {
                CarpetFixesServer.LOGGER.error("Failed to invoke VersionPredicateParser#matches", (Throwable)ex);
            }
        }
        catch (Exception e) {
            CarpetFixesServer.LOGGER.error("Failed to parse version or version predicate {} {}: {}", new Object[]{CarpetFixesMixinConfigPlugin.MINECRAFT_VERSION.getFriendlyString(), versionPredicate, e});
        }
        return false;
    }

    public static boolean isInModifiableLimit(class_1937 world, class_2338 pos) {
        return !world.method_31606(pos) && world.method_8621().method_11952(pos);
    }

    public static class_238 stretchBlockBound(class_238 box, class_2350 direction, double length) {
        double d = length * (double)direction.method_10171().method_10181();
        double e = Math.min(d, 0.0);
        double f = Math.max(d, 0.0);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11039 -> new class_238(Math.ceil(box.field_1323 + e), box.field_1322, box.field_1321, Math.floor(box.field_1323 + f), box.field_1325, box.field_1324);
            case class_2350.field_11034 -> new class_238(Math.ceil(box.field_1320 + e), box.field_1322, box.field_1321, Math.floor(box.field_1320 + f), box.field_1325, box.field_1324);
            case class_2350.field_11033 -> new class_238(box.field_1323, Math.ceil(box.field_1322 + e), box.field_1321, box.field_1320, Math.floor(box.field_1322 + f), box.field_1324);
            case class_2350.field_11036 -> new class_238(box.field_1323, Math.ceil(box.field_1325 + e), box.field_1321, box.field_1320, Math.floor(box.field_1325 + f), box.field_1324);
            case class_2350.field_11043 -> new class_238(box.field_1323, box.field_1322, Math.ceil(box.field_1321 + e), box.field_1320, box.field_1325, Math.floor(box.field_1321 + f));
            case class_2350.field_11035 -> new class_238(box.field_1323, box.field_1322, Math.ceil(box.field_1324 + e), box.field_1320, box.field_1325, Math.floor(box.field_1324 + f));
        };
    }

    public static void updateComparatorsRespectFacing(class_1937 world, class_2338 fromPos, class_2248 block) {
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2338 pos = fromPos.method_10093(dir);
            if (!world.method_22340(pos)) continue;
            class_2680 state = world.method_8320(pos);
            if (state.method_27852(class_2246.field_10377)) {
                if (state.method_11654((class_2769)class_2383.field_11177) != dir.method_10153()) continue;
                state.method_26181(world, pos, block, fromPos, false);
                continue;
            }
            if (!state.method_26212((class_1922)world, pos) || !(state = world.method_8320(pos = pos.method_10093(dir))).method_27852(class_2246.field_10377) || state.method_11654((class_2769)class_2383.field_11177) != dir.method_10153()) continue;
            state.method_26181(world, pos, block, fromPos, false);
        }
    }

    public static void giveShapeUpdate(class_1937 world, class_2680 state, class_2338 pos, class_2338 fromPos, class_2350 direction) {
        class_2680 oldState = world.method_8320(pos);
        class_2248.method_9611((class_2680)oldState, (class_2680)oldState.method_26191(direction.method_10153(), state, (class_1936)world, pos, fromPos), (class_1936)world, (class_2338)pos, (int)2, (int)0);
    }

    public static void giveObserverUpdate(class_1937 world, class_2338 pos, class_2350 dir) {
        class_2338 blockPos = pos.method_10093(dir);
        world.method_8320(blockPos).method_26191(dir.method_10153(), class_2246.field_10124.method_9564(), (class_1936)world, blockPos, pos);
    }

    public static void giveObserverUpdates(class_1937 world, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.values()) {
            mutable.method_25505((class_2382)pos, direction);
            world.method_8320((class_2338)mutable).method_26191(direction.method_10153(), class_2246.field_10124.method_9564(), (class_1936)world, (class_2338)mutable, pos);
        }
    }

    public static boolean isZero(class_243 vec) {
        return vec.field_1352 == 0.0 && vec.field_1351 == 0.0 && vec.field_1350 == 0.0;
    }

    public static class_1767 properDyeMixin(class_1767 col1, class_1767 col2) {
        if (col1.equals((Object)col2)) {
            return col1;
        }
        switch (col1) {
            case field_7952: {
                switch (col2) {
                    case field_7966: {
                        return class_1767.field_7951;
                    }
                    case field_7944: {
                        return class_1767.field_7967;
                    }
                    case field_7963: {
                        return class_1767.field_7944;
                    }
                    case field_7942: {
                        return class_1767.field_7961;
                    }
                    case field_7964: {
                        return class_1767.field_7954;
                    }
                }
                break;
            }
            case field_7966: {
                switch (col2) {
                    case field_7952: {
                        return class_1767.field_7951;
                    }
                    case field_7942: {
                        return class_1767.field_7955;
                    }
                    case field_7964: {
                        return class_1767.field_7945;
                    }
                }
                break;
            }
            case field_7964: {
                switch (col2) {
                    case field_7947: {
                        return class_1767.field_7946;
                    }
                    case field_7952: {
                        return class_1767.field_7954;
                    }
                    case field_7966: {
                        return class_1767.field_7945;
                    }
                }
                break;
            }
            case field_7942: {
                switch (col2) {
                    case field_7966: {
                        return class_1767.field_7955;
                    }
                    case field_7952: {
                        return class_1767.field_7961;
                    }
                }
                break;
            }
            case field_7947: {
                if (!col2.equals((Object)class_1767.field_7964)) break;
                return class_1767.field_7946;
            }
            case field_7945: {
                if (!col2.equals((Object)class_1767.field_7954)) break;
                return class_1767.field_7958;
            }
            case field_7954: {
                if (!col2.equals((Object)class_1767.field_7945)) break;
                return class_1767.field_7958;
            }
            case field_7944: {
                if (!col2.equals((Object)class_1767.field_7952)) break;
                return class_1767.field_7967;
            }
            case field_7963: {
                if (!col2.equals((Object)class_1767.field_7952)) break;
                return class_1767.field_7944;
            }
        }
        return null;
    }

    @NotNull
    public static Function<class_1297, class_1297> reIntroduceDonkeyRidingDupe_entityFetcherFunction(class_3218 world) {
        return vehicle -> {
            class_1297 before = world.method_14190(vehicle.method_5667());
            if (before != null) {
                before.method_5651(vehicle.method_5647(new class_2487()));
                return before;
            }
            return !world.method_18768(vehicle) ? null : vehicle;
        };
    }
}

