/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo;

import com.google.gson.JsonParseException;
import io.github.a5b84.helditeminfo.HeldItemInfo;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import io.github.a5b84.helditeminfo.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public final class Appenders {
    private Appenders() {
    }

    public static void appendEnchantments(TooltipBuilder builder) {
        class_2499 enchantments;
        class_1799 stack = builder.stack;
        if (Util.hasHideFlag(stack.method_7969(), 1)) {
            return;
        }
        class_2499 class_24992 = enchantments = stack.method_7909() == class_1802.field_8598 ? class_1772.method_7806((class_1799)stack) : stack.method_7921();
        if (enchantments.isEmpty()) {
            return;
        }
        List<class_2960> filters = HeldItemInfo.filteredEnchantments;
        if (!filters.isEmpty()) {
            class_2499 filtered = new class_2499();
            for (class_2520 tag : enchantments) {
                if (!(tag instanceof class_2487)) continue;
                try {
                    class_2960 id = new class_2960(((class_2487)tag).method_10558("id"));
                    if (filters.contains(id) != HeldItemInfo.config.showOnlyFilteredEnchantments()) continue;
                    filtered.add((Object)tag);
                }
                catch (class_151 class_1512) {}
            }
            enchantments = filtered;
        }
        ArrayList enchantmentTexts = new ArrayList(enchantments.size());
        class_1799.method_17870(enchantmentTexts, (class_2499)enchantments);
        builder.appendAll(enchantmentTexts);
    }

    public static void appendContainerContent(TooltipBuilder builder) {
        boolean added = Appenders.appendContainerContent(builder, builder.stack.method_7969()) || Appenders.appendContainerContent(builder, builder.stack.method_7941("BlockEntityTag"));
    }

    private static boolean appendContainerContent(TooltipBuilder builder, class_2487 tag) {
        if (tag == null) {
            return false;
        }
        class_2499 items = tag.method_10554("Items", 10);
        if (tag.method_10573("LootTable", 8)) {
            builder.append((class_2561)class_2561.method_43470((String)"???????"));
            return true;
        }
        if (!items.isEmpty()) {
            boolean added = false;
            for (class_2520 itemElement : items) {
                class_2487 itemNbt;
                if (!(itemElement instanceof class_2487) || !Appenders.appendItem(builder, itemNbt = (class_2487)itemElement)) continue;
                added = true;
            }
            return added;
        }
        return false;
    }

    public static boolean appendItem(TooltipBuilder builder, class_2487 itemNbt) {
        if (itemNbt.method_33133()) {
            return false;
        }
        class_1799 iStack = class_1799.method_7915((class_2487)itemNbt);
        if (iStack.method_7960()) {
            return false;
        }
        class_5250 text = builder.canAdd() ? iStack.method_7964().method_27661().method_27693(" x" + iStack.method_7947()).method_27692(TooltipBuilder.DEFAULT_COLOR) : null;
        builder.append((class_2561)text);
        return true;
    }

    public static void appendLore(TooltipBuilder builder) {
        class_2487 displayTag = builder.stack.method_7941("display");
        if (displayTag == null) {
            return;
        }
        class_2499 loreTag = displayTag.method_10554("Lore", 8);
        if (loreTag.isEmpty()) {
            return;
        }
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        for (int i = 0; i < loreTag.size(); ++i) {
            String lineString = loreTag.method_10608(i);
            if (HeldItemInfo.config.removePlusNbt() && lineString.equals("\"(+NBT)\"")) continue;
            try {
                class_5250 line = class_2561.class_2562.method_10877((String)lineString);
                if (line == null) continue;
                int maxLines = Math.min(HeldItemInfo.config.maxLoreLines() - lore.size(), builder.getRemainingLines());
                List<class_5250> newLines = Util.wrapLines((class_5348)line, maxLines);
                lore.addAll(newLines);
                continue;
            }
            catch (JsonParseException e) {
                return;
            }
        }
        for (class_5250 line : lore) {
            class_2564.method_10889((class_5250)line, (class_2583)class_2583.field_24360.method_10977(TooltipBuilder.DEFAULT_COLOR));
        }
        builder.appendAll(lore);
    }

    public static void appendUnbreakable(TooltipBuilder builder) {
        if (!builder.stack.method_7909().method_7846()) {
            return;
        }
        class_2487 tag = builder.stack.method_7969();
        if (tag == null || !tag.method_10577("Unbreakable") || Util.hasHideFlag(tag, 4)) {
            return;
        }
        builder.append((class_2561)class_2561.method_43471((String)"item.unbreakable").method_27692(class_124.field_1078));
    }
}

