/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.channel;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.Channel;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.C2SMessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.MessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;

public final class C2SChannel<MSG>
extends Channel<MSG> {
    @Environment(value=EnvType.CLIENT)
    private boolean serverRegistered;

    public C2SChannel(class_2960 id, MessageType<MSG> messageType) {
        super(id, messageType);
        if (ShulkerBoxTooltip.isClient()) {
            this.serverRegistered = false;
        }
    }

    public void registerFor(class_3222 player) {
        ServerNetworking.registerC2SReceiver(this.id, player, (sender, buf) -> {
            Object message = this.messageType.decode(buf);
            C2SMessageContext context = new C2SMessageContext(sender, this);
            this.messageType.onReceive(message, context);
        });
    }

    public void unregisterFor(class_3222 player) {
        ServerNetworking.unregisterC2SReceiver(this.id, player);
    }

    @Environment(value=EnvType.CLIENT)
    public void sendToServer(MSG message) {
        class_634 handler = class_310.method_1551().method_1562();
        if (handler == null) {
            ShulkerBoxTooltip.LOGGER.error("Cannot send message to the " + this.id + " channel while not in-game");
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.messageType.encode(message, buf);
        handler.method_2883(ClientNetworking.createC2SPacket(this.id, buf));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean canSendToServer() {
        return this.serverRegistered && class_310.method_1551().method_1562() != null;
    }

    @Override
    protected void onRegister(MessageContext<MSG> context) {
        if (context.getReceivingSide() == MessageContext.Side.CLIENT) {
            this.serverRegistered = true;
        }
        super.onRegister(context);
    }

    @Override
    protected void onUnregister(MessageContext<MSG> context) {
        if (context.getReceivingSide() == MessageContext.Side.CLIENT) {
            this.serverRegistered = false;
        }
        super.onUnregister(context);
    }

    @Environment(value=EnvType.CLIENT)
    public void onDisconnect() {
        this.serverRegistered = false;
    }
}

