/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.effective.core.mixin.chest_bubbles;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.awt.Color;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3999;
import net.minecraft.class_4732;
import net.minecraft.class_4739;
import org.joml.Vector3f;
import org.ladysnake.effective.core.Effective;
import org.ladysnake.effective.core.EffectiveConfig;
import org.ladysnake.effective.core.utils.LinearForcedMotionImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_2595.class})
public class UnderwaterOpenChestBubbleSpawner<T extends class_2586> {
    @Inject(method={"clientTick"}, at={@At(value="TAIL")})
    private static void clientTick(class_1937 world, class_2338 pos, class_2680 state, class_2595 blockEntity, CallbackInfo ci) {
        boolean bl;
        boolean bl2 = bl = world != null;
        if (EffectiveConfig.underwaterOpenChestBubbles && bl && world.field_9229.method_43048(2) == 0) {
            class_2680 blockState = blockEntity.method_11010();
            class_2745 chestType = blockState.method_28498((class_2769)class_2281.field_10770) ? (class_2745)blockState.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
            class_2350 facing = blockState.method_28498((class_2769)class_2281.field_10768) ? (class_2350)blockState.method_11654((class_2769)class_2281.field_10768) : class_2350.field_11043;
            class_2248 block = blockState.method_26204();
            if (block instanceof class_4739 && world.method_22351(blockEntity.method_11016()) && world.method_22351(blockEntity.method_11016().method_10079(class_2350.field_11036, 1))) {
                class_4739 abstractChestBlock = (class_4739)block;
                boolean doubleChest = chestType != class_2745.field_12569;
                class_4732.class_4734 propertySource = abstractChestBlock.method_24167(blockState, world, blockEntity.method_11016(), true);
                float openFactor = ((Float2FloatFunction)propertySource.apply(class_2281.method_24166((class_2618)blockEntity))).get(1.0f);
                if (openFactor > 0.0f) {
                    if (doubleChest) {
                        if (chestType == class_2745.field_12574) {
                            float xOffset = 0.0f;
                            float zOffset = 0.0f;
                            float xOffsetRand = 0.0f;
                            float zOffsetRand = 0.0f;
                            if (facing == class_2350.field_11043) {
                                xOffset = 1.0f;
                                zOffset = 0.5f;
                                xOffsetRand = (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f;
                                zOffsetRand = (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.3f;
                            } else if (facing == class_2350.field_11035) {
                                xOffset = 0.0f;
                                zOffset = 0.5f;
                                xOffsetRand = (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f;
                                zOffsetRand = (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.3f;
                            } else if (facing == class_2350.field_11034) {
                                xOffset = 0.5f;
                                zOffset = 1.0f;
                                xOffsetRand = (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.3f;
                                zOffsetRand = (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f;
                            } else if (facing == class_2350.field_11039) {
                                xOffset = 0.5f;
                                zOffset = 0.0f;
                                xOffsetRand = (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.3f;
                                zOffsetRand = (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f;
                            }
                            for (int i = 0; i < 1 + world.field_9229.method_43048(3); ++i) {
                                UnderwaterOpenChestBubbleSpawner.spawnBubble(world, (float)blockEntity.method_11016().method_10263() + xOffset + xOffsetRand, (float)blockEntity.method_11016().method_10264() + 0.5f, (float)blockEntity.method_11016().method_10260() + zOffset + zOffsetRand, block == class_2246.field_10443);
                            }
                            if (openFactor <= 0.6f) {
                                UnderwaterOpenChestBubbleSpawner.spawnClosingBubble(world, (float)blockEntity.method_11016().method_10263() + xOffset, (float)blockEntity.method_11016().method_10264() + 0.5f, (float)blockEntity.method_11016().method_10260() + zOffset, facing, true, block == class_2246.field_10443);
                            }
                        }
                    } else {
                        for (int i = 0; i < 1 + world.field_9229.method_43048(3); ++i) {
                            UnderwaterOpenChestBubbleSpawner.spawnBubble(world, (float)blockEntity.method_11016().method_10263() + 0.5f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.3f, (float)blockEntity.method_11016().method_10264() + 0.5f, (float)blockEntity.method_11016().method_10260() + 0.5f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.3f, block == class_2246.field_10443);
                        }
                        if (openFactor <= 0.6f) {
                            UnderwaterOpenChestBubbleSpawner.spawnClosingBubble(world, (float)blockEntity.method_11016().method_10263() + 0.5f, (float)blockEntity.method_11016().method_10264() + 0.5f, (float)blockEntity.method_11016().method_10260() + 0.5f, facing, false, block == class_2246.field_10443);
                        }
                    }
                }
            }
        }
    }

    private static void spawnBubble(class_1937 world, float x, float y, float z, boolean endChest) {
        float bubbleSize = 0.05f + world.field_9229.method_43057() * 0.05f;
        WorldParticleBuilder.create((LodestoneWorldParticleType)Effective.BUBBLE).enableForcedSpawn().setLightLevel(endChest ? 0xF000F0 : -1).setScaleData(GenericParticleData.create((float)bubbleSize).build()).setTransparencyData(GenericParticleData.create((float)1.0f).build()).enableNoClip().setLifetime(60 + world.field_9229.method_43048(60)).setMotion(0.0, (double)bubbleSize, 0.0).setRenderType(class_3999.field_17829).setColorData(ColorParticleData.create((Color)new Color(endChest ? 65424 : 0xFFFFFF), (Color)new Color(endChest ? 65424 : 0xFFFFFF)).build()).spawn(world, (double)x, (double)y, (double)z);
    }

    private static void spawnClosingBubble(class_1937 world, float x, float y, float z, class_2350 direction, boolean doubleChest, boolean endChest) {
        for (int i = 0; i < (doubleChest ? 10 : 5); ++i) {
            float velX = 0.5f;
            float velZ = 0.5f;
            if (direction == class_2350.field_11043) {
                velX = (world.field_9229.method_43057() - world.field_9229.method_43057()) / (doubleChest ? 2.5f : 5.0f);
                velZ = -0.05f - world.field_9229.method_43057() / 5.0f;
            } else if (direction == class_2350.field_11035) {
                velX = (world.field_9229.method_43057() - world.field_9229.method_43057()) / (doubleChest ? 2.5f : 5.0f);
                velZ = 0.05f + world.field_9229.method_43057() / 5.0f;
            } else if (direction == class_2350.field_11034) {
                velX = 0.05f + world.field_9229.method_43057() / 5.0f;
                velZ = (world.field_9229.method_43057() - world.field_9229.method_43057()) / (doubleChest ? 2.5f : 5.0f);
            } else if (direction == class_2350.field_11039) {
                velX = -0.05f - world.field_9229.method_43057() / 5.0f;
                velZ = (world.field_9229.method_43057() - world.field_9229.method_43057()) / (doubleChest ? 2.5f : 5.0f);
            }
            WorldParticleBuilder.create((LodestoneWorldParticleType)Effective.BUBBLE).enableForcedSpawn().setLightLevel(endChest ? 0xF000F0 : -1).setScaleData(GenericParticleData.create((float)(0.05f + world.field_9229.method_43057() * 0.05f)).build()).setTransparencyData(GenericParticleData.create((float)1.0f).build()).enableNoClip().setLifetime(60 + world.field_9229.method_43048(60)).addTickActor((Consumer)new LinearForcedMotionImpl(new Vector3f(velX, 0.1f - world.field_9229.method_43057() * 0.1f, velZ), new Vector3f(0.0f, 0.1f, 0.0f), 10.0f)).setRenderType(class_3999.field_17829).setColorData(ColorParticleData.create((Color)new Color(endChest ? 65424 : 0xFFFFFF), (Color)new Color(endChest ? 65424 : 0xFFFFFF)).build()).spawn(world, (double)x, (double)y, (double)z);
        }
    }
}

