/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.effective.cosmetics.particle.aura;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_4051;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.ladysnake.effective.cosmetics.EffectiveCosmetics;
import org.ladysnake.effective.cosmetics.particle.LegacyFireflyParticle;

@Environment(value=EnvType.CLIENT)
public class TwilightLegacyFireflyParticle
extends LegacyFireflyParticle {
    private final class_1657 owner;

    public TwilightLegacyFireflyParticle(class_638 world, double x, double y, double z, class_4002 spriteProvider) {
        super(world, x, y, z, spriteProvider);
        this.field_3847 = 20;
        this.owner = world.method_18461(class_4051.method_36626().method_18418(1.0), this.field_3874, this.field_3854, this.field_3871);
        this.maxHeight = 2;
        Optional.ofNullable(this.owner).map(EffectiveCosmetics::getCosmeticData).ifPresentOrElse(data -> {
            this.field_3861 = (float)data.getColor1Red() / 255.0f;
            this.field_3842 = (float)data.getColor1Green() / 255.0f;
            this.field_3859 = (float)data.getColor1Blue() / 255.0f;
            this.nextAlphaGoal = 1.0f;
        }, () -> ((TwilightLegacyFireflyParticle)this).method_3085());
        this.method_3063(this.field_3874 + TwilightLegacyFireflyParticle.getWanderingDistance(this.field_3840), this.field_3854 + (double)this.field_3840.method_43057() * 2.0, this.field_3871 + TwilightLegacyFireflyParticle.getWanderingDistance(this.field_3840));
    }

    public static double getWanderingDistance(class_5819 random) {
        return random.method_43059() / 5.0;
    }

    @Override
    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        Quaternionf quaternion2;
        class_243 vec3d = camera.method_19326();
        float f = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216());
        float g = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float h = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215());
        if (this.field_3839 == 0.0f) {
            quaternion2 = camera.method_23767();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.method_23767());
            float i = class_3532.method_16439((float)tickDelta, (float)this.field_3857, (float)this.field_3839);
            quaternion2.rotateZ(i);
        }
        Vector3f Vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.method_18132(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.rotate((Quaternionfc)quaternion2);
            Vec3f2.mul(j);
            Vec3f2.add(f, g, h);
        }
        float minU = this.method_18133();
        float maxU = this.method_18134();
        float minV = this.method_18135();
        float maxV = this.method_18136();
        int l = 0xF000F0;
        float a = Math.min(1.0f, Math.max(0.0f, this.field_3841));
        vertexConsumer.method_22912((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).method_22913(maxU, minV + (maxV - minV) / 2.0f).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).method_22913(maxU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).method_22913(minU, minV).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).method_22913(minU, minV + (maxV - minV) / 2.0f).method_22915(this.field_3861, this.field_3842, this.field_3859, a).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[0].x(), (double)Vec3fs[0].y(), (double)Vec3fs[0].z()).method_22913(maxU, maxV).method_22915(1.0f, 1.0f, 1.0f, 0.005f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[1].x(), (double)Vec3fs[1].y(), (double)Vec3fs[1].z()).method_22913(maxU, minV + (maxV - minV) / 2.0f).method_22915(1.0f, 1.0f, 1.0f, 0.005f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[2].x(), (double)Vec3fs[2].y(), (double)Vec3fs[2].z()).method_22913(minU, minV + (maxV - minV) / 2.0f).method_22915(1.0f, 1.0f, 1.0f, 0.005f).method_22916(l).method_1344();
        vertexConsumer.method_22912((double)Vec3fs[3].x(), (double)Vec3fs[3].y(), (double)Vec3fs[3].z()).method_22913(minU, maxV).method_22915(1.0f, 1.0f, 1.0f, 0.005f).method_22916(l).method_1344();
    }

    @Override
    public void method_3070() {
        if (this.owner != null) {
            this.field_3858 = this.field_3874;
            this.field_3838 = this.field_3854;
            this.field_3856 = this.field_3871;
            if (this.field_3866++ >= this.field_3847) {
                this.nextAlphaGoal = -0.05f;
                if (this.field_3841 < 0.0f) {
                    this.method_3085();
                }
            }
            if (this.field_3841 > this.nextAlphaGoal - 0.05f && this.field_3841 < this.nextAlphaGoal + 0.05f) {
                this.nextAlphaGoal = this.field_3840.method_43057();
            } else if (this.nextAlphaGoal > this.field_3841) {
                this.field_3841 = Math.min(this.field_3841 + 0.05f, 1.0f);
            } else if (this.nextAlphaGoal < this.field_3841) {
                this.field_3841 = Math.max(this.field_3841 - 0.05f, 0.0f);
            }
            this.targetChangeCooldown -= new class_243(this.field_3874, this.field_3854, this.field_3871).method_1028(this.field_3858, this.field_3838, this.field_3856) < 0.0125 ? 10 : 1;
            if (this.field_3851.method_8510() % 20L == 0L && (this.xTarget == 0.0 && this.yTarget == 0.0 && this.zTarget == 0.0 || new class_243(this.field_3874, this.field_3854, this.field_3871).method_1028(this.xTarget, this.yTarget, this.zTarget) < 9.0 || this.targetChangeCooldown <= 0)) {
                this.selectBlockTarget();
            }
            class_243 targetVector = new class_243(this.xTarget - this.field_3874, this.yTarget - this.field_3854, this.zTarget - this.field_3871);
            double length = targetVector.method_1033();
            targetVector = targetVector.method_1021(0.025 / length);
            class_2680 stateBelow = this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 - 0.1), (double)this.field_3871));
            if (!stateBelow.method_26204().method_9538(stateBelow)) {
                this.field_3852 = 0.9 * this.field_3852 + 0.1 * targetVector.field_1352;
                this.field_3869 = 0.05;
                this.field_3850 = 0.9 * this.field_3850 + 0.1 * targetVector.field_1350;
            } else {
                this.field_3852 = 0.9 * this.field_3852 + 0.1 * targetVector.field_1352;
                this.field_3869 = 0.2 * this.field_3869 + 0.1 * targetVector.field_1351;
                this.field_3850 = 0.9 * this.field_3850 + 0.1 * targetVector.field_1350;
            }
            if (!class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871).equals((Object)this.getTargetPosition())) {
                this.method_3069(this.field_3852, this.field_3869, this.field_3850);
            }
        } else {
            this.method_3085();
        }
    }

    private void selectBlockTarget() {
        double groundLevel = 0.0;
        for (int i = 0; i < 20; ++i) {
            class_2680 checkedBlock = this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)(this.field_3854 - (double)i), (double)this.field_3871));
            if (!checkedBlock.method_26204().method_9538(checkedBlock)) {
                groundLevel = this.field_3854 - (double)i;
            }
            if (groundLevel != 0.0) break;
        }
        this.xTarget = this.owner.method_23317() + this.field_3840.method_43059();
        this.yTarget = Math.min(Math.max(this.owner.method_23318() + this.field_3840.method_43059(), groundLevel), groundLevel + (double)this.maxHeight);
        this.zTarget = this.owner.method_23321() + this.field_3840.method_43059();
        class_2338 targetPos = class_2338.method_49637((double)this.xTarget, (double)this.yTarget, (double)this.zTarget);
        if (this.field_3851.method_8320(targetPos).method_26234((class_1922)this.field_3851, targetPos) && this.field_3851.method_8320(targetPos).method_26212((class_1922)this.field_3851, targetPos)) {
            this.yTarget += 1.0;
        }
        this.targetChangeCooldown = this.field_3840.method_43054() % 100;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 DefaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            return new TwilightLegacyFireflyParticle(clientWorld, d, e, f, this.spriteProvider);
        }
    }
}

