/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlintBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MovingSlidyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.MovingSlidyBlockEntity;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBallEntity;
import net.mehvahdjukaar.supplementaries.common.entities.IFluteParrot;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.entities.ISlimeable;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantMenu;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.common.items.SongInstrumentItem;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.CannonBallExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.GunpowderExplosion;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundControlCannonPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundExplosionPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundFluteParrotsPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSetSlidingBlockEntityPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncSlimedMessage;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncTradesPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncEquippedQuiverPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncPartyCreeperPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClientReceivers {
    private static void withPlayerDo(Consumer<class_1657> action) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            action.accept((class_1657)player);
        }
    }

    private static void withLevelDo(Consumer<class_1937> action) {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            action.accept((class_1937)level);
        }
    }

    public static void handlePlaySpeakerMessagePacket(ClientBoundPlaySpeakerMessagePacket message) {
        class_2561 str;
        SpeakerBlockTile.Mode mode = message.mode;
        class_2561 class_25612 = str = class_310.method_1551().method_33883() ? message.filtered : message.message;
        if (mode == SpeakerBlockTile.Mode.NARRATOR && !ClientConfigs.Blocks.SPEAKER_BLOCK_MUTE.get().booleanValue()) {
            class_310.method_1551().method_44713().field_2055.say(str.getString(), true);
        } else if (mode == SpeakerBlockTile.Mode.TITLE) {
            class_329 gui = class_310.method_1551().field_1705;
            gui.method_34003();
            gui.method_1742();
            gui.method_34004(str);
        } else {
            ClientReceivers.withPlayerDo(p -> p.method_7353(str, mode == SpeakerBlockTile.Mode.STATUS_MESSAGE));
        }
    }

    public static void handleSendBombKnockbackPacket(ClientBoundSendKnockbackPacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_1297 e = l.method_8469(message.id);
            if (e != null) {
                e.method_18799(e.method_18798().method_1031(message.knockbackX, message.knockbackY, message.knockbackZ));
            }
        });
    }

    public static void handleLoginPacket(ClientBoundSendLoginPacket message) {
        ClientReceivers.withPlayerDo(p -> PlayerSuggestionBoxWidget.setUsernameCache(message.usernameCache));
    }

    public static void handleSpawnBlockParticlePacket(ClientBoundParticlePacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_5819 ran = l.field_9229;
            switch (message.type) {
                case BUBBLE_BLOW: {
                    ParticleUtil.spawnParticlesOnBlockFaces((class_1937)l, (class_2338)class_2338.method_49638((class_2374)message.pos), (class_2394)((class_2394)ModParticles.SUDS_PARTICLE.get()), (class_6019)class_6019.method_35017((int)2, (int)4), (float)0.001f, (float)0.01f, (boolean)true);
                    break;
                }
                case BUBBLE_CLEAN: {
                    ParticleUtil.spawnParticleOnBlockShape((class_1937)l, (class_2338)class_2338.method_49638((class_2374)message.pos), (class_2394)((class_2394)ModParticles.SUDS_PARTICLE.get()), (class_6019)class_6019.method_35017((int)2, (int)4), (float)0.01f);
                    break;
                }
                case WAX_ON: {
                    ParticleUtil.spawnParticleOnBlockShape((class_1937)l, (class_2338)class_2338.method_49638((class_2374)message.pos), (class_2394)class_2398.field_29642, (class_6019)class_6019.method_35017((int)3, (int)5), (float)0.01f);
                    break;
                }
                case GLOW_ON: {
                    ParticleUtil.spawnParticleOnBlockShape((class_1937)l, (class_2338)class_2338.method_49638((class_2374)message.pos), (class_2394)class_2398.field_28479, (class_6019)class_6019.method_35017((int)3, (int)5), (float)0.01f);
                    break;
                }
                case BUBBLE_CLEAN_ENTITY: {
                    class_1297 e;
                    if (message.extraData == null || (e = l.method_8469(message.extraData.intValue())) == null) break;
                    ParticleUtil.spawnParticleOnBoundingBox((class_238)e.method_5829(), (class_1937)l, (class_2394)((class_2394)ModParticles.SUDS_PARTICLE.get()), (class_6019)class_6019.method_35017((int)2, (int)4), (float)0.01f);
                    break;
                }
                case BUBBLE_EAT: {
                    class_1297 entity = l.method_8469(message.extraData.intValue());
                    class_243 v = message.dir.method_1029();
                    double x = entity.method_23317() + v.field_1352;
                    double y = entity.method_23320() + v.field_1351 - 0.12;
                    double z = entity.method_23321() + v.field_1350;
                    for (int j = 0; j < 4; ++j) {
                        v = v.method_1021(0.1 + (double)(ran.method_43057() * 0.1f));
                        double dx = v.field_1352 + (0.5 - (double)ran.method_43057()) * 0.9;
                        double dy = v.field_1351 + (0.5 - (double)ran.method_43057()) * 0.06;
                        double dz = v.field_1350 + (0.5 - (double)ran.method_43057()) * 0.9;
                        l.method_8406((class_2394)ModParticles.SUDS_PARTICLE.get(), x, y, z, dx, dy, dz);
                    }
                    break;
                }
                case DISPENSER_MINECART: {
                    boolean j1 = false;
                    boolean j2 = true;
                    boolean k2 = false;
                    double d18 = message.pos.field_1352 + (double)j1 * 0.6;
                    double d24 = message.pos.field_1351 + (double)j2 * 0.6;
                    double d28 = message.pos.field_1350 + (double)k2 * 0.6;
                    for (int i3 = 0; i3 < 10; ++i3) {
                        double d4 = ran.method_43058() * 0.2 + 0.01;
                        double d6 = d18 + (double)j1 * 0.01 + (ran.method_43058() - 0.5) * (double)k2 * 0.5;
                        double d8 = d24 + (double)j2 * 0.01 + (ran.method_43058() - 0.5) * (double)j2 * 0.5;
                        double d30 = d28 + (double)k2 * 0.01 + (ran.method_43058() - 0.5) * (double)j1 * 0.5;
                        double d9 = (double)j1 * d4 + ran.method_43059() * 0.01;
                        double d10 = (double)j2 * d4 + ran.method_43059() * 0.01;
                        double d11 = (double)k2 * d4 + ran.method_43059() * 0.01;
                        l.method_8406((class_2394)class_2398.field_11251, d6, d8, d30, d9, d10, d11);
                    }
                    break;
                }
                case FLINT_BLOCK_IGNITE: {
                    if (message.extraData == null || message.pos == null) break;
                    boolean isIronMoving = message.extraData == 1;
                    class_2338 pos = class_2338.method_49638((class_2374)message.pos);
                    for (class_2350 ironDir : class_2350.values()) {
                        class_2338 facingPos = pos.method_10093(ironDir);
                        class_2680 facingState = l.method_8320(facingPos);
                        if (!(isIronMoving ? facingState.method_27852(ModRegistry.FLINT_BLOCK.get()) : FlintBlock.canBlockCreateSpark(facingState, l, facingPos, ironDir.method_10153()))) continue;
                        for (int i = 0; i < 6; ++i) {
                            ParticleUtil.spawnParticleOnFace((class_1937)l, (class_2338)facingPos, (class_2350)ironDir.method_10153(), (class_2394)class_2398.field_11205, (float)-0.5f, (float)0.5f, (boolean)false);
                        }
                    }
                    break;
                }
                case CONFETTI: {
                    ClientReceivers.spawnConfettiParticles(message, l, ran);
                    break;
                }
                case CONFETTI_EXPLOSION: {
                    int radius = message.extraData;
                    ParticleUtil.spawnParticleInASphere((class_1937)l, (double)message.pos.field_1352, (double)(message.pos.field_1351 + 1.0), (double)message.pos.field_1350, () -> ran.method_43048(6) == 0 ? (class_2394)ModParticles.STREAMER_PARTICLE.get() : (class_2394)ModParticles.CONFETTI_PARTICLE.get(), (int)(radius * 40), (float)((float)radius / 9.0f), (float)0.05f, (float)(0.15f * (float)radius / 3.0f));
                    l.method_8486(message.pos.field_1352, message.pos.field_1351, message.pos.field_1350, ModSounds.CONFETTI_POPPER.get(), class_3419.field_15251, 4.0f, ran.method_43057() * 0.2f + 0.5f, false);
                    break;
                }
                case FEATHER: {
                    int amount = message.extraData == null ? 1 : message.extraData;
                    double dy = class_3532.method_15350((double)(0.03 * message.dir.field_1351 / 7.0), (double)0.03, (double)0.055);
                    for (int i = 0; i < amount; ++i) {
                        l.method_8406((class_2394)ModParticles.FEATHER_PARTICLE.get(), message.pos.field_1352 + ran.method_43059() * 0.35, message.pos.field_1351, message.pos.field_1350 + ran.method_43059() * 0.35, ran.method_43059() * 0.007, dy * 0.5, ran.method_43059() * 0.007);
                    }
                    break;
                }
                case WRENCH_ROTATION: {
                    if (!ClientConfigs.Items.WRENCH_PARTICLES.get().booleanValue()) break;
                    l.method_8406((class_2394)ModParticles.ROTATION_TRAIL_EMITTER.get(), message.pos.method_10216(), message.pos.method_10214(), message.pos.method_10215(), (double)message.extraData.intValue(), 0.71, -1.0);
                    break;
                }
                case PEARL_TELEPORT: {
                    class_243 start = message.pos;
                    class_243 end = message.dir;
                    for (int j = 0; j < 64; ++j) {
                        double delta = ran.method_43058();
                        float f = (ran.method_43057() - 0.5f) * 0.2f;
                        float f1 = (ran.method_43057() - 0.5f) * 0.2f;
                        float f2 = (ran.method_43057() - 0.5f) * 0.2f;
                        double dx = class_3532.method_16436((double)delta, (double)end.method_10216(), (double)start.method_10216()) + (ran.method_43058() - 0.5);
                        double dy = class_3532.method_16436((double)delta, (double)end.method_10214(), (double)start.method_10214()) + (ran.method_43058() - 0.5) - 0.5;
                        double dz = class_3532.method_16436((double)delta, (double)end.method_10215(), (double)start.method_10215()) + (ran.method_43058() - 0.5);
                        l.method_8406((class_2394)class_2398.field_11214, dx, dy, dz, (double)f, (double)f1, (double)f2);
                    }
                    break;
                }
            }
        });
    }

    public static void spawnConfettiParticles(ClientBoundParticlePacket message, class_1937 l, class_5819 ran) {
        float spread = 0.1f;
        class_243 dir = message.dir;
        class_243 pos = message.pos;
        float scale = message.extraData != null ? (float)(message.extraData + 1) * 0.8f : 1.0f;
        for (int j = 0; j < 60; ++j) {
            Vector3f facingDir = ClientReceivers.randomizeVector(ran, dir, spread).mul(scale * class_3532.method_15344((class_5819)ran, (float)0.3f, (float)0.7f));
            class_2400 p = ran.method_43048(6) == 0 ? ModParticles.STREAMER_PARTICLE.get() : ModParticles.CONFETTI_PARTICLE.get();
            l.method_8406((class_2394)p, pos.field_1352, pos.field_1351, pos.field_1350, (double)facingDir.x, (double)facingDir.y, (double)facingDir.z);
        }
        l.method_8486(message.pos.field_1352, message.pos.field_1351, message.pos.field_1350, ModSounds.CONFETTI_POPPER.get(), class_3419.field_15248, 1.0f, ran.method_43057() * 0.2f + 0.8f, false);
    }

    public static void handleSetSlidingBlockEntityPacket(ClientBoundSetSlidingBlockEntityPacket m) {
        ClientReceivers.withLevelDo(l -> {
            if (!(l.method_8321(m.pos()) instanceof MovingSlidyBlockEntity)) {
                class_2338 pos = m.pos();
                l.method_8652(m.pos(), m.state(), 64);
                class_2350 direction = m.direction();
                MovingSlidyBlockEntity be = MovingSlidyBlock.newMovingBlockEntity(pos, m.state(), m.movedState(), direction);
                l.method_8438((class_2586)be);
            }
        });
    }

    private double r(class_5819 random, double a) {
        return a * (double)(random.method_43057() + random.method_43057() - 1.0f);
    }

    public static Vector3f randomizeVector(class_5819 random, class_243 mean, float spread) {
        Vector3f facing = mean.method_46409();
        Vector3f ort = ClientReceivers.findOrthogonalVector(facing);
        ort.rotateAxis(random.method_43057() * ((float)Math.PI * 2), facing.x, facing.y, facing.z);
        ort.mul((float)(random.method_43059() * (double)spread));
        facing.add((Vector3fc)ort).normalize();
        return facing;
    }

    private static Vector3f findOrthogonalVector(Vector3f v) {
        if (Math.abs(v.x) > Math.abs(v.y)) {
            return new Vector3f(-v.z, 0.0f, v.x).normalize();
        }
        return new Vector3f(0.0f, v.z, -v.y).normalize();
    }

    public static void handleSyncAntiqueInkPacket(ClientBoundSyncAntiqueInk message) {
        ClientReceivers.withLevelDo(l -> {
            class_2586 tile = l.method_8321(message.pos());
            if (tile != null) {
                AntiqueInkItem.setAntiqueInk(tile, message.ink());
            }
        });
    }

    public static void handlePlaySongNotesPacket(ClientBoundPlaySongNotesPacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_1657 p;
            class_1792 patt0$temp;
            class_1297 e = l.method_8469(message.entityID);
            if (e instanceof class_1657 && (patt0$temp = (p = (class_1657)e).method_6030().method_7909()) instanceof SongInstrumentItem) {
                SongInstrumentItem instrumentItem = (SongInstrumentItem)patt0$temp;
                IntListIterator intListIterator = message.notes.iterator();
                while (intListIterator.hasNext()) {
                    int note = (Integer)intListIterator.next();
                    if (note <= 0) continue;
                    l.method_43128((class_1657)class_310.method_1551().field_1724, p.method_23317(), p.method_23318(), p.method_23321(), instrumentItem.getSound(), class_3419.field_15248, instrumentItem.getVolume(), instrumentItem.getPitch(note));
                    instrumentItem.spawnNoteParticle((class_1937)l, (class_1309)p, note);
                }
            }
        });
    }

    public static void handleSyncTradesPacket(ClientBoundSyncTradesPacket message) {
        ClientReceivers.withPlayerDo(p -> {
            class_1703 container = p.field_7512;
            if (message.containerId == container.field_7763 && container instanceof RedMerchantMenu) {
                RedMerchantMenu containerMenu = (RedMerchantMenu)container;
                containerMenu.setOffers(new class_1916(message.offers.method_8268()));
                containerMenu.setXp(message.villagerXp);
                containerMenu.setMerchantLevel(message.villagerLevel);
                containerMenu.setShowProgressBar(message.showProgress);
                containerMenu.setCanRestock(message.canRestock);
            }
        });
    }

    public static void handleSyncQuiverPacket(SyncEquippedQuiverPacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_1297 e = l.method_8469(message.entityID);
            if (e instanceof IQuiverEntity) {
                IQuiverEntity qe = (IQuiverEntity)e;
                qe.supplementaries$setQuiver(message.quiver);
            }
        });
    }

    public static void handleSyncPartyCreeper(SyncPartyCreeperPacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_1297 e = l.method_8469(message.entityID);
            if (e instanceof IPartyCreeper) {
                IPartyCreeper le = (IPartyCreeper)e;
                le.supplementaries$setFestive(message.on);
            }
        });
    }

    public static void handleParrotPacket(ClientBoundFluteParrotsPacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_1297 e = l.method_8469(message.playerId());
            if (e == null) {
                Supplementaries.LOGGER.error("Entity not found for parrot packet");
                return;
            }
            if (message.playing() && e instanceof class_1657) {
                class_1657 p = (class_1657)e;
                class_2338 pos = e.method_24515();
                List list = l.method_18467(class_1309.class, new class_238(pos).method_1014(3.0));
                for (class_1309 livingEntity : list) {
                    if (!(livingEntity instanceof IFluteParrot)) continue;
                    IFluteParrot fp = (IFluteParrot)livingEntity;
                    fp.supplementaries$setPartyByFlute(p);
                }
            }
            ClientReceivers.setDisplayParrotsPartying(l, (Either<class_1657, class_2338>)Either.left((Object)((class_1657)e)), message.playing());
        });
    }

    public static void setDisplayParrotsPartying(class_1937 level, Either<class_1657, class_2338> source, boolean isPartying) {
        class_2338 pos = source.right().isPresent() ? (class_2338)source.right().get() : ((class_1657)source.left().get()).method_24515();
        List list = level.method_18467(class_1657.class, new class_238(pos).method_1014(3.0));
        for (class_1657 player : list) {
            class_2487 r;
            class_2487 l = player.method_7356();
            if (l != null) {
                l.method_10556("record_playing", isPartying);
            }
            if ((r = player.method_7308()) == null) continue;
            r.method_10556("record_playing", isPartying);
        }
        class_1657 p = source.left().orElse(null);
        int r = 3;
        class_2338.class_2339 mut = pos.method_25503();
        for (int x = pos.method_10263() - r; x < pos.method_10263() + r; ++x) {
            for (int y = pos.method_10264() - r; y < pos.method_10264() + r; ++y) {
                for (int z = pos.method_10260() - r; z < pos.method_10260() + r; ++z) {
                    class_2586 class_25862 = level.method_8321((class_2338)mut.method_10103(x, y, z));
                    if (!(class_25862 instanceof IMobContainerProvider)) continue;
                    IMobContainerProvider te = (IMobContainerProvider)class_25862;
                    MobContainer container = te.getMobContainer();
                    class_1297 e = container.getDisplayedMob();
                    if (p == null && e instanceof class_1309) {
                        class_1309 le = (class_1309)e;
                        le.method_6006(pos, isPartying);
                        continue;
                    }
                    if (p == null || !(e instanceof IFluteParrot)) continue;
                    IFluteParrot fp = (IFluteParrot)e;
                    if (!isPartying) continue;
                    fp.supplementaries$setPartyByFlute(p);
                }
            }
        }
    }

    public static void handleExplosionPacket(ClientBoundExplosionPacket packet) {
        ClientReceivers.withLevelDo(l -> {
            class_243 pos = packet.pos();
            float power = packet.power();
            List<class_2338> toBlow = packet.toBlow();
            class_243 knockback = packet.knockback();
            switch (packet.type()) {
                case BOMB: {
                    BombExplosion explosion = new BombExplosion((class_1937)l, null, pos.field_1352, pos.field_1351, pos.field_1350, power, toBlow, BombEntity.BombType.values()[packet.getId()]);
                    explosion.method_8350(true);
                    if (knockback == null) break;
                    ClientReceivers.withPlayerDo(p -> p.method_18799(p.method_18798().method_1031(knockback.field_1352, knockback.field_1351, knockback.field_1350)));
                    break;
                }
                case CANNONBALL: {
                    CannonBallExplosion explosion = new CannonBallExplosion((class_1937)l, null, pos.field_1352, pos.field_1351, pos.field_1350, power, toBlow);
                    explosion.method_8350(true);
                    class_1297 patt0$temp = l.method_8469(packet.getId());
                    if (!(patt0$temp instanceof CannonBallEntity)) break;
                    CannonBallEntity le = (CannonBallEntity)patt0$temp;
                    if (knockback == null) break;
                    le.method_18799(knockback);
                    break;
                }
                case GUNPOWDER: {
                    GunpowderExplosion explosion = new GunpowderExplosion((class_1937)l, null, pos.field_1352, pos.field_1351, pos.field_1350, power);
                    explosion.method_8350(true);
                }
            }
        });
    }

    public static void handleSyncSlimed(ClientBoundSyncSlimedMessage message) {
        ClientReceivers.withLevelDo(l -> {
            class_1297 e = l.method_8469(message.id());
            if (e instanceof ISlimeable) {
                ISlimeable s = (ISlimeable)e;
                s.supp$setSlimedTicks(message.duration(), false);
            }
        });
    }

    public static void handleCannonControlPacket(ClientBoundControlCannonPacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_2586 patt0$temp = l.method_8321(message.pos());
            if (patt0$temp instanceof CannonBlockTile) {
                CannonBlockTile te = (CannonBlockTile)patt0$temp;
                CannonController.startControlling(te);
            }
        });
    }
}

