/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

public interface SlotReference {
    public static final Empty EMPTY = new Empty();
    public static final CodecMapRegistry<SlotReference> REGISTRY = (CodecMapRegistry)class_156.method_656(() -> {
        CodecMapRegistry m = new CodecMapRegistry("slot_reference");
        m.register("hand", Hand.CODEC);
        m.register("inv", Inv.CODEC);
        m.register("empty", Empty.CODEC);
        m.register("eq_slot", EqSlot.CODEC);
        m.register("quiver", Quiver.CODEC);
        return m;
    });
    public static final Codec<SlotReference> STREAM_CODEC = REGISTRY.dispatch(SlotReference::getCodec, c -> c);

    default public class_1792 getItem(class_1309 player) {
        return this.get(player).method_7909();
    }

    public class_1799 get(class_1309 var1);

    public static SlotReference hand(class_1268 pUsedHand) {
        return new Hand(pUsedHand);
    }

    public static SlotReference slot(class_1304 equipmentSlot) {
        return new EqSlot(equipmentSlot);
    }

    public static SlotReference inv(int invSlot) {
        return new Inv(invSlot);
    }

    @NotNull
    public static SlotReference quiver(IQuiverEntity e) {
        return Quiver.INSTANCE;
    }

    default public boolean isEmpty() {
        return this == EMPTY;
    }

    public Codec<? extends SlotReference> getCodec();

    public static SlotReference decode(class_2540 buf) {
        return (SlotReference)((Pair)STREAM_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)buf.method_10798()).getOrThrow(false, e -> Supplementaries.error("Failed to decode slot reference: " + e, new Object[0]))).getFirst();
    }

    public static void encode(class_2540 buf, SlotReference slotReference) {
        buf.method_10794((class_2487)STREAM_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)slotReference).getOrThrow(false, e -> Supplementaries.error("Failed to encode slot reference: " + e, new Object[0])));
    }

    public record Hand(class_1268 hand) implements SlotReference
    {
        public static final Codec<Hand> CODEC = Codec.BOOL.xmap(b -> b != false ? class_1268.field_5808 : class_1268.field_5810, h -> h == class_1268.field_5808).xmap(Hand::new, Hand::hand);

        @Override
        public class_1799 get(class_1309 player) {
            return player.method_5998(this.hand);
        }

        public Codec<Hand> getCodec() {
            return CODEC;
        }
    }

    public record EqSlot(class_1304 slot) implements SlotReference
    {
        public static final Codec<EqSlot> CODEC = Codec.INT.xmap(i -> class_1304.values()[0], Enum::ordinal).xmap(EqSlot::new, EqSlot::slot);

        @Override
        public class_1799 get(class_1309 player) {
            return player.method_6118(this.slot);
        }

        public Codec<EqSlot> getCodec() {
            return CODEC;
        }
    }

    public record Inv(int invSlot) implements SlotReference
    {
        public static final Codec<Inv> CODEC = Codec.INT.xmap(Inv::new, Inv::invSlot);

        @Override
        public class_1799 get(class_1309 player) {
            return player.method_32318(this.invSlot).method_32327();
        }

        public Codec<Inv> getCodec() {
            return CODEC;
        }
    }

    public record Quiver() implements SlotReference
    {
        private static final Quiver INSTANCE = new Quiver();
        private static final Codec<Quiver> CODEC = Codec.unit((Object)INSTANCE);

        @Override
        public class_1799 get(class_1309 player) {
            if (player instanceof class_1657) {
                class_1657 p = (class_1657)player;
                return QuiverItem.findActiveQuiver((class_1309)p);
            }
            return class_1799.field_8037;
        }

        public Codec<Quiver> getCodec() {
            return CODEC;
        }
    }

    public record Empty() implements SlotReference
    {
        public static final Codec<Empty> CODEC = Codec.unit((Object)EMPTY);

        @Override
        public class_1799 get(class_1309 player) {
            return class_1799.field_8037;
        }

        public Codec<Empty> getCodec() {
            return CODEC;
        }
    }
}

