/*
 * Decompiled with CFR 0.152.
 */
package altrisi.mods.logcleaner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogCleaner {
    public static void run() {
        Logger logger;
        Config config;
        Object object;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path path = FabricLoader.getInstance().getConfigDir().resolve("logcleaner.json");
        try {
            object = Files.newBufferedReader(path);
            try {
                config = (Config)gson.fromJson((Reader)object, Config.class);
                if (config == null) {
                    config = new Config();
                }
            }
            finally {
                if (object != null) {
                    ((BufferedReader)object).close();
                }
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            config = new Config();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to read config file!", iOException);
        }
        try {
            object = Files.newBufferedWriter(path, new OpenOption[0]);
            try {
                gson.toJson((Object)config, (Appendable)object);
            }
            finally {
                if (object != null) {
                    ((BufferedWriter)object).close();
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to save config file!", iOException);
        }
        object = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}-\\d\\.log\\.gz$");
        Instant instant = Instant.now();
        Objects.requireNonNull(config);
        Instant instant2 = instant.minus(14L, ChronoUnit.DAYS);
        int n = 0;
        try {
            logger = Files.newDirectoryStream(Paths.get("logs", new String[0]));
            try {
                for (Path path2 : logger) {
                    String string = path2.getFileName().toString();
                    if (!((Pattern)object).matcher(string).matches()) continue;
                    BasicFileAttributes basicFileAttributes = Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
                    Instant instant3 = LogCleaner.newest(basicFileAttributes.lastAccessTime(), basicFileAttributes.lastModifiedTime(), basicFileAttributes.creationTime());
                    if (instant2.compareTo(instant3) <= 0) continue;
                    Files.delete(path2);
                    ++n;
                }
            }
            finally {
                if (logger != null) {
                    logger.close();
                }
            }
        }
        catch (IOException iOException) {
            Logger logger2 = LogManager.getLogger((String)"Log Cleaner");
            logger2.error("Exception while trying to clean log files", (Throwable)iOException);
        }
        if (n > 0) {
            Objects.requireNonNull(config);
            logger = LogManager.getLogger((String)"Log Cleaner");
            logger.info("Successfully deleted {} old log files", (Object)n);
        }
    }

    private static Instant newest(FileTime ... fileTimeArray) {
        Instant instant = Instant.EPOCH;
        for (FileTime fileTime : fileTimeArray) {
            if (fileTime.toInstant().compareTo(instant) < 0) continue;
            instant = fileTime.toInstant();
        }
        return instant;
    }

    static class Config {
        final int daysOld = 14;
        final boolean silent = false;

        Config() {
        }
    }
}

