/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.client.gui.hud;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import me.roundaround.pickupnotifications.PickupNotificationsMod;
import me.roundaround.pickupnotifications.client.gui.hud.PickupNotificationLine;
import me.roundaround.pickupnotifications.event.ItemPickupCallback;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class PickupNotificationsHud {
    private static final PickupNotificationsHud INSTANCE = new PickupNotificationsHud();
    private final CopyOnWriteArrayList<PickupNotificationLine> CURRENTLY_SHOWN_NOTIFICATIONS = new CopyOnWriteArrayList();
    private final ConcurrentLinkedDeque<PickupNotificationLine> NOTIFICATION_QUEUE = new ConcurrentLinkedDeque();

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(INSTANCE::tick);
        HudRenderCallback.EVENT.register(INSTANCE::render);
        ItemPickupCallback.EVENT.register(INSTANCE::handleItemPickedUp);
    }

    private void tick(class_310 client) {
        PickupNotificationLine notification;
        if (!((Boolean)PickupNotificationsMod.CONFIG.MOD_ENABLED.getValue()).booleanValue()) {
            return;
        }
        if (this.CURRENTLY_SHOWN_NOTIFICATIONS.isEmpty()) {
            return;
        }
        for (PickupNotificationLine notification2 : this.CURRENTLY_SHOWN_NOTIFICATIONS) {
            notification2.tick();
            if (!notification2.isExpired()) continue;
            this.CURRENTLY_SHOWN_NOTIFICATIONS.remove(notification2);
        }
        while (this.hasRoomForNewNotification() && (notification = this.NOTIFICATION_QUEUE.poll()) != null) {
            notification.pop();
            this.CURRENTLY_SHOWN_NOTIFICATIONS.add(notification);
        }
    }

    private void render(class_332 drawContext, float tickDelta) {
        if (!((Boolean)PickupNotificationsMod.CONFIG.MOD_ENABLED.getValue()).booleanValue()) {
            return;
        }
        if (this.CURRENTLY_SHOWN_NOTIFICATIONS.isEmpty()) {
            return;
        }
        if (!class_310.method_1498()) {
            return;
        }
        int i = 0;
        for (PickupNotificationLine notification : this.CURRENTLY_SHOWN_NOTIFICATIONS) {
            notification.render(drawContext, i++);
        }
    }

    private void handleItemPickedUp(class_1799 itemStack) {
        boolean mergedIntoExisting = false;
        class_1799 pickedUp = itemStack.method_7972();
        if (!((Boolean)PickupNotificationsMod.CONFIG.SHOW_UNIQUE_INFO.getValue()).booleanValue()) {
            pickedUp.method_7925();
            pickedUp.method_7983("Enchantments");
        }
        for (PickupNotificationLine notification : this.CURRENTLY_SHOWN_NOTIFICATIONS) {
            if (!notification.attemptAdd(pickedUp)) continue;
            mergedIntoExisting = true;
            notification.pop();
            break;
        }
        if (!mergedIntoExisting) {
            for (PickupNotificationLine notification : this.NOTIFICATION_QUEUE) {
                if (!notification.attemptAdd(pickedUp)) continue;
                mergedIntoExisting = true;
                break;
            }
        }
        if (!mergedIntoExisting) {
            PickupNotificationLine notification = new PickupNotificationLine(pickedUp);
            if (this.NOTIFICATION_QUEUE.isEmpty() && this.hasRoomForNewNotification()) {
                notification.pop();
                this.CURRENTLY_SHOWN_NOTIFICATIONS.add(notification);
            } else {
                this.NOTIFICATION_QUEUE.add(notification);
            }
        }
    }

    private boolean hasRoomForNewNotification() {
        return this.CURRENTLY_SHOWN_NOTIFICATIONS.size() < (Integer)PickupNotificationsMod.CONFIG.MAX_NOTIFICATIONS.getValue();
    }
}

