/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.class_1799;

public class InventorySnapshot
implements Iterable<class_1799> {
    private final HashMap<String, ArrayList<class_1799>> internal = new HashMap();

    public void add(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        String key = stack.method_7909().method_7876();
        if (!this.internal.containsKey(key)) {
            this.internal.put(key, new ArrayList());
        }
        boolean merged = false;
        for (class_1799 existing : this.internal.get(key)) {
            if (!InventorySnapshot.areItemStacksMergeable(existing, stack)) continue;
            existing.method_7933(stack.method_7947());
            merged = true;
        }
        if (!merged) {
            this.internal.get(key).add(stack.method_7972());
        }
    }

    public void addAll(Iterable<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            this.add(stack.method_7972());
        }
    }

    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    public void clear() {
        this.internal.clear();
    }

    public int size() {
        return this.internal.values().stream().mapToInt(ArrayList::size).sum();
    }

    public int getCount(class_1799 source) {
        if (source.method_7960()) {
            return 0;
        }
        String key = source.method_7909().method_7876();
        if (!this.internal.containsKey(key)) {
            return 0;
        }
        for (class_1799 stack : this.internal.get(key)) {
            if (!InventorySnapshot.areItemStacksMergeable(stack, source)) continue;
            return stack.method_7947();
        }
        return 0;
    }

    public int takeFor(class_1799 source) {
        if (source.method_7960()) {
            return 0;
        }
        String key = source.method_7909().method_7876();
        if (!this.internal.containsKey(key)) {
            return 0;
        }
        ArrayList<class_1799> stacks = this.internal.get(key);
        int index = -1;
        int count = 0;
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 stack = stacks.get(i);
            if (!InventorySnapshot.areItemStacksMergeable(source, stack)) continue;
            index = i;
            count = stack.method_7947();
            break;
        }
        if (index > -1) {
            stacks.remove(index);
        }
        return count;
    }

    public InventorySnapshot diff(InventorySnapshot other) {
        class_1799 diff;
        InventorySnapshot result = new InventorySnapshot();
        for (class_1799 stack : this) {
            diff = stack.method_7972();
            diff.method_7934(other.takeFor(diff));
            result.add(diff);
        }
        for (class_1799 stack : other) {
            diff = stack.method_7972();
            diff.method_7939(-diff.method_7947());
            result.add(diff);
        }
        return result;
    }

    @Override
    public Iterator<class_1799> iterator() {
        return this.internal.values().stream().flatMap(Collection::stream).collect(Collectors.toList()).iterator();
    }

    public static boolean areItemStacksMergeable(class_1799 a, class_1799 b) {
        return !a.method_7960() && !b.method_7960() && class_1799.method_31577((class_1799)a, (class_1799)b);
    }
}

