/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.transfer;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_518;

public enum SimpleTransferHandlerImpl implements ClientInternals.SimpleTransferHandler
{
    INSTANCE;


    @Override
    public TransferHandler.Result handle(TransferHandler.Context context, SimpleTransferHandler.MissingInputRenderer missingInputRenderer, List<InputIngredient<class_1799>> inputs, Iterable<SlotAccessor> inputSlots, Iterable<SlotAccessor> inventorySlots) {
        class_465<?> containerScreen = context.getContainerScreen();
        List<InputIngredient<class_1799>> missing = SimpleTransferHandlerImpl.hasItemsIndexed(context, inventorySlots, inputs);
        if (!missing.isEmpty()) {
            IntLinkedOpenHashSet missingIndices = new IntLinkedOpenHashSet(missing.size());
            for (InputIngredient<class_1799> ingredient2 : missing) {
                missingIndices.add(ingredient2.getDisplayIndex());
            }
            return TransferHandler.Result.createFailed((class_2561)class_2561.method_43471((String)"error.rei.not.enough.materials")).renderer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> SimpleTransferHandlerImpl.lambda$handle$0(missingInputRenderer, context, inputs, missing, (IntSet)missingIndices, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6)).tooltipMissing(CollectionUtils.map(missing, ingredient -> EntryIngredients.ofItemStacks(ingredient.get())));
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed((class_2561)class_2561.method_43471((String)"error.rei.not.on.server"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().method_1507(containerScreen);
        if (containerScreen instanceof class_518) {
            class_518 listener = (class_518)containerScreen;
            listener.method_2659().field_3092.method_2571();
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(context.getDisplay().getCategoryIdentifier().getIdentifier());
        buf.writeBoolean(context.isStackedCrafting());
        buf.method_10794(this.save(context, inputs, inputSlots, inventorySlots));
        NetworkManager.sendToServer((class_2960)RoughlyEnoughItemsNetwork.MOVE_ITEMS_NEW_PACKET, (class_2540)buf);
        return TransferHandler.Result.createSuccessful();
    }

    private class_2487 save(TransferHandler.Context context, List<InputIngredient<class_1799>> inputs, Iterable<SlotAccessor> inputSlots, Iterable<SlotAccessor> inventorySlots) {
        class_2487 tag = new class_2487();
        tag.method_10569("Version", 1);
        tag.method_10566("Inputs", this.saveInputs(inputs));
        tag.method_10566("InventorySlots", this.saveSlots(context, inventorySlots));
        tag.method_10566("InputSlots", this.saveSlots(context, inputSlots));
        return tag;
    }

    private class_2520 saveSlots(TransferHandler.Context context, Iterable<SlotAccessor> slots) {
        class_2499 tag = new class_2499();
        for (SlotAccessor slot : slots) {
            tag.add((Object)SlotAccessorRegistry.getInstance().save(context.getMenu(), (class_1657)context.getMinecraft().field_1724, slot));
        }
        return tag;
    }

    private class_2520 saveInputs(List<InputIngredient<class_1799>> inputs) {
        class_2499 tag = new class_2499();
        for (InputIngredient<class_1799> input : inputs) {
            class_2487 innerTag = new class_2487();
            innerTag.method_10566("Ingredient", (class_2520)EntryIngredients.ofItemStacks(input.get()).saveIngredient());
            innerTag.method_10569("Index", input.getIndex());
            tag.add((Object)innerTag);
        }
        return tag;
    }

    public static List<InputIngredient<class_1799>> hasItemsIndexed(TransferHandler.Context context, Iterable<SlotAccessor> inventorySlots, List<InputIngredient<class_1799>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        for (SlotAccessor slot : inventorySlots) {
            recipeFinder.addNormalItem(slot.getItemStack());
        }
        ArrayList<InputIngredient<class_1799>> missing = new ArrayList<InputIngredient<class_1799>>();
        for (InputIngredient<class_1799> possibleStacks : inputs) {
            boolean done = possibleStacks.get().isEmpty();
            for (class_1799 possibleStack : possibleStacks.get()) {
                int invRequiredCount;
                if (done) continue;
                int key = RecipeFinder.getItemId(possibleStack);
                for (invRequiredCount = possibleStack.method_7947(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            missing.add(possibleStacks);
        }
        return missing;
    }

    private static /* synthetic */ void lambda$handle$0(SimpleTransferHandler.MissingInputRenderer missingInputRenderer, TransferHandler.Context context, List inputs, List missing, IntSet missingIndices, class_332 matrices, int mouseX, int mouseY, float delta, List widgets, Rectangle bounds, Display d) {
        missingInputRenderer.renderMissingInput(context, inputs, missing, missingIndices, matrices, mouseX, mouseY, delta, widgets, bounds);
    }
}

