/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerUtils;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.config.VisibilityState;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ConfirmDeletionScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.RenameScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

final class ScreenshotWidget
extends class_339
implements AutoCloseable,
ScreenshotImageHolder {
    private final ManageScreenshotsScreen mainScreen;
    private final class_310 client;
    private final Context ctx;
    private VisibilityState textVisibility;
    private float backgroundOpacityPercentage;
    private int textColor;
    private boolean renderTextShadow;
    private boolean promptOnDelete;
    private List<class_5684> hintTooltip;
    private File screenshotFile;
    private CompletableFuture<class_1011> image;
    @Nullable
    private class_1043 texture;
    private boolean selectedForDeletion;
    private float hoverTime;
    private int baseY;

    public ScreenshotWidget(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height, Context ctx, File screenshotFile) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)screenshotFile.getName()));
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.baseY = y;
        this.ctx = ctx;
        this.screenshotFile = screenshotFile;
        this.image = this.getImage(screenshotFile);
        this.onConfigUpdate();
    }

    void updateBaseY(int baseY) {
        this.baseY = baseY;
        this.method_46419(this.baseY);
    }

    void updateY(int scrollY) {
        this.method_46419(this.baseY - scrollY);
    }

    void setHeight(int height) {
        this.field_22759 = height;
    }

    void deleteScreenshot() {
        if (this.screenshotFile.exists() && !this.screenshotFile.delete()) {
            ManageScreenshotsScreen.LOGGER.error("Failed to delete 'screenshot' file at location '{}'", (Object)this.screenshotFile.toPath().toAbsolutePath());
            return;
        }
        this.ctx.removeEntry(this);
    }

    void onConfigUpdate() {
        this.textVisibility = (VisibilityState)((Object)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.SCREENSHOT_ELEMENT_TEXT_VISIBILITY, (Object)VisibilityState.VISIBLE));
        this.backgroundOpacityPercentage = (float)((Integer)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.SCREENSHOT_ELEMENT_BACKGROUND_OPACITY, (Object)100)).intValue() / 100.0f;
        this.textColor = ManageScreenshotsScreen.CONFIG.get(ScreenshotViewerOptions.SCREENSHOT_ELEMENT_TEXT_COLOR).map(class_5251::method_27716).orElse(0xFFFFFF);
        this.renderTextShadow = (Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.RENDER_SCREENSHOT_ELEMENT_FONT_SHADOW, (Object)true);
        this.promptOnDelete = (Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.PROMPT_WHEN_DELETING_SCREENSHOT, (Object)true);
        this.hintTooltip = (Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.DISPLAY_HINT_TOOLTIP, (Object)false) != false ? ScreenshotViewerUtils.toColoredComponents(this.client, (class_2561)ScreenshotViewerTexts.translatable("tooltip", "menu_hint", new Object[0]).method_27692(class_124.field_1080)) : List.of();
    }

    void updateHoverState(int mouseX, int mouseY, int viewportY, int viewportBottom, boolean updateHoverState) {
        this.field_22762 = updateHoverState && mouseX >= this.method_46426() && mouseY >= Math.max(this.method_46427(), viewportY) && mouseX < this.method_46426() + this.field_22758 && mouseY < Math.min(this.method_46427() + this.field_22759, viewportBottom);
    }

    boolean isSelectedForDeletion() {
        return this.selectedForDeletion;
    }

    void deselectForDeletion() {
        this.selectedForDeletion = false;
    }

    void render(class_332 context, int mouseX, int mouseY, float partialTick, int viewportY, int viewportBottom) {
        this.hoverTime = this.field_22762 ? this.hoverTime + partialTick : 0.0f;
        this.renderBackground(context, viewportY, viewportBottom);
        int spacing = 2;
        class_1043 image = this.texture();
        if (image != null && image.method_4525() != null) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (int)image.method_4624());
            RenderSystem.enableBlend();
            int renderY = Math.max(this.method_46427() + 2, viewportY);
            int imgHeight = (int)((double)this.field_22759 / (VisibilityState.HIDDEN.equals((Object)this.textVisibility) ? 1.0 : 1.08) - 6.0);
            int topOffset = Math.max(0, viewportY - this.method_46427() - 2);
            int bottomOffset = Math.max(0, this.method_46427() + 2 + imgHeight - viewportBottom);
            int topV = topOffset * image.method_4525().method_4323() / imgHeight;
            int bottomV = bottomOffset * image.method_4525().method_4323() / imgHeight;
            ScreenshotViewerUtils.drawTexture(context, this.method_46426() + 2, renderY, this.field_22758 - 4, imgHeight - topOffset - bottomOffset, 0, topV, image.method_4525().method_4307(), image.method_4525().method_4323() - topV - bottomV, image.method_4525().method_4307(), image.method_4525().method_4323());
            if (this.mainScreen.isFastDeleteToggled() && this.selectedForDeletion) {
                context.method_25294(this.method_46426() + 2, renderY, this.method_46426() + this.field_22758 - 2, renderY + imgHeight - topOffset - bottomOffset, 0x50FF0000);
            }
            RenderSystem.disableBlend();
        }
        if (VisibilityState.VISIBLE.equals((Object)this.textVisibility) || VisibilityState.SHOW_ON_HOVER.equals((Object)this.textVisibility) && this.field_22762) {
            float scaleFactor = (float)(this.client.method_22683().method_4502() / 96) / (float)this.ctx.screenshotsPerRow();
            int textY = this.method_46427() + (int)((double)this.field_22759 / 1.08) - 2;
            if (textY > viewportY) {
                float f = textY;
                Objects.requireNonNull(this.client.field_1772);
                if (f + scaleFactor * 9.0f < (float)viewportBottom) {
                    class_4587 matrices = context.method_51448();
                    matrices.method_22903();
                    matrices.method_46416((float)this.method_46426() + (float)this.field_22758 / 2.0f, (float)textY, 0.0f);
                    matrices.method_22905(scaleFactor, scaleFactor, scaleFactor);
                    class_2561 message = this.method_25369();
                    float centerX = -this.client.field_1772.method_27525((class_5348)this.method_25369()) / 2;
                    context.method_51439(this.client.field_1772, message, (int)centerX, 0, this.textColor, this.renderTextShadow);
                    matrices.method_22909();
                }
            }
        }
        if (!this.mainScreen.isFastDeleteToggled() && !this.hintTooltip.isEmpty() && this.hoverTime > 20.0f) {
            context.method_51422(1.0f, 1.0f, 1.0f, Math.min(this.hoverTime - 20.0f, 10.0f) / 10.0f * 0.7f);
            ScreenshotViewerUtils.renderTooltip(context, this.client.field_1772, this.hintTooltip, mouseX, mouseY);
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void renderBackground(class_332 context, int viewportY, int viewportBottom) {
        int renderY = Math.max(this.method_46427(), viewportY);
        int renderHeight = Math.min(this.method_46427() + this.field_22759, viewportBottom);
        context.method_25294(this.method_46426(), renderY, this.method_46426() + this.field_22758, renderHeight, class_5253.class_5254.method_27764((int)((int)(Math.min(this.hoverTime, 10.0f) / 10.0f * this.backgroundOpacityPercentage * 255.0f)), (int)255, (int)255, (int)255));
    }

    private void onClick() {
        if (this.mainScreen.isFastDeleteToggled()) {
            this.selectedForDeletion = !this.selectedForDeletion;
        } else {
            this.mainScreen.enlargeScreenshot(this);
        }
    }

    private void onRightClick(double mouseX, double mouseY) {
        this.mainScreen.showScreenshotProperties(mouseX, mouseY, this);
    }

    private void updateScreenshotFile(File screenshotFile) {
        this.screenshotFile = screenshotFile;
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.texture = null;
        this.image = this.getImage(screenshotFile);
    }

    private CompletableFuture<class_1011> getImage(File file) {
        return CompletableFuture.supplyAsync(() -> {
            class_1011 class_10112;
            FileInputStream inputStream = new FileInputStream(file);
            try {
                class_10112 = class_1011.method_4309((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to load screenshot: {}", (Object)file.getName(), (Object)e);
                    return null;
                }
            }
            ((InputStream)inputStream).close();
            return class_10112;
        }, class_156.method_18349());
    }

    @Nullable
    public class_1043 texture() {
        class_1011 nativeImage;
        if (this.texture != null) {
            return this.texture;
        }
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        if (this.image.isDone() && (nativeImage = this.image.join()) != null) {
            this.texture = new class_1043(nativeImage);
            return this.texture;
        }
        return null;
    }

    @Override
    public File getScreenshotFile() {
        return this.screenshotFile;
    }

    @Override
    public void openFile() {
        class_156.method_668().method_672(this.screenshotFile);
    }

    @Override
    public void copyScreenshot() {
        ScreenshotViewerUtils.copyImageToClipboard(this.screenshotFile);
    }

    @Override
    public void requestFileDeletion() {
        BooleanConsumer deleteAction = value -> {
            if (value) {
                this.deleteScreenshot();
                this.mainScreen.enlargeScreenshot(null);
            }
            this.mainScreen.setDialogScreen(null);
        };
        if (this.promptOnDelete) {
            this.mainScreen.setDialogScreen((class_437)new ConfirmDeletionScreen(deleteAction, (class_2561)class_2561.method_43469((String)"screen.screenshot_viewer.delete_prompt", (Object[])new Object[]{this.screenshotFile.getName()}), ScreenshotViewerTexts.DELETE_WARNING_MESSAGE));
            return;
        }
        deleteAction.accept(true);
    }

    @Override
    public void renameFile() {
        String fileName = this.screenshotFile.getName();
        this.mainScreen.setDialogScreen(new RenameScreenshotScreen(fileName.substring(0, fileName.lastIndexOf(46)), s -> {
            try {
                Path moved = Files.move(this.screenshotFile.toPath(), this.screenshotFile.toPath().resolveSibling((String)s), new CopyOption[0]);
                this.updateScreenshotFile(moved.toFile());
            }
            catch (IOException e) {
                ManageScreenshotsScreen.LOGGER.error("Failed to rename 'screenshot' file at '" + this.screenshotFile.toPath().toAbsolutePath() + "' from '" + this.screenshotFile.getName() + "' to '" + s + "'", (Throwable)e);
            }
        }, () -> this.mainScreen.setDialogScreen(null)));
    }

    @Override
    public int indexInList() {
        return this.ctx.currentIndex(this);
    }

    @Override
    public int imageId() {
        class_1043 texture = this.texture();
        return texture != null ? texture.method_4624() : 0;
    }

    @Override
    @Nullable
    public class_1011 image() {
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        return this.image.getNow(null);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22762 && keyCode == 67 && (modifiers & 2) != 0) {
            this.copyScreenshot();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public class_2561 method_25369() {
        return this.screenshotFile == null ? super.method_25369() : class_2561.method_43470((String)this.screenshotFile.getName());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_49606()) {
            this.method_25354(this.client.method_1483());
            if (button == 0) {
                this.onClick();
            }
            if (button == 1) {
                this.onRightClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.method_49606();
    }

    protected void method_47399(class_6382 builder) {
    }

    @Override
    public void close() {
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.image = null;
        this.texture = null;
    }

    static interface Context {
        public int screenshotsPerRow();

        public int currentIndex(ScreenshotWidget var1);

        public void removeEntry(ScreenshotWidget var1);
    }
}

