/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation.peripherals;

import com.simibubi.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NixieTubePeripheral
extends SyncedPeripheral<NixieTubeBlockEntity> {
    public NixieTubePeripheral(NixieTubeBlockEntity blockEntity) {
        super(blockEntity);
    }

    @Override
    protected void onFirstAttach() {
        super.onFirstAttach();
        class_1937 world = ((NixieTubeBlockEntity)this.blockEntity).method_10997();
        if (world == null) {
            return;
        }
        NixieTubeBlock.walkNixies((class_1936)world, ((NixieTubeBlockEntity)this.blockEntity).method_11016(), true, (currentPos, rowPosition) -> {
            class_2586 patt1251$temp = world.method_8321(currentPos);
            if (patt1251$temp instanceof NixieTubeBlockEntity) {
                NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt1251$temp;
                ntbe.displayEmptyText((int)rowPosition);
            }
        });
    }

    @Override
    protected void onLastDetach() {
        super.onLastDetach();
        class_1937 world = ((NixieTubeBlockEntity)this.blockEntity).method_10997();
        if (world == null) {
            return;
        }
        class_2680 state = world.method_8320(((NixieTubeBlockEntity)this.blockEntity).method_11016());
        if (!(state.method_26204() instanceof NixieTubeBlock)) {
            return;
        }
        NixieTubeBlock.walkNixies((class_1936)world, ((NixieTubeBlockEntity)this.blockEntity).method_11016(), false, (currentPos, rowPosition) -> {
            class_2586 patt2224$temp = world.method_8321(currentPos);
            if (patt2224$temp instanceof NixieTubeBlockEntity) {
                NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt2224$temp;
                NixieTubeBlock.updateDisplayedRedstoneValue(ntbe, true);
            }
        });
    }

    @LuaFunction(mainThread=true)
    public void setText(IArguments arguments) throws LuaException {
        class_1937 world = ((NixieTubeBlockEntity)this.blockEntity).method_10997();
        if (world == null) {
            return;
        }
        ((NixieTubeBlockEntity)this.blockEntity).computerSignal = null;
        String tagElement = class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)arguments.getString(0)));
        @Nullable String colour = arguments.optString(1, null);
        class_2680 state = null;
        class_1767 dye = null;
        if (colour != null) {
            state = ((NixieTubeBlockEntity)this.blockEntity).method_10997().method_8320(((NixieTubeBlockEntity)this.blockEntity).method_11016());
            dye = (class_1767)LuaValues.checkEnum((int)1, class_1767.class, (String)(colour.equals("grey") ? "gray" : colour));
        }
        this.changeTextNixie(tagElement, state, dye);
    }

    @LuaFunction(mainThread=true)
    public void setTextColour(String colour) throws LuaException {
        class_1937 world = ((NixieTubeBlockEntity)this.blockEntity).method_10997();
        if (world == null) {
            return;
        }
        class_2680 state = ((NixieTubeBlockEntity)this.blockEntity).method_10997().method_8320(((NixieTubeBlockEntity)this.blockEntity).method_11016());
        class_1767 dye = (class_1767)LuaValues.checkEnum((int)1, class_1767.class, (String)(colour.equals("grey") ? "gray" : colour));
        this.changeTextNixie(null, state, dye);
    }

    @LuaFunction(mainThread=true)
    public void setTextColor(String color) throws LuaException {
        this.setTextColour(color);
    }

    private void changeTextNixie(@Nullable String tagElement, @Nullable class_2680 state, @Nullable class_1767 dye) {
        class_1937 world = ((NixieTubeBlockEntity)this.blockEntity).method_10997();
        if (world == null) {
            return;
        }
        NixieTubeBlock.walkNixies((class_1936)world, ((NixieTubeBlockEntity)this.blockEntity).method_11016(), true, (currentPos, rowPosition) -> {
            if (tagElement != null) {
                ((NixieTubeBlock)((NixieTubeBlockEntity)this.blockEntity).method_11010().method_26204()).withBlockEntityDo((class_1922)world, (class_2338)currentPos, be -> be.displayCustomText(tagElement, (int)rowPosition));
            }
            if (state != null && dye != null) {
                world.method_8501(currentPos, NixieTubeBlock.withColor(state, dye));
            }
        });
    }

    @LuaFunction(mainThread=true)
    public void setSignal(IArguments arguments) throws LuaException {
        if (arguments.optTable(0).isPresent()) {
            this.setSignal(this.signal().first, arguments.getTable(0));
        }
        if (arguments.optTable(1).isPresent()) {
            this.setSignal(this.signal().second, arguments.getTable(1));
        }
    }

    private void setSignal(NixieTubeBlockEntity.ComputerSignal.TubeDisplay display, @NotNull Map<?, ?> attrs) throws LuaException {
        if (attrs.containsKey("r")) {
            display.r = this.constrainByte("r", 0, 255, attrs.get("r"));
        }
        if (attrs.containsKey("g")) {
            display.g = this.constrainByte("g", 0, 255, attrs.get("g"));
        }
        if (attrs.containsKey("b")) {
            display.b = this.constrainByte("r", 0, 255, attrs.get("b"));
        }
        if (attrs.containsKey("glowWidth")) {
            display.glowWidth = this.constrainByte("glowWidth", 1, 4, attrs.get("glowWidth"));
        }
        if (attrs.containsKey("glowHeight")) {
            display.glowHeight = this.constrainByte("glowHeight", 1, 4, attrs.get("glowHeight"));
        }
        if (attrs.containsKey("blinkPeriod")) {
            display.blinkPeriod = this.constrainByte("blinkPeriod", 0, 255, attrs.get("blinkPeriod"));
        }
        if (attrs.containsKey("blinkOffTime")) {
            display.blinkOffTime = this.constrainByte("blinkOffTime", 0, 255, attrs.get("blinkOffTime"));
        }
        if (display.r == 0 && display.g == 0 && display.b == 0) {
            display.blinkPeriod = 0;
            display.blinkOffTime = 0;
        } else if (display.blinkPeriod == 0) {
            display.blinkPeriod = 1;
            display.blinkOffTime = 0;
        }
        ((NixieTubeBlockEntity)this.blockEntity).notifyUpdate();
    }

    private byte constrainByte(String name, int min, int max, Object rawValue) throws LuaException {
        if (!(rawValue instanceof Number)) {
            throw LuaValues.badField((String)name, (String)"number", (String)LuaValues.getType((Object)rawValue));
        }
        int value = ((Number)rawValue).intValue();
        if (value < min || value > max) {
            throw new LuaException("field " + name + " must be in range " + min + "-" + max);
        }
        return (byte)value;
    }

    private NixieTubeBlockEntity.ComputerSignal signal() {
        if (((NixieTubeBlockEntity)this.blockEntity).computerSignal == null) {
            ((NixieTubeBlockEntity)this.blockEntity).computerSignal = new NixieTubeBlockEntity.ComputerSignal();
        }
        return ((NixieTubeBlockEntity)this.blockEntity).computerSignal;
    }

    @NotNull
    public String getType() {
        return "Create_NixieTube";
    }
}

