/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.render.ContraptionEntityRenderer;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ClientContraption {
    private final VirtualRenderWorld renderLevel;
    private final List<class_2586> renderedBlockEntities = new ArrayList<class_2586>();
    public final List<class_2586> renderedBlockEntityView = Collections.unmodifiableList(this.renderedBlockEntities);
    public final BitSet shouldRenderBlockEntities = new BitSet();
    public final BitSet scratchErroredBlockEntities = new BitSet();
    private final ContraptionMatrices matrices = new ContraptionMatrices();
    private final Contraption contraption;
    private int structureVersion = 0;
    private int childrenVersion = 0;

    public ClientContraption(Contraption contraption) {
        class_1937 level = contraption.entity.method_37908();
        this.contraption = contraption;
        class_2338 origin = contraption.anchor;
        int minY = VirtualRenderWorld.nextMultipleOf16(class_3532.method_15357((double)(contraption.bounds.field_1322 - 1.0)));
        int height = VirtualRenderWorld.nextMultipleOf16(class_3532.method_15384((double)(contraption.bounds.field_1325 + 1.0))) - minY;
        this.renderLevel = new VirtualRenderWorld(level, minY, height, (class_2382)origin, this::invalidateStructure){

            public boolean supportsVisualization() {
                return VisualizationManager.supportsVisualization((class_1936)this.level);
            }
        };
        this.setupRenderLevelAndRenderedBlockEntities();
    }

    public int structureVersion() {
        return this.structureVersion;
    }

    public int childrenVersion() {
        return this.childrenVersion;
    }

    public void resetRenderLevel() {
        this.renderedBlockEntities.clear();
        this.renderLevel.clear();
        this.shouldRenderBlockEntities.clear();
        this.setupRenderLevelAndRenderedBlockEntities();
        this.invalidateStructure();
        this.invalidateChildren();
    }

    public void invalidateChildren() {
        ++this.childrenVersion;
    }

    public void invalidateStructure() {
        for (class_1921 renderType : class_1921.method_22720()) {
            SuperByteBufferCache.getInstance().invalidate(ContraptionEntityRenderer.CONTRAPTION, (Object)Pair.of((Object)this.contraption, (Object)renderType));
        }
        ++this.structureVersion;
    }

    private void setupRenderLevelAndRenderedBlockEntities() {
        for (class_3499.class_3501 info : this.contraption.getBlocks().values()) {
            this.renderLevel.method_8652(info.comp_1341(), info.comp_1342(), 0);
            class_2586 blockEntity = this.readBlockEntity(this.renderLevel, info, this.contraption.getIsLegacy().getBoolean((Object)info.comp_1341()));
            if (blockEntity == null) continue;
            this.renderLevel.method_8438(blockEntity);
            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)info.comp_1342());
            if (movementBehaviour != null && movementBehaviour.disableBlockEntityRendering()) continue;
            this.renderedBlockEntities.add(blockEntity);
        }
        this.shouldRenderBlockEntities.set(0, this.renderedBlockEntities.size());
        this.renderLevel.runLightEngine();
    }

    @Nullable
    public class_2586 readBlockEntity(class_1937 level, class_3499.class_3501 info, boolean legacy) {
        class_2248 class_22482;
        class_2680 state = info.comp_1342();
        class_2338 pos = info.comp_1341();
        class_2487 nbt = info.comp_1343();
        if (legacy) {
            if (nbt == null) {
                return null;
            }
            nbt.method_10569("x", pos.method_10263());
            nbt.method_10569("y", pos.method_10264());
            nbt.method_10569("z", pos.method_10260());
            class_2586 be = class_2586.method_11005((class_2338)pos, (class_2680)state, (class_2487)nbt);
            ClientContraption.postprocessReadBlockEntity(level, be, state);
            return be;
        }
        if (!state.method_31709() || !((class_22482 = state.method_26204()) instanceof class_2343)) {
            return null;
        }
        class_2343 entityBlock = (class_2343)class_22482;
        class_2586 be = entityBlock.method_10123(pos, state);
        ClientContraption.postprocessReadBlockEntity(level, be, state);
        if (be != null && nbt != null) {
            be.method_11014(nbt);
        }
        return be;
    }

    protected static void postprocessReadBlockEntity(class_1937 level, @Nullable class_2586 be, class_2680 blockState) {
        if (be != null) {
            be.method_31662(level);
            be.method_31664(blockState);
            if (be instanceof KineticBlockEntity) {
                KineticBlockEntity kbe = (KineticBlockEntity)be;
                kbe.setSpeed(0.0f);
            }
        }
    }

    public VirtualRenderWorld getRenderLevel() {
        return this.renderLevel;
    }

    public ContraptionMatrices getMatrices() {
        return this.matrices;
    }

    public RenderedBlocks getRenderedBlocks() {
        return new RenderedBlocks(pos -> {
            class_3499.class_3501 info = this.contraption.getBlocks().get(pos);
            if (info == null) {
                return class_2246.field_10124.method_9564();
            }
            return info.comp_1342();
        }, this.contraption.getBlocks().keySet());
    }

    @Nullable
    public class_2586 getBlockEntity(class_2338 localPos) {
        return this.renderLevel.method_8321(localPos);
    }

    public BitSet getAndAdjustShouldRenderBlockEntities() {
        return this.shouldRenderBlockEntities;
    }

    public record RenderedBlocks(Function<class_2338, class_2680> lookup, Iterable<class_2338> positions) {
    }
}

