/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.SchematicAndQuillItem;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3341;
import net.minecraft.class_3499;

public class SchematicExport {
    @Nullable
    public static SchematicExportResult saveSchematic(Path dir, String fileName, boolean overwrite, class_1937 level, class_2338 first, class_2338 second) {
        class_3341 bb = class_3341.method_34390((class_2382)first, (class_2382)second);
        class_2338 origin = new class_2338(bb.method_35415(), bb.method_35416(), bb.method_35417());
        class_2338 bounds = new class_2338(bb.method_35414(), bb.method_14660(), bb.method_14663());
        class_3499 structure = new class_3499();
        structure.method_15174(level, origin, (class_2382)bounds, true, class_2246.field_10124);
        class_2487 data = structure.method_15175(new class_2487());
        SchematicAndQuillItem.replaceStructureVoidWithAir(data);
        SchematicAndQuillItem.clampGlueBoxes(level, new class_238(origin, origin.method_10081((class_2382)bounds)), data);
        if (((String)fileName).isEmpty()) {
            fileName = CreateLang.translateDirect("schematicAndQuill.fallbackName", new Object[0]).getString();
        }
        if (!overwrite) {
            fileName = FilesHelper.findFirstValidFilename((String)fileName, dir, "nbt");
        }
        if (!((String)fileName).endsWith(".nbt")) {
            fileName = (String)fileName + ".nbt";
        }
        Path file = dir.resolve((String)fileName).toAbsolutePath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            boolean overwritten = Files.deleteIfExists(file);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                class_2507.method_10634((class_2487)data, (OutputStream)out);
            }
            return new SchematicExportResult(file, dir, (String)fileName, overwritten, origin, bounds);
        }
        catch (IOException e) {
            Create.LOGGER.error("An error occurred while saving schematic [" + (String)fileName + "]", (Throwable)e);
            return null;
        }
    }

    public record SchematicExportResult(Path file, Path dir, String fileName, boolean overwritten, class_2338 origin, class_2338 bounds) {
    }
}

