/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllContraptionTypes;
import com.simibubi.create.api.behaviour.interaction.ConductorBlockInteractionBehavior;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.minecart.TrainCargoManager;
import com.simibubi.create.content.contraptions.render.ClientContraption;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.ArrivalSoundQueue;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.Pair;

public class CarriageContraption
extends Contraption {
    private class_2350 assemblyDirection;
    private boolean forwardControls;
    private boolean backwardControls;
    public Couple<Boolean> blockConductors;
    public Map<class_2338, Couple<Boolean>> conductorSeats = new HashMap<class_2338, Couple<Boolean>>();
    public ArrivalSoundQueue soundQueue;
    protected MountedStorageManager storageProxy;
    private int bogeys;
    private boolean sidewaysControls;
    private class_2338 secondBogeyPos;
    private List<class_2338> assembledBlockConductors = new ArrayList<class_2338>();
    public int portalCutoffMin;
    public int portalCutoffMax;
    static final MountedStorageManager fallbackStorage = new MountedStorageManager();

    public CarriageContraption() {
        this.blockConductors = Couple.create((Object)false, (Object)false);
        this.soundQueue = new ArrivalSoundQueue();
        this.portalCutoffMin = Integer.MIN_VALUE;
        this.portalCutoffMax = Integer.MAX_VALUE;
        this.storage = new TrainCargoManager();
    }

    public void setSoundQueueOffset(int offset) {
        this.soundQueue.offset = offset;
    }

    public CarriageContraption(class_2350 assemblyDirection) {
        this();
        this.assemblyDirection = assemblyDirection;
        this.bogeys = 0;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        if (this.blocks.size() <= 1) {
            return false;
        }
        if (this.bogeys == 0) {
            return false;
        }
        if (this.bogeys > 2) {
            throw new AssemblyException((class_2561)CreateLang.translateDirect("train_assembly.too_many_bogeys", this.bogeys));
        }
        if (this.sidewaysControls) {
            throw new AssemblyException((class_2561)CreateLang.translateDirect("train_assembly.sideways_controls", new Object[0]));
        }
        for (class_2338 blazePos : this.assembledBlockConductors) {
            for (class_2350 direction : Iterate.directionsInAxis((class_2350.class_2351)this.assemblyDirection.method_10166())) {
                if (!this.inControl(blazePos, direction)) continue;
                this.blockConductors.set(direction != this.assemblyDirection, (Object)true);
            }
        }
        for (class_2338 seatPos : this.getSeats()) {
            for (class_2350 direction : Iterate.directionsInAxis((class_2350.class_2351)this.assemblyDirection.method_10166())) {
                if (!this.inControl(seatPos, direction)) continue;
                this.conductorSeats.computeIfAbsent(seatPos, p -> Couple.create((Object)false, (Object)false)).set(direction != this.assemblyDirection, (Object)true);
            }
        }
        return true;
    }

    public boolean inControl(class_2338 pos, class_2350 direction) {
        class_2338 controlsPos = pos.method_10093(direction);
        if (!this.blocks.containsKey(controlsPos)) {
            return false;
        }
        class_3499.class_3501 info = (class_3499.class_3501)this.blocks.get(controlsPos);
        if (!AllBlocks.TRAIN_CONTROLS.has(info.comp_1342())) {
            return false;
        }
        return info.comp_1342().method_11654((class_2769)ControlsBlock.field_11177) == direction.method_10153();
    }

    public void swapStorageAfterAssembly(CarriageContraptionEntity cce) {
        Carriage carriage = cce.getCarriage();
        if (carriage.storage == null) {
            carriage.storage = (TrainCargoManager)this.storage;
            this.storage = new MountedStorageManager();
        }
        this.storageProxy = carriage.storage;
    }

    public void returnStorageForDisassembly(MountedStorageManager storage) {
        this.storage = storage;
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return false;
    }

    @Override
    protected Pair<class_3499.class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        ConductorBlockInteractionBehavior conductor;
        MovingInteractionBehaviour behaviour;
        class_2680 blockState = world.method_8320(pos);
        if (ArrivalSoundQueue.isPlayable(blockState)) {
            int anchorCoord = VecHelper.getCoordinate((class_2382)this.anchor, (class_2350.class_2351)this.assemblyDirection.method_10166());
            int posCoord = VecHelper.getCoordinate((class_2382)pos, (class_2350.class_2351)this.assemblyDirection.method_10166());
            this.soundQueue.add((posCoord - anchorCoord) * this.assemblyDirection.method_10171().method_10181(), this.toLocalPos(pos));
        }
        if (blockState.method_26204() instanceof AbstractBogeyBlock) {
            ++this.bogeys;
            if (this.bogeys == 2) {
                this.secondBogeyPos = pos;
            }
        }
        if ((behaviour = MovingInteractionBehaviour.REGISTRY.get((class_2688<class_2248, ?>)blockState)) instanceof ConductorBlockInteractionBehavior && (conductor = (ConductorBlockInteractionBehavior)behaviour).isValidConductor(blockState)) {
            this.assembledBlockConductors.add(this.toLocalPos(pos));
        }
        if (AllBlocks.TRAIN_CONTROLS.has(blockState)) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)ControlsBlock.field_11177);
            if (facing.method_10166() != this.assemblyDirection.method_10166()) {
                this.sidewaysControls = true;
            } else {
                boolean forwards;
                boolean bl = forwards = facing == this.assemblyDirection;
                if (forwards) {
                    this.forwardControls = true;
                } else {
                    this.backwardControls = true;
                }
            }
        }
        return super.capture(world, pos);
    }

    @Override
    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 tag = super.writeNBT(spawnPacket);
        NBTHelper.writeEnum((class_2487)tag, (String)"AssemblyDirection", (Enum)this.getAssemblyDirection());
        tag.method_10556("FrontControls", this.forwardControls);
        tag.method_10556("BackControls", this.backwardControls);
        tag.method_10556("FrontBlazeConductor", ((Boolean)this.blockConductors.getFirst()).booleanValue());
        tag.method_10556("BackBlazeConductor", ((Boolean)this.blockConductors.getSecond()).booleanValue());
        class_2499 list = NBTHelper.writeCompoundList(this.conductorSeats.entrySet(), e -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)((class_2338)e.getKey())));
            compoundTag.method_10556("Forward", ((Boolean)((Couple)e.getValue()).getFirst()).booleanValue());
            compoundTag.method_10556("Backward", ((Boolean)((Couple)e.getValue()).getSecond()).booleanValue());
            return compoundTag;
        });
        tag.method_10566("ConductorSeats", (class_2520)list);
        this.soundQueue.serialize(tag);
        return tag;
    }

    @Override
    public void readNBT(class_1937 world, class_2487 nbt, boolean spawnData) {
        this.assemblyDirection = (class_2350)NBTHelper.readEnum((class_2487)nbt, (String)"AssemblyDirection", class_2350.class);
        this.forwardControls = nbt.method_10577("FrontControls");
        this.backwardControls = nbt.method_10577("BackControls");
        this.blockConductors = Couple.create((Object)nbt.method_10577("FrontBlazeConductor"), (Object)nbt.method_10577("BackBlazeConductor"));
        this.conductorSeats.clear();
        NBTHelper.iterateCompoundList((class_2499)nbt.method_10554("ConductorSeats", 10), c -> this.conductorSeats.put(class_2512.method_10691((class_2487)c.method_10562("Pos")), (Couple<Boolean>)Couple.create((Object)c.method_10577("Forward"), (Object)c.method_10577("Backward"))));
        this.soundQueue.deserialize(nbt);
        super.readNBT(world, nbt, spawnData);
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        return false;
    }

    @Override
    public ContraptionType getType() {
        return (ContraptionType)AllContraptionTypes.CARRIAGE.comp_349();
    }

    public class_2350 getAssemblyDirection() {
        return this.assemblyDirection;
    }

    public boolean hasForwardControls() {
        return this.forwardControls;
    }

    public boolean hasBackwardControls() {
        return this.backwardControls;
    }

    public class_2338 getSecondBogeyPos() {
        return this.secondBogeyPos;
    }

    @Override
    public Optional<List<class_238>> getSimplifiedEntityColliders() {
        if (this.notInPortal()) {
            return super.getSimplifiedEntityColliders();
        }
        return Optional.empty();
    }

    @Override
    public boolean isHiddenInPortal(class_2338 localPos) {
        if (this.notInPortal()) {
            return super.isHiddenInPortal(localPos);
        }
        class_2350 facing = this.assemblyDirection;
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return !this.withinVisible(coord) || this.atSeam(coord);
    }

    public boolean isHiddenInPortal(int posAlongMovementAxis) {
        if (this.notInPortal()) {
            return false;
        }
        return !this.withinVisible(posAlongMovementAxis) || this.atSeam(posAlongMovementAxis);
    }

    public boolean notInPortal() {
        return this.portalCutoffMin == Integer.MIN_VALUE && this.portalCutoffMax == Integer.MAX_VALUE;
    }

    public boolean atSeam(class_2338 localPos) {
        class_2350 facing = this.assemblyDirection;
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return this.atSeam(coord);
    }

    public boolean withinVisible(class_2338 localPos) {
        class_2350 facing = this.assemblyDirection;
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return this.withinVisible(coord);
    }

    public boolean atSeam(int posAlongMovementAxis) {
        return posAlongMovementAxis == this.portalCutoffMin || posAlongMovementAxis == this.portalCutoffMax;
    }

    public boolean withinVisible(int posAlongMovementAxis) {
        return posAlongMovementAxis > this.portalCutoffMin && posAlongMovementAxis < this.portalCutoffMax;
    }

    @Override
    public MountedStorageManager getStorage() {
        return this.storageProxy == null ? fallbackStorage : this.storageProxy;
    }

    @Override
    public void writeStorage(class_2487 nbt, boolean spawnPacket) {
        if (!spawnPacket) {
            return;
        }
        if (this.storageProxy != null) {
            this.storageProxy.write(nbt, spawnPacket);
        }
    }

    @Override
    protected ClientContraption createClientContraption() {
        return new CarriageClientContraption(this);
    }

    static {
        fallbackStorage.initialize();
    }

    public class CarriageClientContraption
    extends ClientContraption {
        public final BitSet scratchBlockEntitiesOutsidePortal;

        public CarriageClientContraption(CarriageContraption contraption) {
            super(contraption);
            this.scratchBlockEntitiesOutsidePortal = new BitSet();
        }

        @Override
        public ClientContraption.RenderedBlocks getRenderedBlocks() {
            if (CarriageContraption.this.notInPortal()) {
                return super.getRenderedBlocks();
            }
            HashMap values = new HashMap();
            CarriageContraption.this.blocks.forEach((pos, info) -> {
                if (CarriageContraption.this.withinVisible((class_2338)pos)) {
                    values.put(pos, info.comp_1342());
                } else if (CarriageContraption.this.atSeam((class_2338)pos)) {
                    values.put(pos, class_2246.field_10399.method_9564());
                }
            });
            return new ClientContraption.RenderedBlocks(pos -> values.getOrDefault(pos, class_2246.field_10124.method_9564()), values.keySet());
        }

        @Override
        public class_2586 readBlockEntity(class_1937 level, class_3499.class_3501 info, boolean legacy) {
            AbstractBogeyBlock bogey;
            class_2248 class_22482 = info.comp_1342().method_26204();
            if (class_22482 instanceof AbstractBogeyBlock && !(bogey = (AbstractBogeyBlock)class_22482).captureBlockEntityForTrain()) {
                return null;
            }
            return super.readBlockEntity(level, info, legacy);
        }

        @Override
        public BitSet getAndAdjustShouldRenderBlockEntities() {
            if (CarriageContraption.this.notInPortal()) {
                return super.getAndAdjustShouldRenderBlockEntities();
            }
            this.scratchBlockEntitiesOutsidePortal.clear();
            this.scratchBlockEntitiesOutsidePortal.or(this.shouldRenderBlockEntities);
            for (int i = 0; i < this.renderedBlockEntityView.size(); ++i) {
                class_2586 be = (class_2586)this.renderedBlockEntityView.get(i);
                if (!CarriageContraption.this.isHiddenInPortal(be.method_11016())) continue;
                this.scratchBlockEntitiesOutsidePortal.clear(i);
            }
            return this.scratchBlockEntitiesOutsidePortal;
        }
    }
}

