/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.collision;

import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OBBCollider;
import net.minecraft.class_243;

public class ContinuousOBBCollider
extends OBBCollider {
    public static ContinuousSeparationManifold separateBBs(class_243 cA, class_243 cB, class_243 eA, class_243 eB, Matrix3d m, class_243 motion) {
        ContinuousSeparationManifold mf = new ContinuousSeparationManifold();
        class_243 diff = cB.method_1020(cA);
        m.transpose();
        class_243 diff2 = m.transform(diff);
        class_243 motion2 = m.transform(motion);
        m.transpose();
        double a00 = Math.abs(m.m00);
        double a01 = Math.abs(m.m01);
        double a02 = Math.abs(m.m02);
        double a10 = Math.abs(m.m10);
        double a11 = Math.abs(m.m11);
        double a12 = Math.abs(m.m12);
        double a20 = Math.abs(m.m20);
        double a21 = Math.abs(m.m21);
        double a22 = Math.abs(m.m22);
        class_243 uB0 = new class_243(m.m00, m.m10, m.m20);
        class_243 uB1 = new class_243(m.m01, m.m11, m.m21);
        class_243 uB2 = new class_243(m.m02, m.m12, m.m22);
        checkCount = 0;
        mf.stepSeparationAxis = uB1;
        mf.stepSeparation = Double.MAX_VALUE;
        mf.normalSeparation = Double.MAX_VALUE;
        if (!(ContinuousOBBCollider.separate(mf, uA0, diff.field_1352, eA.field_1352, a00 * eB.field_1352 + a01 * eB.field_1351 + a02 * eB.field_1350, motion.field_1352, true) || ContinuousOBBCollider.separate(mf, uA1, diff.field_1351, eA.field_1351, a10 * eB.field_1352 + a11 * eB.field_1351 + a12 * eB.field_1350, motion.field_1351, true) || ContinuousOBBCollider.separate(mf, uA2, diff.field_1350, eA.field_1350, a20 * eB.field_1352 + a21 * eB.field_1351 + a22 * eB.field_1350, motion.field_1350, true) || ContinuousOBBCollider.separate(mf, uB0, diff2.field_1352, eA.field_1352 * a00 + eA.field_1351 * a10 + eA.field_1350 * a20, eB.field_1352, motion2.field_1352, false) || ContinuousOBBCollider.separate(mf, uB1, diff2.field_1351, eA.field_1352 * a01 + eA.field_1351 * a11 + eA.field_1350 * a21, eB.field_1351, motion2.field_1351, false) || ContinuousOBBCollider.separate(mf, uB2, diff2.field_1350, eA.field_1352 * a02 + eA.field_1351 * a12 + eA.field_1350 * a22, eB.field_1350, motion2.field_1350, false))) {
            return mf;
        }
        return null;
    }

    static boolean separate(ContinuousSeparationManifold mf, class_243 axis, double TL, double rA, double rB, double projectedMotion, boolean axisOfObjA) {
        double dot;
        boolean isBestSeperation;
        boolean discreteCollision;
        ++checkCount;
        double distance = Math.abs(TL);
        double diff = distance - (rA + rB);
        boolean bl = discreteCollision = diff <= 0.0;
        if (!discreteCollision && Math.signum(projectedMotion) == Math.signum(TL)) {
            return true;
        }
        double sTL = Math.signum(TL);
        double seperation = sTL * Math.abs(diff);
        double entryTime = 0.0;
        double exitTime = Double.MAX_VALUE;
        if (!discreteCollision) {
            mf.isDiscreteCollision = false;
            if (Math.abs(seperation) > Math.abs(projectedMotion)) {
                return true;
            }
            entryTime = Math.abs(seperation) / Math.abs(projectedMotion);
            exitTime = (diff + Math.abs(rA) + Math.abs(rB)) / Math.abs(projectedMotion);
            mf.latestCollisionEntryTime = Math.max(entryTime, mf.latestCollisionEntryTime);
            mf.earliestCollisionExitTime = Math.min(exitTime, mf.earliestCollisionExitTime);
        }
        class_243 normalizedAxis = axis.method_1029();
        boolean bl2 = isBestSeperation = distance != 0.0 && -diff <= Math.abs(mf.separation);
        if (axisOfObjA && distance != 0.0 && -diff <= Math.abs(mf.normalSeparation)) {
            mf.normalAxis = normalizedAxis;
            mf.normalSeparation = seperation;
        }
        if ((dot = mf.stepSeparationAxis.method_1026(axis)) != 0.0 && discreteCollision) {
            class_243 cross = axis.method_1036(mf.stepSeparationAxis);
            double dotSeparation = Math.signum(dot) * TL - (rA + rB);
            double stepSeparation = -dotSeparation;
            class_243 stepSeparationVec = axis;
            if (!cross.equals((Object)class_243.field_1353)) {
                class_243 sepVec = normalizedAxis.method_1021(dotSeparation);
                class_243 axisPlane = axis.method_1036(cross);
                class_243 stepPlane = mf.stepSeparationAxis.method_1036(cross);
                stepSeparationVec = sepVec.method_1020(axisPlane.method_1021(sepVec.method_1026(stepPlane) / axisPlane.method_1026(stepPlane)));
                stepSeparation = stepSeparationVec.method_1033();
                if (Math.abs(mf.stepSeparation) > Math.abs(stepSeparation) && stepSeparation != 0.0) {
                    mf.stepSeparation = stepSeparation;
                }
            } else if (Math.abs(mf.stepSeparation) > stepSeparation) {
                mf.stepSeparation = stepSeparation;
            }
        }
        if (isBestSeperation) {
            mf.axis = normalizedAxis;
            mf.separation = seperation;
            mf.collisionPosition = normalizedAxis.method_1021(Math.signum(TL) * (axisOfObjA ? -rB : -rB) - Math.signum(seperation) * 0.125);
        }
        return false;
    }

    public static class ContinuousSeparationManifold
    extends OBBCollider.SeparationManifold {
        static final double UNDEFINED = -1.0;
        double latestCollisionEntryTime = -1.0;
        double earliestCollisionExitTime = Double.MAX_VALUE;
        boolean isDiscreteCollision = true;
        class_243 collisionPosition;
        class_243 stepSeparationAxis;
        double stepSeparation;
        class_243 normalAxis;
        double normalSeparation;

        public double getTimeOfImpact() {
            if (this.latestCollisionEntryTime == -1.0) {
                return -1.0;
            }
            if (this.latestCollisionEntryTime > this.earliestCollisionExitTime) {
                return -1.0;
            }
            return this.latestCollisionEntryTime;
        }

        public boolean isSurfaceCollision() {
            return true;
        }

        public class_243 getCollisionNormal() {
            return this.normalAxis == null ? null : this.createSeparationVec(this.normalSeparation, this.normalAxis);
        }

        public class_243 getCollisionPosition() {
            return this.collisionPosition;
        }

        public class_243 asSeparationVec(double obbStepHeight) {
            if (this.isDiscreteCollision) {
                if (this.stepSeparation <= obbStepHeight) {
                    return this.createSeparationVec(this.stepSeparation, this.stepSeparationAxis);
                }
                return super.asSeparationVec();
            }
            double t = this.getTimeOfImpact();
            if (t == -1.0) {
                return null;
            }
            return class_243.field_1353;
        }

        @Override
        public class_243 asSeparationVec() {
            return this.asSeparationVec(0.0);
        }
    }
}

