/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.infrastructure.fabric.SimpleBlockEntityVisualFactory;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.fabric.EnvExecutor;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.engine_room.flywheel.lib.visualization.SimpleBlockEntityVisualizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public class CreateBlockEntityBuilder<T extends class_2586, P>
extends BlockEntityBuilder<T, P> {
    @Nullable
    private NonNullSupplier<SimpleBlockEntityVisualFactory<T>> visualFactory;
    private Predicate<T> renderNormally;
    private Collection<NonNullSupplier<? extends Collection<NonNullSupplier<? extends class_2248>>>> deferredValidBlocks = new ArrayList<NonNullSupplier<? extends Collection<NonNullSupplier<? extends class_2248>>>>();

    public static <T extends class_2586, P> BlockEntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return new CreateBlockEntityBuilder<T, P>(owner, parent, name, callback, factory);
    }

    protected CreateBlockEntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        super(owner, parent, name, callback, factory);
    }

    public CreateBlockEntityBuilder<T, P> validBlocksDeferred(NonNullSupplier<? extends Collection<NonNullSupplier<? extends class_2248>>> blocks) {
        this.deferredValidBlocks.add(blocks);
        return this;
    }

    protected class_2591<T> createEntry() {
        this.deferredValidBlocks.stream().map(Supplier::get).flatMap(Collection::stream).forEach(arg_0 -> ((CreateBlockEntityBuilder)this).validBlock(arg_0));
        return super.createEntry();
    }

    public CreateBlockEntityBuilder<T, P> displaySource(RegistryEntry<? extends DisplaySource> source) {
        this.onRegisterAfter(CreateRegistries.DISPLAY_SOURCE, type -> DisplaySource.BY_BLOCK_ENTITY.add((class_2591<?>)type, (DisplaySource)source.get()));
        return this;
    }

    public CreateBlockEntityBuilder<T, P> displayTarget(RegistryEntry<? extends DisplayTarget> target) {
        this.onRegisterAfter(CreateRegistries.DISPLAY_TARGET, type -> DisplayTarget.BY_BLOCK_ENTITY.register((class_2591<?>)type, (DisplayTarget)target.get()));
        return this;
    }

    public CreateBlockEntityBuilder<T, P> visual(NonNullSupplier<SimpleBlockEntityVisualFactory<T>> visualFactory) {
        return this.visual(visualFactory, true);
    }

    public CreateBlockEntityBuilder<T, P> visual(NonNullSupplier<SimpleBlockEntityVisualFactory<T>> visualFactory, boolean renderNormally) {
        return this.visual(visualFactory, be -> renderNormally);
    }

    public CreateBlockEntityBuilder<T, P> visual(NonNullSupplier<SimpleBlockEntityVisualFactory<T>> visualFactory, Predicate<T> renderNormally) {
        if (this.visualFactory == null) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::registerVisualizer);
        }
        this.visualFactory = visualFactory;
        this.renderNormally = renderNormally;
        return this;
    }

    protected void registerVisualizer() {
        this.onRegister(entry -> {
            Objects.requireNonNull(this.visualFactory);
            Predicate renderNormally = this.renderNormally;
            SimpleBlockEntityVisualizer.builder((class_2591)((class_2591)this.getEntry())).factory(((SimpleBlockEntityVisualFactory)this.visualFactory.get())::create).skipVanillaRender(be -> !renderNormally.test(be)).apply();
        });
    }
}

