/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class DefaultGridBalanceHandler
implements GridBalanceHandler<class_1703> {
    @Override
    public void balanceGrid(CraftingGrid grid, class_1657 player, class_1703 menu) {
        class_1263 craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return;
        }
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            int slotIndex = ((class_1735)menu.field_7761.get(i)).method_34266();
            class_1799 itemStack = craftMatrix.method_5438(slotIndex);
            if (itemStack.method_7960() || itemStack.method_7914() <= 1) continue;
            class_2960 registryName = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
            Object key = Objects.toString(registryName);
            if (itemStack.method_7969() != null) {
                key = (String)key + "@" + String.valueOf(itemStack.method_7969());
            }
            itemMap.put(key, (Object)itemStack);
            itemCount.add(key, itemStack.method_7947());
        }
        for (String key : itemMap.keySet()) {
            List balanceList = itemMap.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / balanceList.size();
            int restCount = totalCount % balanceList.size();
            for (class_1799 itemStack : balanceList) {
                itemStack.method_7939(countPerStack);
            }
            int idx = 0;
            while (restCount > 0) {
                class_1799 itemStack;
                itemStack = (class_1799)balanceList.get(idx);
                if (itemStack.method_7947() < itemStack.method_7914()) {
                    itemStack.method_7933(1);
                    --restCount;
                }
                if (++idx < balanceList.size()) continue;
                idx = 0;
            }
        }
        menu.method_7623();
    }

    @Override
    public void spreadGrid(CraftingGrid grid, class_1657 player, class_1703 menu) {
        boolean emptyBiggestSlot;
        class_1263 craftMatrix = grid.getCraftingMatrix(player, menu);
        if (craftMatrix == null) {
            return;
        }
        do {
            class_1799 biggestSlotStack = null;
            int biggestSlotSize = 1;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((class_1735)menu.field_7761.get(i)).method_34266();
                class_1799 itemStack = craftMatrix.method_5438(slotIndex);
                if (itemStack.method_7960() || itemStack.method_7947() <= biggestSlotSize) continue;
                biggestSlotStack = itemStack;
                biggestSlotSize = itemStack.method_7947();
            }
            if (biggestSlotStack == null) {
                return;
            }
            emptyBiggestSlot = false;
            for (int i = start; i < start + size; ++i) {
                int slotIndex = ((class_1735)menu.field_7761.get(i)).method_34266();
                class_1799 itemStack = craftMatrix.method_5438(slotIndex);
                if (!itemStack.method_7960()) continue;
                if (biggestSlotStack.method_7947() > 1) {
                    craftMatrix.method_5447(slotIndex, biggestSlotStack.method_7971(1));
                    continue;
                }
                emptyBiggestSlot = true;
            }
        } while (emptyBiggestSlot);
        this.balanceGrid(grid, player, menu);
    }
}

