/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api.impl;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.api.ButtonStyle;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.GridGuiHandler;
import net.blay09.mods.craftingtweaks.api.InternalClientMethods;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClient;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClientProviderManager;
import net.blay09.mods.craftingtweaks.client.GuiTweakButton;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.network.BalanceMessage;
import net.blay09.mods.craftingtweaks.network.ClearMessage;
import net.blay09.mods.craftingtweaks.network.RotateMessage;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;

public class InternalClientMethodsImpl
implements InternalClientMethods {
    @Override
    public class_4185 createTweakButton(CraftingGrid grid, @Nullable class_465<?> screen, int x, int y, ButtonStyle style, TweakType tweak, TweakType altTweak) {
        return new GuiTweakButton(screen, x, y, style, grid, tweak, altTweak){

            @Override
            protected void onTweakButtonClicked(class_1657 player, class_1703 container, CraftingGrid grid, TweakType tweak) {
                InternalClientMethodsImpl.executeTweak(player, container, grid, tweak);
            }
        };
    }

    @Override
    public <TScreen extends class_465<TMenu>, TMenu extends class_1703> void registerCraftingGridGuiHandler(Class<TScreen> clazz, GridGuiHandler handler) {
        CraftingTweaksClientProviderManager.registerCraftingGridGuiHandler(clazz, handler);
    }

    private static void executeTweak(class_1657 player, class_1703 container, CraftingGrid grid, TweakType tweak) {
        switch (tweak) {
            case Balance: 
            case Spread: {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.getNetworking().sendToServer((Object)new BalanceMessage(grid.getId(), tweak == TweakType.Spread));
                    break;
                }
                ClientProvider clientProvider = CraftingTweaksClient.getClientProvider();
                if (tweak == TweakType.Spread) {
                    clientProvider.spreadGrid(player, container, grid);
                    break;
                }
                if (CraftingTweaksConfig.getActive().client.hyperOptimizedClientsideBalancing) {
                    clientProvider.balanceGridNew(player, container, grid);
                    break;
                }
                clientProvider.balanceGrid(player, container, grid);
                break;
            }
            case Rotate: 
            case RotateCounterClockwise: {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.getNetworking().sendToServer((Object)new RotateMessage(grid.getId(), tweak == TweakType.RotateCounterClockwise));
                    break;
                }
                ClientProvider clientProvider = CraftingTweaksClient.getClientProvider();
                clientProvider.rotateGrid(player, container, grid, tweak == TweakType.RotateCounterClockwise);
                break;
            }
            case ForceClear: 
            case Clear: {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.getNetworking().sendToServer((Object)new ClearMessage(grid.getId(), tweak == TweakType.ForceClear));
                    break;
                }
                ClientProvider clientProvider = CraftingTweaksClient.getClientProvider();
                clientProvider.clearGrid(player, container, grid, tweak == TweakType.ForceClear);
            }
        }
    }
}

