/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1830;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2356;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public abstract class EffectWindowEntry {
    private static final Supplier<Map<class_1291, List<class_1799>>> STATIC_CACHE = Suppliers.memoize(EffectWindowEntry::buildStaticCache);
    protected final List<class_5348> description;
    protected final class_1293 effect;

    protected EffectWindowEntry(class_1293 effectInstance, List<class_5348> description) {
        this.description = description;
        this.effect = effectInstance;
    }

    public List<class_5348> getDescription() {
        return this.description;
    }

    public class_1293 getEffect() {
        return this.effect;
    }

    private static Map<class_1291, List<class_1799>> buildStaticCache() {
        HashMap<class_1291, List<class_1799>> effectProvidingItems = new HashMap<class_1291, List<class_1799>>();
        for (class_2248 b : class_7923.field_41175) {
            if (!(b instanceof class_2356)) continue;
            class_2356 flowerblock = (class_2356)b;
            class_1799 stew = new class_1799((class_1935)class_1802.field_8766);
            class_1291 effect = flowerblock.method_10188();
            class_1830.method_8021((class_1799)stew, (class_1291)effect, (int)200);
            effectProvidingItems.computeIfAbsent(effect, i -> new ItemStackList()).add(stew);
        }
        for (class_1792 i2 : class_7923.field_41178) {
            class_4174 food = i2.method_19264();
            if (food == null) continue;
            class_1799 foodItem = new class_1799((class_1935)i2);
            for (Pair pair : food.method_19235()) {
                class_1293 first = (class_1293)pair.getFirst();
                if (first == null) continue;
                effectProvidingItems.computeIfAbsent(first.method_5579(), s -> new ItemStackList()).add(foodItem);
            }
        }
        for (class_1291[] array : class_2580.field_11801) {
            for (class_1291 e : array) {
                effectProvidingItems.computeIfAbsent(e, s -> new ItemStackList()).add(class_1802.field_8668.method_7854());
            }
        }
        return effectProvidingItems;
    }

    public static List<class_1291> computeEffectProviders(class_1291 effect) {
        ArrayList<class_1291> list = new ArrayList<class_1291>();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            List recipes = world.method_8433().method_30027(Jeed.getEffectProviderType());
            for (EffectProviderRecipe recipeHolder : recipes) {
                for (class_1291 e : recipeHolder.getEffects()) {
                    if (e != effect) continue;
                    list.addAll(recipeHolder.effectProviders);
                }
            }
        }
        return list;
    }

    public static List<class_3611> computeFluidProvides(class_1291 effect) {
        ArrayList<class_3611> list = new ArrayList<class_3611>();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            List recipes = world.method_8433().method_30027(Jeed.getEffectProviderType());
            for (EffectProviderRecipe recipeHolder : recipes) {
                for (class_1291 e : recipeHolder.getEffects()) {
                    if (e != effect) continue;
                    list.addAll(recipeHolder.fluidProviders);
                }
            }
        }
        return list;
    }

    public static List<class_1799> computeItemProviders(class_1291 effect) {
        List<class_1799> stat;
        ItemStackList list = new ItemStackList();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            List recipes = world.method_8433().method_30027(Jeed.getEffectProviderType());
            for (EffectProviderRecipe p : recipes) {
                for (class_1291 e2 : p.getEffects()) {
                    if (e2 != effect) continue;
                    for (class_1856 i : p.method_8117()) {
                        list.addAll(List.of(i.method_8105()));
                    }
                }
            }
            List potionRecipes = world.method_8433().method_30027(Jeed.getPotionProviderType());
            for (PotionProviderRecipe p : potionRecipes) {
                List<Object> acceptablePotions = p.getPotions();
                if (acceptablePotions.isEmpty()) {
                    acceptablePotions = class_7923.field_41179.method_10220().toList();
                }
                for (class_1842 potion : acceptablePotions) {
                    if (!potion.method_8049().stream().anyMatch(e -> e.method_5579() == effect)) continue;
                    for (class_1856 ing : p.method_8117()) {
                        for (class_1799 stack : ing.method_8105()) {
                            class_1799 copy = stack.method_7972();
                            class_1844.method_8061((class_1799)copy, (class_1842)potion);
                            list.add(copy);
                        }
                    }
                }
            }
        }
        if ((stat = STATIC_CACHE.get().get(effect)) != null) {
            list.addAll(stat);
        }
        return list;
    }

    public static List<class_1856> groupIngredients(List<class_1799> ingredients) {
        HashMap<class_1792, class_1856> map = new HashMap<class_1792, class_1856>();
        for (class_1799 stack : ingredients) {
            map.merge(stack.method_7909(), class_1856.method_8101((class_1799[])new class_1799[]{stack}), EffectWindowEntry::mergeIngredients);
        }
        ArrayList<Map.Entry<class_1792, class_1856>> entryList = EffectWindowEntry.sortIngredients(map);
        ArrayList<class_1856> list = new ArrayList<class_1856>();
        for (Map.Entry<class_1792, class_1856> entry : entryList) {
            list.add(entry.getValue());
        }
        return list;
    }

    private static class_1856 mergeIngredients(class_1856 ingredient, class_1856 ingredient1) {
        return EffectWindowEntry.mergeIngredients(List.of(ingredient, ingredient1));
    }

    public static class_1856 mergeIngredients(List<class_1856> ingredients) {
        ArrayList<class_1799> l = new ArrayList<class_1799>();
        for (class_1856 i : ingredients) {
            l.addAll(Arrays.stream(i.method_8105()).toList());
        }
        return class_1856.method_8101((class_1799[])l.toArray(new class_1799[0]));
    }

    @NotNull
    private static ArrayList<Map.Entry<class_1792, class_1856>> sortIngredients(Map<class_1792, class_1856> map) {
        ArrayList<Map.Entry<class_1792, class_1856>> entryList = new ArrayList<Map.Entry<class_1792, class_1856>>(map.entrySet());
        entryList.sort((a, b) -> Constants.ID_COMPARATOR.compare(class_7923.field_41178.method_10221((Object)((class_1792)a.getKey())), class_7923.field_41178.method_10221((Object)((class_1792)b.getKey()))));
        return entryList;
    }

    public static <T, I> List<I> divideIntoSlots(List<T> ingredients, Function<List<T>, I> mapper) {
        ArrayList slotContents = new ArrayList();
        for (int slotId = 0; slotId < ingredients.size(); ++slotId) {
            int ind = slotId % (Constants.SLOTS_PER_ROW * Constants.ROWS);
            if (slotContents.size() <= ind) {
                slotContents.add(new ArrayList());
            }
            ((List)slotContents.get(ind)).add(ingredients.get(slotId));
        }
        return slotContents.stream().map(mapper).toList();
    }

    public static class_2561 getDescription(class_1291 effect) {
        class_2960 name = class_7923.field_41174.method_10221((Object)effect);
        String descriptionKey = "effect." + name.method_12836() + "." + name.method_12832() + ".description";
        class_5250 text = class_2561.method_43471((String)descriptionKey);
        if (text.getString().equals(descriptionKey)) {
            text = class_2561.method_43471((String)"jeed.description.missing");
        }
        return text;
    }

    public static int getListHeight(List<?> inputs) {
        int listH = 0;
        if (Jeed.hasIngredientList() && !inputs.isEmpty()) {
            listH = Constants.MAX_BOX_HEIGHT;
            if (inputs.size() <= Constants.SLOTS_PER_ROW) {
                listH /= 2;
            }
        }
        return listH;
    }

    private static class ItemStackList
    extends ArrayList<class_1799> {
        @Override
        public boolean add(class_1799 stack) {
            if (stack.method_7960()) {
                return false;
            }
            for (class_1799 thisStack : this) {
                if (!class_1799.method_7973((class_1799)thisStack, (class_1799)stack)) continue;
                return false;
            }
            return super.add(stack);
        }
    }
}

