/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.mixins.coreSystemFixes.updateSuppression;

import carpet.utils.Messenger;
import carpetfixes.CFSettings;
import carpetfixes.helpers.UpdateSuppressionException;
import carpetfixes.mixins.accessors.MinecraftServerAccessor;
import java.util.function.BooleanSupplier;
import net.minecraft.class_148;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public class MinecraftServer_crashFixMixin {
    private final MinecraftServer self = (MinecraftServer)this;
    private final MinecraftServerAccessor selfAccessor = (MinecraftServerAccessor)this.self;

    @Redirect(method={"tickWorlds"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;tick(Ljava/util/function/BooleanSupplier;)V"))
    private void replacedThisMethodIgnoreIt_CarpetFixesIsNotCausingLag(class_3218 serverWorld, BooleanSupplier shouldKeepTicking) {
        if (!CFSettings.updateSuppressionCrashFix && !CFSettings.simulatedOutOfMemoryCrashFix) {
            serverWorld.method_18765(shouldKeepTicking);
            return;
        }
        try {
            serverWorld.method_18765(shouldKeepTicking);
        }
        catch (class_148 e) {
            Throwable cause = e.getCause();
            if (CFSettings.updateSuppressionCrashFix && cause instanceof UpdateSuppressionException) {
                this.logException("UpdateSuppression", "world tick");
            }
            if (CFSettings.simulatedOutOfMemoryCrashFix && cause instanceof OutOfMemoryError) {
                this.logException("OOM", "world tick");
            }
            throw e;
        }
        catch (UpdateSuppressionException e) {
            if (CFSettings.updateSuppressionCrashFix) {
                this.logException("UpdateSuppression", "world tick");
            }
            throw e;
        }
        catch (OutOfMemoryError e) {
            if (CFSettings.simulatedOutOfMemoryCrashFix) {
                this.logException("OOM", "world tick");
            }
            throw e;
        }
    }

    @Inject(method={"runTasksTillTickEnd()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void catchExceptionsDuringNetworking(CallbackInfo ci) {
        if (!CFSettings.simulatedOutOfMemoryCrashFix) {
            return;
        }
        ci.cancel();
        try {
            this.self.method_16075();
            this.self.method_18857(() -> !this.selfAccessor.invokeShouldKeepTicking());
        }
        catch (class_148 e) {
            if (CFSettings.simulatedOutOfMemoryCrashFix && e.getCause() instanceof OutOfMemoryError) {
                this.logException("OOM", "packets");
            }
            throw e;
        }
        catch (OutOfMemoryError e) {
            if (CFSettings.simulatedOutOfMemoryCrashFix) {
                this.logException("OOM", "packets");
            }
            throw e;
        }
    }

    private void logException(String source, String location) {
        Messenger.print_server_message((MinecraftServer)((MinecraftServer)this), (String)(source + ") You just caused a server crash in " + location));
    }
}

