/*
 * Decompiled with CFR 0.152.
 */
package carpetfixes.settings;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.Validator;
import carpetfixes.CFSettings;
import carpetfixes.CarpetFixesServer;
import carpetfixes.helpers.BlockUpdateUtils;
import carpetfixes.helpers.DirectionUtils;
import carpetfixes.helpers.MemEfficientNeighborUpdater;
import carpetfixes.mixins.accessors.AbstractPressurePlateBlockAccessor;
import carpetfixes.mixins.accessors.WorldAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2276;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_7159;
import net.minecraft.class_7164;
import net.minecraft.class_7165;
import net.minecraft.server.MinecraftServer;

public class Validators {

    public static class enableCustomRedstoneRuleValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            CFSettings.useCustomRedstoneUpdates = newValue != false ? true : CFSettings.duplicateBlockUpdatesFix || CFSettings.extendedBlockUpdateOrderFix || CFSettings.redstoneComponentUpdateOrderOnBreakFix || CFSettings.uselessSelfBlockUpdateFix || CFSettings.parityRandomBlockUpdates;
            return newValue;
        }
    }

    public static class wrongPressurePlateHitboxValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            AbstractPressurePlateBlockAccessor.setBox(newValue != false ? new class_238(0.075, 0.0, 0.075, 0.925, 0.25, 0.925) : new class_238(0.125, 0.0, 0.125, 0.875, 0.25, 0.875));
            return newValue;
        }
    }

    public static class optimizedNeighborUpdaterValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            if (source != null && CarpetFixesServer.areWorldsLoaded) {
                if (!CFSettings.reIntroduceInstantBlockUpdates) {
                    for (class_3218 world : source.method_9211().method_3738()) {
                        ((WorldAccessor)world).setNeighborUpdater(newValue != false ? new MemEfficientNeighborUpdater((class_1937)world, source.method_9211().method_41239()) : new class_7159((class_1937)world, source.method_9211().method_41239()));
                    }
                }
            } else {
                CarpetFixesServer.ruleScheduler.addRule(this, currentRule, newValue, string);
            }
            return newValue;
        }
    }

    public static class parityRandomBlockUpdatesValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            if (newValue.booleanValue()) {
                if (!CFSettings.blockUpdateOrderFix) {
                    BlockUpdateUtils.blockUpdateDirections = DirectionUtils::randomDirectionArray;
                }
            } else if (!CFSettings.blockUpdateOrderFix) {
                BlockUpdateUtils.blockUpdateDirections = b -> class_7165.field_37839;
            }
            return newValue;
        }
    }

    public static class blockUpdateOrderValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            BlockUpdateUtils.blockUpdateDirections = newValue != false ? b -> DirectionUtils.directions : (CFSettings.parityRandomBlockUpdates ? DirectionUtils::randomDirectionArray : b -> class_7165.field_37839);
            return newValue;
        }
    }

    public static class reIntroduceInstantBlockUpdatesValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            if (source != null && CarpetFixesServer.areWorldsLoaded) {
                for (class_3218 world : source.method_9211().method_3738()) {
                    ((WorldAccessor)world).setNeighborUpdater((class_7165)(newValue != false ? new class_7164((class_1937)world) : (CFSettings.optimizedNeighborUpdater ? new MemEfficientNeighborUpdater((class_1937)world, source.method_9211().method_41239()) : new class_7159((class_1937)world, source.method_9211().method_41239()))));
                }
            } else {
                CarpetFixesServer.ruleScheduler.addRule(this, currentRule, newValue, string);
            }
            return newValue;
        }
    }

    public static class enforceWhitelistValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            if (source != null && CarpetFixesServer.areWorldsLoaded) {
                source.method_9211().method_3731(newValue.booleanValue());
            } else {
                CarpetFixesServer.ruleScheduler.addDefaultRule(this, currentRule, newValue, string, MinecraftServer::method_3729);
            }
            return newValue;
        }
    }

    public static class flightEnabledValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            if (source != null && CarpetFixesServer.areWorldsLoaded) {
                source.method_9211().method_3745(newValue.booleanValue());
            } else {
                CarpetFixesServer.ruleScheduler.addDefaultRule(this, currentRule, newValue, string, MinecraftServer::method_3718);
            }
            return newValue;
        }
    }

    public static class pvpEnabledValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            if (source != null && CarpetFixesServer.areWorldsLoaded) {
                source.method_9211().method_3815(newValue.booleanValue());
            } else {
                CarpetFixesServer.ruleScheduler.addDefaultRule(this, currentRule, newValue, string, MinecraftServer::method_3852);
            }
            return newValue;
        }
    }

    public static class preventProxyConnectionsValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            if (source != null && CarpetFixesServer.areWorldsLoaded) {
                source.method_9211().method_3764(newValue.booleanValue());
            } else {
                CarpetFixesServer.ruleScheduler.addDefaultRule(this, currentRule, newValue, string, MinecraftServer::method_3775);
            }
            return newValue;
        }
    }

    public static class onlineModeValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            if (source != null && CarpetFixesServer.areWorldsLoaded) {
                source.method_9211().method_3864(newValue.booleanValue());
            } else {
                CarpetFixesServer.ruleScheduler.addDefaultRule(this, currentRule, newValue, string, MinecraftServer::method_3828);
            }
            return newValue;
        }
    }

    public static class WorldBorderCollisionRoundingFixValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            CFSettings.scheduleWorldBorderReset = true;
            return newValue;
        }
    }

    public static class WitherGolemSpawningFixValidator
    extends Validator<Boolean> {
        public Boolean validate(class_2168 source, CarpetRule<Boolean> currentRule, Boolean newValue, String string) {
            ((class_2276)class_2246.field_10147).field_10753 = null;
            ((class_2276)class_2246.field_10147).field_10752 = null;
            return newValue;
        }
    }
}

