/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crafter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.crafter.CrafterHelper;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.createmod.catnip.data.Iterate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ConnectedInputHandler {
    public static boolean shouldConnect(class_1937 world, class_2338 pos, class_2350 face, class_2350 direction) {
        class_2680 refState = world.method_8320(pos);
        if (!refState.method_28498(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return false;
        }
        class_2350 refDirection = (class_2350)refState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        if (direction.method_10166() == refDirection.method_10166()) {
            return false;
        }
        if (face == refDirection) {
            return false;
        }
        class_2680 neighbour = world.method_8320(pos.method_10093(direction));
        if (!AllBlocks.MECHANICAL_CRAFTER.has(neighbour)) {
            return false;
        }
        return refDirection == neighbour.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
    }

    public static void toggleConnection(class_1937 world, class_2338 pos, class_2338 pos2) {
        class_2338 controllerPos2;
        MechanicalCrafterBlockEntity crafter1 = CrafterHelper.getCrafter((class_1920)world, pos);
        MechanicalCrafterBlockEntity crafter2 = CrafterHelper.getCrafter((class_1920)world, pos2);
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        class_2338 controllerPos1 = crafter1.method_11016().method_10081((class_2382)crafter1.input.data.get(0));
        if (controllerPos1.equals((Object)(controllerPos2 = crafter2.method_11016().method_10081((class_2382)crafter2.input.data.get(0))))) {
            MechanicalCrafterBlockEntity controller = CrafterHelper.getCrafter((class_1920)world, controllerPos1);
            Set<class_2338> positions = controller.input.data.stream().map(arg_0 -> ((class_2338)controllerPos1).method_10081(arg_0)).collect(Collectors.toSet());
            LinkedList<class_2338> frontier = new LinkedList<class_2338>();
            ArrayList<class_2338> splitGroup = new ArrayList<class_2338>();
            frontier.add(pos2);
            positions.remove(pos2);
            positions.remove(pos);
            while (!frontier.isEmpty()) {
                class_2338 current = (class_2338)frontier.remove(0);
                for (class_2350 direction : Iterate.directions) {
                    class_2338 next = current.method_10093(direction);
                    if (!positions.remove(next)) continue;
                    splitGroup.add(next);
                    frontier.add(next);
                }
            }
            ConnectedInputHandler.initAndAddAll(world, crafter1, positions);
            ConnectedInputHandler.initAndAddAll(world, crafter2, splitGroup);
            crafter1.method_5431();
            crafter1.connectivityChanged();
            crafter2.method_5431();
            crafter2.connectivityChanged();
            return;
        }
        if (!crafter1.input.isController) {
            crafter1 = CrafterHelper.getCrafter((class_1920)world, controllerPos1);
        }
        if (!crafter2.input.isController) {
            crafter2 = CrafterHelper.getCrafter((class_1920)world, controllerPos2);
        }
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        ConnectedInputHandler.connectControllers(world, crafter1, crafter2);
        world.method_8652(crafter1.method_11016(), crafter1.method_11010(), 3);
        crafter1.method_5431();
        crafter1.connectivityChanged();
        crafter2.method_5431();
        crafter2.connectivityChanged();
    }

    public static void initAndAddAll(class_1937 world, MechanicalCrafterBlockEntity crafter, Collection<class_2338> positions) {
        crafter.input = new ConnectedInput();
        positions.forEach(splitPos -> ConnectedInputHandler.modifyAndUpdate(world, splitPos, input -> {
            input.attachTo(crafter.method_11016(), (class_2338)splitPos);
            crafter.input.data.add(splitPos.method_10059((class_2382)crafter.method_11016()));
        }));
    }

    public static void connectControllers(class_1937 world, MechanicalCrafterBlockEntity crafter1, MechanicalCrafterBlockEntity crafter2) {
        crafter1.input.data.forEach(offset -> {
            class_2338 connectedPos = crafter1.method_11016().method_10081((class_2382)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {});
        });
        crafter2.input.data.forEach(offset -> {
            if (offset.equals((Object)class_2338.field_10980)) {
                return;
            }
            class_2338 connectedPos = crafter2.method_11016().method_10081((class_2382)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {
                input.attachTo(crafter1.method_11016(), connectedPos);
                crafter1.input.data.add(class_2338.field_10980.method_10059((class_2382)input.data.get(0)));
            });
        });
        crafter2.input.attachTo(crafter1.method_11016(), crafter2.method_11016());
        crafter1.input.data.add(class_2338.field_10980.method_10059((class_2382)crafter2.input.data.get(0)));
    }

    private static void modifyAndUpdate(class_1937 world, class_2338 pos, Consumer<ConnectedInput> callback) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof MechanicalCrafterBlockEntity)) {
            return;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)blockEntity;
        callback.accept(crafter.input);
        crafter.method_5431();
        crafter.connectivityChanged();
    }

    public static class ConnectedInput {
        boolean isController = true;
        List<class_2338> data = Collections.synchronizedList(new ArrayList());

        public ConnectedInput() {
            this.data.add(class_2338.field_10980);
        }

        public void attachTo(class_2338 controllerPos, class_2338 myPos) {
            this.isController = false;
            this.data.clear();
            this.data.add(controllerPos.method_10059((class_2382)myPos));
        }

        @Nullable
        public CombinedStorage<ItemVariant, MechanicalCrafterBlockEntity.Inventory> getItemHandler(class_1937 world, class_2338 pos) {
            List<MechanicalCrafterBlockEntity.Inventory> inventories = this.getInventories(world, pos);
            return inventories.isEmpty() ? null : new CombinedStorage(inventories);
        }

        public List<MechanicalCrafterBlockEntity.Inventory> getInventories(class_1937 world, class_2338 pos) {
            if (!this.isController) {
                class_2338 controllerPos = pos.method_10081((class_2382)this.data.get(0));
                ConnectedInput input = CrafterHelper.getInput((class_1920)world, controllerPos);
                if (input == this || input == null || !input.isController) {
                    return List.of();
                }
                return input.getInventories(world, controllerPos);
            }
            class_2350 facing = class_2350.field_11035;
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_28498(MechanicalCrafterBlock.HORIZONTAL_FACING)) {
                facing = (class_2350)blockState.method_11654(MechanicalCrafterBlock.HORIZONTAL_FACING);
            }
            class_2350.class_2352 axisDirection = facing.method_10171();
            class_2350.class_2351 compareAxis = facing.method_10170().method_10166();
            Comparator invOrdering = (p1, p2) -> {
                int compareY = -Integer.compare(p1.method_10264(), p2.method_10264());
                int modifier = axisDirection.method_10181() * (compareAxis == class_2350.class_2351.field_11051 ? -1 : 1);
                int c1 = compareAxis.method_10173(p1.method_10263(), p1.method_10264(), p1.method_10260());
                int c2 = compareAxis.method_10173(p2.method_10263(), p2.method_10264(), p2.method_10260());
                return compareY != 0 ? compareY : modifier * Integer.compare(c1, c2);
            };
            return this.data.stream().sorted(invOrdering).map(l -> CrafterHelper.getCrafter((class_1920)world, pos.method_10081((class_2382)l))).filter(Objects::nonNull).map(MechanicalCrafterBlockEntity::getInventory).collect(Collectors.toList());
        }

        public void write(class_2487 nbt) {
            nbt.method_10556("Controller", this.isController);
            class_2499 list = new class_2499();
            this.data.forEach(pos -> list.add((Object)class_2512.method_10692((class_2338)pos)));
            nbt.method_10566("Data", (class_2520)list);
        }

        public void read(class_2487 nbt) {
            this.isController = nbt.method_10577("Controller");
            this.data.clear();
            nbt.method_10554("Data", 10).forEach(inbt -> this.data.add(class_2512.method_10691((class_2487)((class_2487)inbt))));
            if (this.data.isEmpty()) {
                this.isController = true;
                this.data.add(class_2338.field_10980);
            }
        }
    }
}

