/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crafter;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.crafter.CrafterHelper;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingInventory;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.Pointing;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1851;
import net.minecraft.class_1860;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_8566;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeGridHandler {
    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChain(MechanicalCrafterBlockEntity root) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, (Predicate<MechanicalCrafterBlockEntity>)Predicates.alwaysTrue());
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(MechanicalCrafterBlockEntity root, Predicate<MechanicalCrafterBlockEntity> test) {
        return RecipeGridHandler.getAllCraftersOfChainIf(root, test, false);
    }

    public static List<MechanicalCrafterBlockEntity> getAllCraftersOfChainIf(MechanicalCrafterBlockEntity root, Predicate<MechanicalCrafterBlockEntity> test, boolean poweredStart) {
        ArrayList<MechanicalCrafterBlockEntity> crafters = new ArrayList<MechanicalCrafterBlockEntity>();
        ArrayList<Pair> frontier = new ArrayList<Pair>();
        HashSet<MechanicalCrafterBlockEntity> visited = new HashSet<MechanicalCrafterBlockEntity>();
        frontier.add(Pair.of((Object)root, null));
        boolean empty = false;
        boolean allEmpty = true;
        while (!frontier.isEmpty()) {
            Pair pair = (Pair)frontier.remove(0);
            MechanicalCrafterBlockEntity current = (MechanicalCrafterBlockEntity)pair.getKey();
            MechanicalCrafterBlockEntity last = (MechanicalCrafterBlockEntity)pair.getValue();
            if (visited.contains(current)) {
                return null;
            }
            if (!test.test(current)) {
                empty = true;
            } else {
                allEmpty = false;
            }
            crafters.add(current);
            visited.add(current);
            MechanicalCrafterBlockEntity target = RecipeGridHandler.getTargetingCrafter(current);
            if (target != last && target != null) {
                frontier.add(Pair.of((Object)target, (Object)current));
            }
            for (MechanicalCrafterBlockEntity preceding : RecipeGridHandler.getPrecedingCrafters(current)) {
                if (preceding == last) continue;
                frontier.add(Pair.of((Object)preceding, (Object)current));
            }
        }
        return empty && !poweredStart || allEmpty ? null : crafters;
    }

    public static MechanicalCrafterBlockEntity getTargetingCrafter(MechanicalCrafterBlockEntity crafter) {
        class_2680 state = crafter.method_11010();
        if (!RecipeGridHandler.isCrafter(state)) {
            return null;
        }
        class_2338 targetPos = crafter.method_11016().method_10093(MechanicalCrafterBlock.getTargetDirection(state));
        MechanicalCrafterBlockEntity targetBE = CrafterHelper.getCrafter((class_1920)crafter.method_10997(), targetPos);
        if (targetBE == null) {
            return null;
        }
        class_2680 targetState = targetBE.method_11010();
        if (!RecipeGridHandler.isCrafter(targetState)) {
            return null;
        }
        if (state.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING) != targetState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return null;
        }
        return targetBE;
    }

    public static List<MechanicalCrafterBlockEntity> getPrecedingCrafters(MechanicalCrafterBlockEntity crafter) {
        class_2338 pos = crafter.method_11016();
        class_1937 world = crafter.method_10997();
        ArrayList<MechanicalCrafterBlockEntity> crafters = new ArrayList<MechanicalCrafterBlockEntity>();
        class_2680 blockState = crafter.method_11010();
        if (!RecipeGridHandler.isCrafter(blockState)) {
            return crafters;
        }
        class_2350 blockFacing = (class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        class_2350 blockPointing = MechanicalCrafterBlock.getTargetDirection(blockState);
        for (class_2350 facing : Iterate.directions) {
            MechanicalCrafterBlockEntity be;
            class_2338 neighbourPos;
            class_2680 neighbourState;
            if (blockFacing.method_10166() == facing.method_10166() || blockPointing == facing || !RecipeGridHandler.isCrafter(neighbourState = world.method_8320(neighbourPos = pos.method_10093(facing))) || MechanicalCrafterBlock.getTargetDirection(neighbourState) != facing.method_10153() || blockFacing != neighbourState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING) || (be = CrafterHelper.getCrafter((class_1920)world, neighbourPos)) == null) continue;
            crafters.add(be);
        }
        return crafters;
    }

    private static boolean isCrafter(class_2680 state) {
        return AllBlocks.MECHANICAL_CRAFTER.has(state);
    }

    public static class_1799 tryToApplyRecipe(class_1937 world, GroupedItems items) {
        items.calcStats();
        MechanicalCraftingInventory craftinginventory = new MechanicalCraftingInventory(items);
        class_1799 result = null;
        class_5455 registryAccess = world.method_30349();
        if (((Boolean)AllConfigs.server().recipes.allowRegularCraftingInCrafter.get()).booleanValue()) {
            result = world.method_8433().method_8132(class_3956.field_17545, (class_1263)craftinginventory, world).filter(arg_0 -> RecipeGridHandler.lambda$tryToApplyRecipe$0((class_8566)craftinginventory, arg_0)).map(arg_0 -> RecipeGridHandler.lambda$tryToApplyRecipe$1((class_8566)craftinginventory, registryAccess, arg_0)).orElse(null);
        }
        if (result == null) {
            result = AllRecipeTypes.MECHANICAL_CRAFTING.find(craftinginventory, world).map(arg_0 -> RecipeGridHandler.lambda$tryToApplyRecipe$2((class_8566)craftinginventory, registryAccess, arg_0)).orElse(null);
        }
        return result;
    }

    public static boolean isRecipeAllowed(class_3955 recipe, class_8566 inventory) {
        if (recipe instanceof class_1851) {
            int numItems = 0;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (inventory.method_5438(i).method_7960()) continue;
                ++numItems;
            }
            if (numItems > (Integer)AllConfigs.server().recipes.maxFireworkIngredientsInCrafter.get()) {
                return false;
            }
        }
        return !AllRecipeTypes.shouldIgnoreInAutomation(recipe);
    }

    private static /* synthetic */ class_1799 lambda$tryToApplyRecipe$2(class_8566 craftinginventory, class_5455 registryAccess, class_1860 r) {
        return r.method_8116((class_1263)craftinginventory, registryAccess);
    }

    private static /* synthetic */ class_1799 lambda$tryToApplyRecipe$1(class_8566 craftinginventory, class_5455 registryAccess, class_3955 r) {
        return r.method_8116((class_1263)craftinginventory, registryAccess);
    }

    private static /* synthetic */ boolean lambda$tryToApplyRecipe$0(class_8566 craftinginventory, class_3955 r) {
        return RecipeGridHandler.isRecipeAllowed(r, craftinginventory);
    }

    public static class GroupedItems {
        Map<Pair<Integer, Integer>, class_1799> grid = new HashMap<Pair<Integer, Integer>, class_1799>();
        int minX;
        int minY;
        int maxX;
        int maxY;
        int width;
        int height;
        boolean statsReady;

        public GroupedItems() {
        }

        public GroupedItems(class_1799 stack) {
            this.grid.put((Pair<Integer, Integer>)Pair.of((Object)0, (Object)0), stack);
        }

        public void mergeOnto(GroupedItems other, Pointing pointing) {
            int xOffset;
            int n = pointing == Pointing.LEFT ? 1 : (xOffset = pointing == Pointing.RIGHT ? -1 : 0);
            int yOffset = pointing == Pointing.DOWN ? 1 : (pointing == Pointing.UP ? -1 : 0);
            this.grid.forEach((pair, stack) -> other.grid.put((Pair<Integer, Integer>)Pair.of((Object)((Integer)pair.getKey() + xOffset), (Object)((Integer)pair.getValue() + yOffset)), (class_1799)stack));
            other.statsReady = false;
        }

        public void write(class_2487 nbt) {
            class_2499 gridNBT = new class_2499();
            this.grid.forEach((pair, stack) -> {
                class_2487 entry = new class_2487();
                entry.method_10569("x", ((Integer)pair.getKey()).intValue());
                entry.method_10569("y", ((Integer)pair.getValue()).intValue());
                entry.method_10566("item", NBTSerializer.serializeNBT((Object)stack));
                gridNBT.add((Object)entry);
            });
            nbt.method_10566("Grid", (class_2520)gridNBT);
        }

        public static GroupedItems read(class_2487 nbt) {
            GroupedItems items = new GroupedItems();
            class_2499 gridNBT = nbt.method_10554("Grid", 10);
            gridNBT.forEach(inbt -> {
                class_2487 entry = (class_2487)inbt;
                int x = entry.method_10550("x");
                int y = entry.method_10550("y");
                class_1799 stack = class_1799.method_7915((class_2487)entry.method_10562("item"));
                items.grid.put((Pair<Integer, Integer>)Pair.of((Object)x, (Object)y), stack);
            });
            return items;
        }

        public void calcStats() {
            if (this.statsReady) {
                return;
            }
            this.statsReady = true;
            this.minX = 0;
            this.minY = 0;
            this.maxX = 0;
            this.maxY = 0;
            for (Pair<Integer, Integer> pair : this.grid.keySet()) {
                int x = (Integer)pair.getKey();
                int y = (Integer)pair.getValue();
                this.minX = Math.min(this.minX, x);
                this.minY = Math.min(this.minY, y);
                this.maxX = Math.max(this.maxX, x);
                this.maxY = Math.max(this.maxY, y);
            }
            this.width = this.maxX - this.minX + 1;
            this.height = this.maxY - this.minY + 1;
        }

        public boolean onlyEmptyItems() {
            for (class_1799 stack : this.grid.values()) {
                if (stack.method_7960()) continue;
                return false;
            }
            return true;
        }
    }
}

