/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.DepotRenderer;
import com.simibubi.create.content.logistics.depot.EjectorBlock;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.Rotate;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.transform.Translate;
import net.createmod.catnip.data.LongAttached;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;

public class EjectorRenderer
extends ShaftRenderer<EjectorBlockEntity> {
    static final class_243 pivot = VecHelper.voxelSpace((double)0.0, (double)11.25, (double)0.75);

    public EjectorRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(EjectorBlockEntity p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(EjectorBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        float lidProgress = be.getLidProgress(partialTicks);
        float angle = lidProgress * 70.0f;
        if (!VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            SuperByteBuffer model = CachedBuffers.partial((PartialModel)AllPartialModels.EJECTOR_TOP, (class_2680)be.method_11010());
            EjectorRenderer.applyLidAngle(be, angle, model);
            model.light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
        }
        PoseTransformStack msr = TransformStack.of((class_4587)ms);
        float maxTime = (float)(be.earlyTarget != null ? (double)be.earlyTargetTime : be.launcher.getTotalFlyingTicks());
        for (LongAttached<class_1799> longAttached : be.launchedItems) {
            float time = (float)((Long)longAttached.getFirst()).longValue() + partialTicks;
            if (time > maxTime) continue;
            ms.method_22903();
            class_243 launchedItemLocation = be.getLaunchedItemLocation(time);
            msr.translate(launchedItemLocation.method_1020(class_243.method_24954((class_2382)be.method_11016())));
            class_243 itemRotOffset = VecHelper.voxelSpace((double)0.0, (double)2.0, (double)-1.0);
            msr.translate(itemRotOffset);
            if (PackageItem.isPackage((class_1799)longAttached.getValue())) {
                ms.method_46416(0.0f, 0.25f, 0.0f);
                ms.method_22905(1.5f, 1.5f, 1.5f);
                msr.rotateYDegrees(time * 20.0f);
            } else {
                ms.method_22905(0.5f, 0.5f, 0.5f);
                msr.rotateYDegrees(AngleHelper.horizontalAngle((class_2350)be.getFacing()));
                msr.rotateXDegrees(time * 40.0f);
            }
            msr.translateBack(itemRotOffset);
            class_310.method_1551().method_1480().method_23178((class_1799)longAttached.getValue(), class_811.field_4319, light, overlay, ms, buffer, be.method_10997(), 0);
            ms.method_22909();
        }
        DepotBehaviour behaviour = be.getBehaviour(DepotBehaviour.TYPE);
        if (behaviour == null || behaviour.isEmpty()) {
            return;
        }
        ms.method_22903();
        EjectorRenderer.applyLidAngle(be, angle, msr);
        ((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(-180.0f - AngleHelper.horizontalAngle((class_2350)((class_2350)be.method_11010().method_11654(EjectorBlock.HORIZONTAL_FACING))))).uncenter();
        DepotRenderer.renderItemsOf(be, partialTicks, ms, buffer, light, overlay, behaviour);
        ms.method_22909();
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, float angle, T tr) {
        EjectorRenderer.applyLidAngle(be, pivot, angle, tr);
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, class_243 rotationOffset, float angle, T tr) {
        ((Translate)((Rotate)((Translate)((Rotate)tr.center()).rotateYDegrees(180.0f + AngleHelper.horizontalAngle((class_2350)((class_2350)be.method_11010().method_11654(EjectorBlock.HORIZONTAL_FACING))))).uncenter().translate(rotationOffset)).rotateXDegrees(-angle)).translateBack(rotationOffset);
    }
}

