/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2540;

public class FactoryPanelConfigurationPacket
extends BlockEntityConfigurationPacket<FactoryPanelBlockEntity> {
    private FactoryPanelBlock.PanelSlot slot;
    private String address;
    private Map<FactoryPanelPosition, Integer> inputAmounts;
    private List<class_1799> craftingArrangement;
    private int outputAmount;
    private int promiseClearingInterval;
    private FactoryPanelPosition removeConnection;
    private boolean clearPromises;
    private boolean reset;
    private boolean redstoneReset;

    public FactoryPanelConfigurationPacket(FactoryPanelPosition position, String address, Map<FactoryPanelPosition, Integer> inputAmounts, List<class_1799> craftingArrangement, int outputAmount, int promiseClearingInterval, @Nullable FactoryPanelPosition removeConnection, boolean clearPromises, boolean reset, boolean sendRedstoneReset) {
        super(position.pos());
        this.address = address;
        this.inputAmounts = inputAmounts;
        this.craftingArrangement = craftingArrangement;
        this.outputAmount = outputAmount;
        this.promiseClearingInterval = promiseClearingInterval;
        this.removeConnection = removeConnection;
        this.clearPromises = clearPromises;
        this.reset = reset;
        this.redstoneReset = sendRedstoneReset;
        this.slot = position.slot();
    }

    public FactoryPanelConfigurationPacket(class_2540 buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(class_2540 buffer) {
        buffer.method_10804(this.slot.ordinal());
        buffer.method_10814(this.address);
        buffer.method_10804(this.inputAmounts.size());
        for (Map.Entry<FactoryPanelPosition, Integer> entry : this.inputAmounts.entrySet()) {
            entry.getKey().send(buffer);
            buffer.method_10804(entry.getValue().intValue());
        }
        buffer.method_10804(this.craftingArrangement.size());
        this.craftingArrangement.forEach(arg_0 -> ((class_2540)buffer).method_10793(arg_0));
        buffer.method_10804(this.outputAmount);
        buffer.method_10804(this.promiseClearingInterval);
        buffer.writeBoolean(this.removeConnection != null);
        if (this.removeConnection != null) {
            this.removeConnection.send(buffer);
        }
        buffer.writeBoolean(this.clearPromises);
        buffer.writeBoolean(this.reset);
        buffer.writeBoolean(this.redstoneReset);
    }

    @Override
    protected void readSettings(class_2540 buffer) {
        this.slot = FactoryPanelBlock.PanelSlot.values()[buffer.method_10816()];
        this.address = buffer.method_19772();
        this.inputAmounts = new HashMap<FactoryPanelPosition, Integer>();
        int entries = buffer.method_10816();
        for (int i = 0; i < entries; ++i) {
            this.inputAmounts.put(FactoryPanelPosition.receive(buffer), buffer.method_10816());
        }
        int craftEntries = buffer.method_10816();
        this.craftingArrangement = new ArrayList<class_1799>();
        for (int i = 0; i < craftEntries; ++i) {
            this.craftingArrangement.add(buffer.method_10819());
        }
        this.outputAmount = buffer.method_10816();
        this.promiseClearingInterval = buffer.method_10816();
        if (buffer.readBoolean()) {
            this.removeConnection = FactoryPanelPosition.receive(buffer);
        }
        this.clearPromises = buffer.readBoolean();
        this.reset = buffer.readBoolean();
        this.redstoneReset = buffer.readBoolean();
    }

    @Override
    protected void applySettings(FactoryPanelBlockEntity be) {
        FactoryPanelBehaviour behaviour = be.panels.get((Object)this.slot);
        if (behaviour == null) {
            return;
        }
        behaviour.recipeAddress = this.reset ? "" : this.address;
        behaviour.recipeOutput = this.reset ? 1 : this.outputAmount;
        behaviour.promiseClearingInterval = this.reset ? -1 : this.promiseClearingInterval;
        List<Object> list = behaviour.activeCraftingArrangement = this.reset ? List.of() : this.craftingArrangement;
        if (this.reset) {
            behaviour.forceClearPromises = true;
            behaviour.disconnectAll();
            behaviour.setFilter(class_1799.field_8037);
            behaviour.count = 0;
            be.redraw = true;
            be.notifyUpdate();
            return;
        }
        if (this.redstoneReset) {
            behaviour.disconnectAllLinks();
            be.notifyUpdate();
            return;
        }
        for (Map.Entry<FactoryPanelPosition, Integer> entry : this.inputAmounts.entrySet()) {
            FactoryPanelPosition key = entry.getKey();
            FactoryPanelConnection connection = behaviour.targetedBy.get(key);
            if (connection == null) continue;
            connection.amount = entry.getValue();
        }
        if (this.removeConnection != null) {
            behaviour.targetedBy.remove(this.removeConnection);
            FactoryPanelBehaviour source = FactoryPanelBehaviour.at((class_1920)be.method_10997(), this.removeConnection);
            if (source != null) {
                source.targeting.remove(behaviour.getPanelPosition());
                source.blockEntity.sendData();
            }
        }
        if (this.clearPromises) {
            behaviour.forceClearPromises = true;
        }
        be.notifyUpdate();
    }
}

