/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.LazyTickedScheduleCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.lang.Lang;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public abstract class CargoThresholdCondition
extends LazyTickedScheduleCondition {
    public CargoThresholdCondition() {
        super(20);
        this.data.method_10582("Threshold", "10");
    }

    @Override
    public boolean lazyTickCompletion(class_1937 level, Train train, class_2487 context) {
        int lastChecked = context.method_10545("LastChecked") ? context.method_10550("LastChecked") : -1;
        int status = 0;
        for (Carriage carriage : train.carriages) {
            status += carriage.storage.getVersion();
        }
        if (status == lastChecked) {
            return false;
        }
        context.method_10569("LastChecked", status);
        return this.test(level, train, context);
    }

    protected void requestStatusToUpdate(long amount, class_2487 context) {
        context.method_10544("CurrentDisplay", amount);
        super.requestStatusToUpdate(context);
    }

    protected long getLastDisplaySnapshot(class_2487 context) {
        if (!context.method_10545("CurrentDisplay")) {
            return -1L;
        }
        return context.method_10537("CurrentDisplay");
    }

    protected abstract boolean test(class_1937 var1, Train var2, class_2487 var3);

    protected abstract class_2561 getUnit();

    protected abstract class_1799 getIcon();

    @Override
    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)this.getIcon(), (Object)class_2561.method_43470((String)(this.getOperator().formatted + " " + this.getThreshold())).method_10852(this.getUnit()));
    }

    @Override
    public int slotsTargeted() {
        return 1;
    }

    public Ops getOperator() {
        return this.enumData("Operator", Ops.class);
    }

    public long getThreshold() {
        try {
            return Long.parseLong(this.textData("Threshold"));
        }
        catch (NumberFormatException e) {
            this.data.method_10582("Threshold", "0");
            return 0L;
        }
    }

    public int getMeasure() {
        return this.intData("Measure");
    }

    @Override
    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.condition.threshold.place_item", new Object[0]), (Object)CreateLang.translateDirect("schedule.condition.threshold.place_item_2", new Object[0]).method_27692(class_124.field_1080), (Object)CreateLang.translateDirect("schedule.condition.threshold.place_item_3", new Object[0]).method_27692(class_124.field_1080));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(0, 24, (i, l) -> i.forOptions(Ops.translatedOptions()).titled(CreateLang.translateDirect("schedule.condition.threshold.train_holds", "")).format(state -> class_2561.method_43470((String)(" " + Ops.values()[state.intValue()].formatted))), "Operator");
        builder.addIntegerTextInput(29, 41, (e, t) -> {}, "Threshold");
    }

    public static enum Ops {
        GREATER(">"),
        LESS("<"),
        EQUAL("=");

        public String formatted;

        private Ops(String formatted) {
            this.formatted = formatted;
        }

        public boolean test(long current, long target) {
            return switch (this) {
                case GREATER -> {
                    if (current > target) {
                        yield true;
                    }
                    yield false;
                }
                case EQUAL -> {
                    if (current == target) {
                        yield true;
                    }
                    yield false;
                }
                case LESS -> {
                    if (current < target) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)this));
            };
        }

        public static List<? extends class_2561> translatedOptions() {
            return Arrays.stream(Ops.values()).map(op -> CreateLang.translateDirect("schedule.condition.threshold." + Lang.asId((String)op.name()), new Object[0])).toList();
        }
    }
}

