/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.FakeTrackBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntityTilt;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.IMergeableBE;
import com.simibubi.create.foundation.blockEntity.RemoveBlockEntityPacket;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.tterrag.registrate.fabric.EnvExecutor;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.pepperbell.simplenetworking.S2CPacket;
import net.createmod.catnip.data.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockview.v2.RenderDataBlockEntity;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class TrackBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity,
IMergeableBE,
RenderDataBlockEntity {
    Map<class_2338, BezierConnection> connections = new HashMap<class_2338, BezierConnection>();
    boolean cancelDrops;
    public Pair<class_5321<class_1937>, class_2338> boundLocation;
    public TrackBlockEntityTilt tilt;

    public TrackBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(100);
        this.tilt = new TrackBlockEntityTilt(this);
    }

    public Map<class_2338, BezierConnection> getConnections() {
        return this.connections;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.field_11863.field_9236 && this.hasInteractableConnections()) {
            this.registerToCurveInteraction();
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.tilt.undoSmoothing();
    }

    @Override
    public void lazyTick() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void validateConnections() {
        HashSet<class_2338> invalid = new HashSet<class_2338>();
        for (Map.Entry<class_2338, BezierConnection> entry : this.connections.entrySet()) {
            TrackBlockEntity trackBE;
            BezierConnection bc;
            block10: {
                class_2338 key;
                block9: {
                    class_2586 blockEntity;
                    key = entry.getKey();
                    if (!key.equals((Object)(bc = entry.getValue()).getKey()) || !this.field_11867.equals(bc.bePositions.getFirst())) {
                        invalid.add(key);
                        continue;
                    }
                    class_2680 blockState = this.field_11863.method_8320(key);
                    class_2248 class_22482 = blockState.method_26204();
                    if (class_22482 instanceof ITrackBlock) {
                        ITrackBlock trackBlock = (ITrackBlock)class_22482;
                        if (!((Boolean)blockState.method_11654((class_2769)TrackBlock.HAS_BE)).booleanValue()) {
                            for (class_243 v : trackBlock.getTrackAxes((class_1922)this.field_11863, key, blockState)) {
                                class_243 bcEndAxis;
                                if (!(v.method_1022(bcEndAxis = (class_243)bc.axes.getSecond()) < 9.765625E-4) && !(v.method_1022(bcEndAxis.method_1021(-1.0)) < 9.765625E-4)) continue;
                                this.field_11863.method_8652(key, (class_2680)blockState.method_11657((class_2769)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
                            }
                        }
                    }
                    if (!((blockEntity = this.field_11863.method_8321(key)) instanceof TrackBlockEntity)) break block9;
                    trackBE = (TrackBlockEntity)blockEntity;
                    if (!blockEntity.method_11015()) break block10;
                }
                invalid.add(key);
                continue;
            }
            if (trackBE.connections.containsKey(this.field_11867)) continue;
            trackBE.addConnection(bc.secondary());
            trackBE.tilt.tryApplySmoothing();
        }
        for (class_2338 blockPos : invalid) {
            this.removeConnection(blockPos);
        }
    }

    public void addConnection(BezierConnection connection) {
        if (this.connections.containsKey(connection.getKey()) && connection.equalsSansMaterial(this.connections.get(connection.getKey()))) {
            return;
        }
        this.connections.put(connection.getKey(), connection);
        this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), 1);
        this.notifyUpdate();
        if (connection.isPrimary()) {
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void removeConnection(class_2338 target) {
        class_1937 class_19372;
        if (this.isTilted()) {
            this.tilt.captureSmoothingHandles();
        }
        BezierConnection removed = this.connections.remove(target);
        this.notifyUpdate();
        if (removed != null) {
            this.manageFakeTracksAlong(removed, true);
        }
        if (!this.connections.isEmpty() || this.method_11010().method_28500(TrackBlock.SHAPE).orElse(TrackShape.NONE).isPortal()) {
            return;
        }
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        if (blockState.method_28498((class_2769)TrackBlock.HAS_BE)) {
            this.field_11863.method_8501(this.field_11867, (class_2680)blockState.method_11657((class_2769)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(false)));
        }
        if ((class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            AllPackets.getChannel().sendToClientsTracking((S2CPacket)new RemoveBlockEntityPacket(this.field_11867), serverLevel, this.field_11867);
        }
    }

    public void removeInboundConnections(boolean dropAndDiscard) {
        for (BezierConnection bezierConnection : this.connections.values()) {
            class_2586 class_25862 = this.field_11863.method_8321(bezierConnection.getKey());
            if (!(class_25862 instanceof TrackBlockEntity)) {
                return;
            }
            TrackBlockEntity tbe = (TrackBlockEntity)class_25862;
            tbe.removeConnection((class_2338)bezierConnection.bePositions.getFirst());
            if (!dropAndDiscard) continue;
            if (!this.cancelDrops) {
                bezierConnection.spawnItems(this.field_11863);
            }
            bezierConnection.spawnDestroyParticles(this.field_11863);
        }
        if (dropAndDiscard) {
            AllPackets.getChannel().sendToClientsTracking((S2CPacket)new RemoveBlockEntityPacket(this.field_11867), (class_2586)this);
        }
    }

    public void bind(class_5321<class_1937> boundDimension, class_2338 boundLocation) {
        this.boundLocation = Pair.of(boundDimension, (Object)boundLocation);
        this.method_5431();
    }

    public boolean isTilted() {
        return this.tilt.smoothingAngle.isPresent();
    }

    @Override
    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        this.writeTurns(tag, true);
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.writeTurns(tag, false);
        if (this.isTilted()) {
            tag.method_10549("Smoothing", this.tilt.smoothingAngle.get().doubleValue());
        }
        if (this.boundLocation == null) {
            return;
        }
        tag.method_10566("BoundLocation", (class_2520)class_2512.method_10692((class_2338)((class_2338)this.boundLocation.getSecond())));
        tag.method_10582("BoundDimension", ((class_5321)this.boundLocation.getFirst()).method_29177().toString());
    }

    private void writeTurns(class_2487 tag, boolean restored) {
        class_2499 listTag = new class_2499();
        for (BezierConnection bezierConnection : this.connections.values()) {
            listTag.add((Object)(restored ? this.tilt.restoreToOriginalCurve(bezierConnection.clone()) : bezierConnection).write(this.field_11867));
        }
        tag.method_10566("Connections", (class_2520)listTag);
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.connections.clear();
        for (class_2520 t : tag.method_10554("Connections", 10)) {
            if (!(t instanceof class_2487)) {
                return;
            }
            BezierConnection connection = new BezierConnection((class_2487)t, this.field_11867);
            this.connections.put(connection.getKey(), connection);
        }
        boolean smoothingPreviously = this.tilt.smoothingAngle.isPresent();
        this.tilt.smoothingAngle = Optional.ofNullable(tag.method_10545("Smoothing") ? Double.valueOf(tag.method_10574("Smoothing")) : null);
        if (smoothingPreviously != this.tilt.smoothingAngle.isPresent() && clientPacket) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 16);
        }
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> VisualizationHelper.queueUpdate((class_2586)this));
        if (this.hasInteractableConnections()) {
            this.registerToCurveInteraction();
        } else {
            this.removeFromCurveInteraction();
        }
        if (tag.method_10545("BoundLocation")) {
            this.boundLocation = Pair.of((Object)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(tag.method_10558("BoundDimension"))), (Object)class_2512.method_10691((class_2487)tag.method_10562("BoundLocation")));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_238 getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public void accept(class_2586 other) {
        if (other instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)other;
            this.connections.putAll(track.connections);
        }
        this.validateConnections();
        this.field_11863.method_39279(this.field_11867, this.method_11010().method_26204(), 1);
    }

    public boolean hasInteractableConnections() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        HashMap<class_2338, BezierConnection> restoredConnections = new HashMap<class_2338, BezierConnection>();
        for (Map.Entry<class_2338, BezierConnection> entry : this.connections.entrySet()) {
            restoredConnections.put(entry.getKey(), this.tilt.restoreToOriginalCurve(this.tilt.restoreToOriginalCurve(entry.getValue().secondary()).secondary()));
        }
        this.connections = restoredConnections;
        this.tilt.smoothingAngle = Optional.empty();
        if (transform.rotationAxis != class_2350.class_2351.field_11052) {
            return;
        }
        HashMap<class_2338, BezierConnection> transformedConnections = new HashMap<class_2338, BezierConnection>();
        for (Map.Entry<class_2338, BezierConnection> entry : this.connections.entrySet()) {
            BezierConnection newConnection = entry.getValue();
            newConnection.normals.replace(transform::applyWithoutOffsetUncentered);
            newConnection.axes.replace(transform::applyWithoutOffsetUncentered);
            class_2338 diff = ((class_2338)newConnection.bePositions.getSecond()).method_10059((class_2382)newConnection.bePositions.getFirst());
            newConnection.bePositions.setSecond((Object)class_2338.method_49638((class_2374)class_243.method_24953((class_2382)((class_2382)newConnection.bePositions.getFirst())).method_1019(transform.applyWithoutOffsetUncentered(class_243.method_24954((class_2382)diff)))));
            class_243 beVec = class_243.method_24954((class_2382)this.field_11867);
            class_243 teCenterVec = beVec.method_1031(0.5, 0.5, 0.5);
            class_243 start = (class_243)newConnection.starts.getFirst();
            class_243 startToBE = start.method_1020(teCenterVec);
            class_243 endToStart = ((class_243)newConnection.starts.getSecond()).method_1020(start);
            startToBE = transform.applyWithoutOffsetUncentered(startToBE).method_1019(teCenterVec);
            endToStart = transform.applyWithoutOffsetUncentered(endToStart).method_1019(startToBE);
            newConnection.starts.setFirst((Object)new TrackNodeLocation(startToBE).getLocation());
            newConnection.starts.setSecond((Object)new TrackNodeLocation(endToStart).getLocation());
            class_2338 newTarget = newConnection.getKey();
            transformedConnections.put(newTarget, newConnection);
        }
        this.connections = transformedConnections;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.field_11863.field_9236) {
            this.removeFromCurveInteraction();
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (BezierConnection connection : this.connections.values()) {
            this.manageFakeTracksAlong(connection, true);
        }
        if (this.boundLocation != null && this.field_11863 instanceof class_3218) {
            class_3218 otherLevel = this.field_11863.method_8503().method_3847((class_5321)this.boundLocation.getFirst());
            if (otherLevel == null) {
                return;
            }
            if (AllTags.AllBlockTags.TRACKS.matches(otherLevel.method_8320((class_2338)this.boundLocation.getSecond()))) {
                otherLevel.method_22352((class_2338)this.boundLocation.getSecond(), false);
            }
        }
    }

    private void registerToCurveInteraction() {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::registerToCurveInteractionUnsafe);
    }

    private void removeFromCurveInteraction() {
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::removeFromCurveInteractionUnsafe);
    }

    @Nullable
    public Double getRenderData() {
        if (!this.isTilted()) {
            return null;
        }
        return this.tilt.smoothingAngle.get();
    }

    @Environment(value=EnvType.CLIENT)
    private void registerToCurveInteractionUnsafe() {
        ((Map)TrackBlockOutline.TRACKS_WITH_TURNS.get((class_1936)this.field_11863)).put(this.field_11867, this);
    }

    @Environment(value=EnvType.CLIENT)
    private void removeFromCurveInteractionUnsafe() {
        ((Map)TrackBlockOutline.TRACKS_WITH_TURNS.get((class_1936)this.field_11863)).remove(this.field_11867);
    }

    public void manageFakeTracksAlong(BezierConnection bc, boolean remove) {
        Map<Pair<Integer, Integer>, Double> yLevels = bc.rasterise();
        for (Map.Entry<Pair<Integer, Integer>, Double> entry : yLevels.entrySet()) {
            double yValue = entry.getValue();
            int floor = class_3532.method_15357((double)yValue);
            class_2338 targetPos = new class_2338(((Integer)entry.getKey().getFirst()).intValue(), floor, ((Integer)entry.getKey().getSecond()).intValue());
            targetPos = targetPos.method_10081((class_2382)bc.bePositions.getFirst()).method_10086(1);
            class_2680 stateAtPos = this.field_11863.method_8320(targetPos);
            boolean present = AllBlocks.FAKE_TRACK.has(stateAtPos);
            if (remove) {
                if (!present) continue;
                this.field_11863.method_8650(targetPos, false);
                continue;
            }
            class_3610 fluidState = stateAtPos.method_26227();
            if (!fluidState.method_15769() && !fluidState.method_33659((class_3611)class_3612.field_15910)) continue;
            if (!present && stateAtPos.method_45474()) {
                this.field_11863.method_8652(targetPos, ProperWaterloggedBlock.withWater((class_1936)this.field_11863, AllBlocks.FAKE_TRACK.getDefaultState(), targetPos), 3);
            }
            FakeTrackBlock.keepAlive((class_1936)this.field_11863, targetPos);
        }
    }
}

