/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricStructureProcessing {
    public static final Codec<Processor> PROCESSOR_CODEC = class_2960.field_25139.fieldOf("structureId").xmap(Processor::new, processor -> processor.structureId).codec();
    public static final class_3828<Processor> PROCESSOR_TYPE = (class_3828)class_2378.method_10230((class_2378)class_7923.field_41161, (class_2960)Create.asResource("fabric_structure_processor"), () -> PROCESSOR_CODEC);
    public static final ProcessingPredicate ALWAYS = (id, process) -> true;
    private static final Map<String, ProcessingPredicate> predicates = new HashMap<String, ProcessingPredicate>();

    public static ProcessingPredicate register(String modId, ProcessingPredicate predicate) {
        ProcessingPredicate existing = predicates.get(modId);
        if (existing != null) {
            throw new IllegalStateException("Tried to register ProcessingPredicate [%s] for mod '%s', while one already exists: [%s]".formatted(predicate, modId, existing));
        }
        predicates.put(modId, predicate);
        return predicate;
    }

    @ApiStatus.Internal
    public static void init() {
        FabricStructureProcessing.register("create", ALWAYS);
    }

    private static void fixTankContent(class_2487 content) {
        if (content.method_10573("FluidName", 8) && content.method_10558("FluidName").equals("minecraft:milk")) {
            content.method_10582("FluidName", "milk:still_milk");
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((class_2487)content);
        long amount = stack.getAmount();
        double buckets = (double)amount / 1000.0;
        long fixedAmount = Math.round(buckets * 81000.0);
        stack.setAmount(fixedAmount);
        Set.copyOf(content.method_10541()).forEach(arg_0 -> ((class_2487)content).method_10551(arg_0));
        stack.writeToNBT(content);
    }

    @FunctionalInterface
    public static interface ProcessingPredicate {
        public boolean shouldApplyProcess(class_2960 var1, Process var2);
    }

    public static class Processor
    extends class_3491 {
        public final class_2960 structureId;

        public Processor(class_2960 structureId) {
            this.structureId = structureId;
        }

        @Nullable
        public class_3499.class_3501 method_15110(@NotNull class_4538 level, @NotNull class_2338 pos, @NotNull class_2338 pivot, @NotNull class_3499.class_3501 blockInfo, @NotNull class_3499.class_3501 relativeBlockInfo, @NotNull class_3492 settings) {
            ProcessingPredicate predicate = predicates.get(this.structureId.method_12836());
            if (predicate == null) {
                return relativeBlockInfo;
            }
            class_2487 nbt = relativeBlockInfo.comp_1343();
            if (nbt == null) {
                return relativeBlockInfo;
            }
            if (!predicate.shouldApplyProcess(this.structureId, Process.FLUID_AMOUNTS)) {
                return relativeBlockInfo;
            }
            if (AllBlocks.FLUID_TANK.has(relativeBlockInfo.comp_1342()) && nbt.method_10573("TankContent", 10)) {
                class_2487 copy = nbt.method_10553();
                FabricStructureProcessing.fixTankContent(copy.method_10562("TankContent"));
                return new class_3499.class_3501(relativeBlockInfo.comp_1341(), relativeBlockInfo.comp_1342(), copy);
            }
            if (AllBlocks.BASIN.has(relativeBlockInfo.comp_1342())) {
                class_2499 outputTanks;
                class_2487 copy = nbt.method_10553();
                class_2499 inputTanks = copy.method_10554("InputTanks", 10);
                if (!inputTanks.isEmpty()) {
                    for (int i = 0; i < inputTanks.size(); ++i) {
                        class_2487 compound = inputTanks.method_10602(i);
                        class_2487 content = compound.method_10562("TankContent");
                        FabricStructureProcessing.fixTankContent(content);
                    }
                }
                if (!(outputTanks = copy.method_10554("OutputTanks", 10)).isEmpty()) {
                    for (int i = 0; i < outputTanks.size(); ++i) {
                        class_2487 compound = outputTanks.method_10602(i);
                        class_2487 content = compound.method_10562("TankContent");
                        FabricStructureProcessing.fixTankContent(content);
                    }
                }
                return new class_3499.class_3501(relativeBlockInfo.comp_1341(), relativeBlockInfo.comp_1342(), copy);
            }
            return relativeBlockInfo;
        }

        @NotNull
        protected class_3828<?> method_16772() {
            return PROCESSOR_TYPE;
        }
    }

    public static enum Process {
        FLUID_AMOUNTS;

    }
}

