/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterBlockEntity;
import com.simibubi.create.content.contraptions.bearing.SailBlock;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4778;

public class BearingScenes {
    public static void windmillsAsSource(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("windmill_source", "Generating Rotational Force using Windmill Bearings");
        scene.configureBasePlate(1, 1, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.scaleSceneView(0.9f);
        scene.world().showSection(util.select().fromTo(1, 0, 1, 5, 0, 5), class_2350.field_11036);
        scene.world().setBlock(util.grid().at(2, -1, 0), (class_2680)AllBlocks.SAIL.getDefaultState().method_11657((class_2769)SailBlock.field_10927, (Comparable)class_2350.field_11043), false);
        scene.idle(5);
        Selection kinetics = util.select().fromTo(3, 1, 1, 4, 1, 4);
        Selection largeCog = util.select().position(3, 2, 2);
        class_2338 windmill = util.grid().at(3, 2, 1);
        scene.world().showSection(kinetics.add(largeCog), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(windmill), class_2350.field_11033);
        scene.idle(10);
        class_2338 anchorPos = windmill.method_10095();
        scene.overlay().showOutlineWithText(util.select().position(anchorPos), 60).colored(PonderPalette.GREEN).pointAt(util.vector().blockSurface(windmill, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("Windmill Bearings attach to the block in front of them");
        scene.idle(50);
        ElementLink structure = scene.world().showIndependentSection(util.select().position(anchorPos), class_2350.field_11035);
        scene.idle(10);
        for (class_2350 d : Iterate.directions) {
            if (d.method_10166() == class_2350.class_2351.field_11051) continue;
            scene.world().showSectionAndMerge(util.select().fromTo(anchorPos.method_10079(d, 1), anchorPos.method_10079(d, 2)), d.method_10153(), structure);
        }
        scene.idle(10);
        scene.world().showSectionAndMerge(util.select().fromTo(anchorPos.method_10084().method_10078(), anchorPos.method_10086(3).method_10078()), class_2350.field_11039, structure);
        scene.world().showSectionAndMerge(util.select().fromTo(anchorPos.method_10074().method_10067(), anchorPos.method_10087(3).method_10067()), class_2350.field_11034, structure);
        scene.world().showSectionAndMerge(util.select().fromTo(anchorPos.method_10078().method_10074(), anchorPos.method_10089(3).method_10074()), class_2350.field_11036, structure);
        scene.world().showSectionAndMerge(util.select().fromTo(anchorPos.method_10067().method_10084(), anchorPos.method_10088(3).method_10084()), class_2350.field_11033, structure);
        scene.idle(5);
        for (class_2350 d : Iterate.directions) {
            if (d.method_10166() == class_2350.class_2351.field_11051) continue;
            scene.effects().superGlue(anchorPos.method_10079(d, 1), d.method_10153(), false);
        }
        scene.idle(10);
        class_238 bb1 = new class_238(util.grid().at(5, 2, 0));
        class_238 bb2 = new class_238(util.grid().at(3, 4, 0));
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb1, bb1, 1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb1, bb1.method_1012(-4.0, 0.0, 0.0), 75);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb2, bb2, 1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb2, bb2.method_1012(0.0, -4.0, 0.0), 80);
        scene.idle(10);
        scene.overlay().showControls(util.vector().centerOf(util.grid().at(5, 2, 0)), Pointing.RIGHT, 40).withItem(AllItems.SUPER_GLUE.asStack());
        scene.idle(15);
        scene.overlay().showText(60).pointAt(util.vector().blockSurface(util.grid().at(1, 2, 0), class_2350.field_11043)).attachKeyFrame().placeNearTarget().text("Create a movable structure with the help of Super Glue");
        scene.idle(70);
        scene.overlay().showText(80).pointAt(util.vector().centerOf(1, 3, 0)).attachKeyFrame().placeNearTarget().text("If enough Sail-like blocks are included, this can act as a Windmill");
        scene.idle(70);
        scene.rotateCameraY(-90.0f);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(windmill).method_1023(0.5, 0.0, 0.0), Pointing.DOWN, 60).rightClick();
        scene.idle(7);
        scene.world().rotateBearing(windmill, 360.0f, 200);
        scene.world().rotateSection(structure, 0.0, 0.0, 360.0, 200);
        scene.world().setKineticSpeed(largeCog, 4.0f);
        scene.world().setKineticSpeed(kinetics, -8.0f);
        scene.effects().rotationDirectionIndicator(windmill.method_10072());
        class_2338 gaugePos = util.grid().at(4, 1, 4);
        scene.effects().indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay().showText(60).pointAt(util.vector().topOf(windmill).method_1023(0.5, 0.0, 0.0)).placeNearTarget().attachKeyFrame().text("Activated with Right-Click, the Windmill Bearing will start providing Rotational Force");
        scene.idle(70);
        scene.overlay().showText(60).pointAt(util.vector().blockSurface(gaugePos, class_2350.field_11039)).colored(PonderPalette.SLOW).placeNearTarget().text("The Amount of Sail Blocks determine its Rotation Speed");
        scene.idle(90);
        class_243 surface = util.vector().blockSurface(windmill, class_2350.field_11039).method_1031(0.0, 0.0, 0.125);
        scene.overlay().showControls(surface, Pointing.DOWN, 60).rightClick();
        scene.overlay().showFilterSlotInput(surface, class_2350.field_11039, 50);
        scene.overlay().showText(60).pointAt(surface).attachKeyFrame().placeNearTarget().text("Use the value panel to configure its rotation direction");
        scene.idle(36);
        scene.world().rotateBearing(windmill, -135.0f, 75);
        scene.world().rotateSection(structure, 0.0, 0.0, -135.0, 75);
        scene.world().modifyKineticSpeed(largeCog, f -> Float.valueOf(-f.floatValue()));
        scene.world().modifyKineticSpeed(kinetics, f -> Float.valueOf(-f.floatValue()));
        scene.effects().rotationDirectionIndicator(windmill.method_10072());
        scene.idle(69);
        scene.overlay().showControls(util.vector().topOf(windmill).method_1023(0.5, 0.0, 0.0), Pointing.DOWN, 60).rightClick();
        scene.idle(7);
        scene.world().rotateBearing(windmill, -45.0f, 0);
        scene.world().rotateSection(structure, 0.0, 0.0, -45.0, 0);
        scene.world().setKineticSpeed(largeCog, 0.0f);
        scene.world().setKineticSpeed(kinetics, 0.0f);
        scene.idle(10);
        scene.overlay().showText(60).pointAt(util.vector().topOf(windmill).method_1023(0.5, 0.0, 0.0)).placeNearTarget().text("Right-click the Bearing anytime to stop and edit the Structure again");
        scene.idle(30);
    }

    public static void windmillsAnyStructure(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("windmill_structure", "Windmill Contraptions");
        scene.configureBasePlate(1, 1, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.world().modifyEntities(SuperGlueEntity.class, class_1297::method_31472);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 bearingPos = util.grid().at(3, 1, 3);
        scene.world().showSection(util.select().position(bearingPos), class_2350.field_11033);
        scene.idle(10);
        ElementLink contraption = scene.world().showIndependentSection(util.select().position(bearingPos.method_10084()), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSectionAndMerge(util.select().fromTo(3, 2, 2, 3, 3, 1), class_2350.field_11035, contraption);
        scene.world().showSectionAndMerge(util.select().fromTo(3, 2, 4, 3, 3, 5), class_2350.field_11043, contraption);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(3, 1, 5), class_2350.field_11043, contraption);
        scene.world().showSectionAndMerge(util.select().position(3, 4, 2), class_2350.field_11033, contraption);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(2, 1, 5), class_2350.field_11034, contraption);
        scene.world().showSectionAndMerge(util.select().position(3, 3, 3), class_2350.field_11033, contraption);
        scene.idle(5);
        scene.effects().superGlue(bearingPos.method_10084(), class_2350.field_11035, true);
        scene.effects().superGlue(bearingPos.method_10084(), class_2350.field_11043, true);
        scene.idle(5);
        scene.effects().superGlue(util.grid().at(3, 1, 5), class_2350.field_11036, true);
        scene.idle(5);
        scene.effects().superGlue(util.grid().at(3, 3, 3), class_2350.field_11033, true);
        scene.idle(10);
        scene.overlay().showOutline(PonderPalette.BLUE, (Object)bearingPos, util.select().fromTo(3, 2, 1, 3, 3, 2), 80);
        scene.overlay().showOutlineWithText(util.select().fromTo(3, 2, 4, 3, 3, 5), 80).colored(PonderPalette.BLUE).attachKeyFrame().text("Any Structure can count as a valid Windmill, as long as it contains at least 8 sail-like Blocks.");
        scene.idle(90);
        scene.overlay().showControls(util.vector().blockSurface(bearingPos, class_2350.field_11039), Pointing.LEFT, 40).rightClick();
        scene.idle(7);
        scene.markAsFinished();
        scene.world().rotateBearing(bearingPos, -720.0f, 400);
        scene.world().rotateSection(contraption, 0.0, -720.0, 0.0, 400);
        scene.world().modifyBlockEntity(util.grid().at(2, 1, 5), HarvesterBlockEntity.class, hte -> hte.setAnimatedSpeed(-150.0f));
        scene.idle(400);
        scene.world().modifyBlockEntity(util.grid().at(2, 1, 5), HarvesterBlockEntity.class, hte -> hte.setAnimatedSpeed(0.0f));
    }

    public static void mechanicalBearing(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_bearing", "Moving Structures using the Mechanical Bearing");
        scene.configureBasePlate(1, 1, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().layer(1), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().layer(2), class_2350.field_11033);
        scene.idle(10);
        Selection cog1 = util.select().position(6, 0, 4);
        Selection cog2 = util.select().position(5, 1, 4);
        Selection cog3 = util.select().position(4, 1, 3);
        Selection cog4 = util.select().position(3, 1, 3);
        Selection all = cog1.copy().add(cog2).add(cog3).add(cog4);
        class_2338 bearingPos = util.grid().at(3, 2, 3);
        scene.overlay().showOutlineWithText(util.select().position(bearingPos.method_10084()), 60).colored(PonderPalette.GREEN).pointAt(util.vector().blockSurface(bearingPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("Mechanical Bearings attach to the block in front of them");
        scene.idle(50);
        ElementLink plank = scene.world().showIndependentSection(util.select().position(bearingPos.method_10084().method_10078().method_10095()), class_2350.field_11033);
        scene.world().moveSection(plank, util.vector().of(-1.0, 0.0, 1.0), 0);
        scene.idle(20);
        scene.world().setKineticSpeed(cog1, -8.0f);
        scene.world().setKineticSpeed(cog2, 8.0f);
        scene.world().setKineticSpeed(cog3, -16.0f);
        scene.world().setKineticSpeed(cog4, 16.0f);
        scene.effects().rotationSpeedIndicator(bearingPos.method_10074());
        scene.world().rotateBearing(bearingPos, 360.0f, 74);
        scene.world().rotateSection(plank, 0.0, 360.0, 0.0, 74);
        scene.overlay().showText(80).pointAt(util.vector().topOf(bearingPos.method_10084())).placeNearTarget().attachKeyFrame().text("Upon receiving Rotational Force, it will assemble it into a Rotating Contraption");
        scene.idle(74);
        scene.world().setKineticSpeed(all, 0.0f);
        scene.idle(20);
        scene.world().hideIndependentSection(plank, class_2350.field_11036);
        scene.idle(15);
        Selection plank2 = util.select().position(4, 3, 2);
        ElementLink contraption = scene.world().showIndependentSection(util.select().layersFrom(3).substract(plank2), class_2350.field_11033);
        scene.world().replaceBlocks(util.select().fromTo(2, 4, 3, 4, 3, 3), class_2246.field_10161.method_9564(), false);
        scene.idle(10);
        scene.overlay().showOutline(PonderPalette.GREEN, (Object)"glue", util.select().position(2, 4, 3).add(util.select().fromTo(4, 3, 3, 2, 3, 3)).add(util.select().position(4, 3, 2)), 40);
        scene.overlay().showControls(util.vector().centerOf(util.grid().at(4, 3, 3)), Pointing.RIGHT, 40).withItem(AllItems.SUPER_GLUE.asStack());
        scene.idle(10);
        scene.world().showSectionAndMerge(plank2, class_2350.field_11035, contraption);
        scene.idle(15);
        scene.effects().superGlue(util.grid().at(4, 3, 2), class_2350.field_11035, true);
        scene.overlay().showText(120).pointAt(util.vector().topOf(bearingPos.method_10084())).placeNearTarget().attachKeyFrame().sharedText("movement_anchors");
        scene.idle(25);
        scene.world().configureCenterOfRotation(contraption, util.vector().topOf(bearingPos));
        scene.world().setKineticSpeed(cog1, -8.0f);
        scene.world().setKineticSpeed(cog2, 8.0f);
        scene.world().setKineticSpeed(cog3, -16.0f);
        scene.world().setKineticSpeed(cog4, 16.0f);
        scene.effects().rotationSpeedIndicator(bearingPos.method_10074());
        scene.world().rotateBearing(bearingPos, 720.0f, 148);
        scene.world().rotateSection(contraption, 0.0, 720.0, 0.0, 148);
        scene.idle(148);
        scene.world().setKineticSpeed(all, 0.0f);
    }

    public static void bearingModes(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("bearing_modes", "Movement Modes of the Mechanical Bearing");
        scene.configureBasePlate(1, 1, 6);
        scene.setSceneOffsetY(-1.0f);
        Selection sideCog = util.select().position(util.grid().at(7, 0, 3));
        Selection cogColumn = util.select().fromTo(6, 1, 3, 6, 4, 3);
        Selection cogAndClutch = util.select().fromTo(5, 3, 1, 5, 4, 2);
        class_2338 leverPos = util.grid().at(5, 3, 1);
        scene.world().setKineticSpeed(sideCog, 4.0f);
        scene.world().setKineticSpeed(cogColumn, -4.0f);
        scene.world().setKineticSpeed(cogAndClutch, 8.0f);
        scene.world().toggleRedstonePower(cogAndClutch);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(cogColumn, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(cogAndClutch, class_2350.field_11033);
        scene.idle(10);
        class_2338 bearingPos = util.grid().at(5, 2, 2);
        scene.world().showSection(util.select().position(bearingPos), class_2350.field_11036);
        scene.idle(10);
        ElementLink contraption = scene.world().showIndependentSection(util.select().fromTo(5, 1, 2, 2, 1, 2), class_2350.field_11034);
        scene.world().configureCenterOfRotation(contraption, util.vector().centerOf(bearingPos));
        scene.idle(20);
        scene.world().toggleRedstonePower(cogAndClutch);
        scene.effects().indicateRedstone(leverPos);
        scene.world().rotateSection(contraption, 0.0, 55.0, 0.0, 23);
        scene.world().rotateBearing(bearingPos, 55.0f, 23);
        scene.idle(24);
        scene.world().toggleRedstonePower(cogAndClutch);
        scene.effects().indicateRedstone(leverPos);
        scene.world().rotateSection(contraption, 0.0, 35.0, 0.0, 0);
        scene.world().rotateBearing(bearingPos, 35.0f, 0);
        class_243 target = util.vector().topOf(bearingPos.method_10074());
        scene.overlay().showLine(PonderPalette.RED, target.method_1031(-2.5, 0.0, 3.5), target, 50);
        scene.overlay().showLine(PonderPalette.GREEN, target.method_1031(0.0, 0.0, 4.5), target, 50);
        scene.idle(50);
        scene.overlay().showText(100).pointAt(util.vector().topOf(util.grid().at(5, 0, 4))).placeNearTarget().colored(PonderPalette.RED).attachKeyFrame().text("When Stopped, the Bearing will place the structure at the nearest grid-aligned Angle");
        scene.idle(110);
        class_243 blockSurface = util.vector().blockSurface(bearingPos, class_2350.field_11043).method_1031(0.0, 0.125, 0.0);
        scene.overlay().showFilterSlotInput(blockSurface, class_2350.field_11043, 60);
        scene.overlay().showControls(blockSurface, Pointing.DOWN, 60).rightClick();
        scene.idle(10);
        scene.overlay().showText(60).pointAt(blockSurface).placeNearTarget().attachKeyFrame().sharedText("behaviour_modify_value_panel");
        scene.idle(70);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world().toggleRedstonePower(cogAndClutch);
        scene.effects().indicateRedstone(leverPos);
        scene.world().rotateSection(contraption, 0.0, -55.0, 0.0, 23);
        scene.world().rotateBearing(bearingPos, -55.0f, 23);
        scene.idle(24);
        scene.world().toggleRedstonePower(cogAndClutch);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(40);
        scene.overlay().showText(120).colored(PonderPalette.GREEN).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 1, 3), class_2350.field_11036)).text("It can be configured never to revert to solid blocks, or only near the angle it started at");
        scene.idle(90);
    }

    public static void stabilizedBearings(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("stabilized_bearings", "Stabilized Contraptions");
        scene.configureBasePlate(1, 1, 5);
        scene.setSceneOffsetY(-1.0f);
        Selection beltAndBearing = util.select().fromTo(3, 3, 4, 3, 1, 6);
        Selection largeCog = util.select().position(2, 0, 6);
        class_2338 parentBearingPos = util.grid().at(3, 3, 4);
        class_2338 bearingPos = util.grid().at(3, 4, 2);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(beltAndBearing, class_2350.field_11033);
        scene.idle(10);
        ElementLink contraption = scene.world().showIndependentSection(util.select().fromTo(3, 3, 3, 3, 4, 3), class_2350.field_11035);
        scene.world().configureCenterOfRotation(contraption, util.vector().centerOf(parentBearingPos));
        scene.idle(20);
        scene.world().glueBlockOnto(bearingPos, class_2350.field_11035, contraption);
        scene.idle(15);
        scene.overlay().showOutlineWithText(util.select().position(bearingPos), 60).text("Whenever Mechanical Bearings are themselves part of a moving Structure..").attachKeyFrame().placeNearTarget();
        scene.idle(70);
        scene.world().setKineticSpeed(largeCog, -8.0f);
        scene.world().setKineticSpeed(beltAndBearing, 16.0f);
        scene.world().rotateBearing(parentBearingPos, 360.0f, 74);
        scene.world().rotateSection(contraption, 0.0, 0.0, 360.0, 74);
        scene.world().rotateBearing(bearingPos, -360.0f, 74);
        scene.idle(74);
        scene.world().setKineticSpeed(largeCog, 0.0f);
        scene.world().setKineticSpeed(beltAndBearing, 0.0f);
        scene.overlay().showText(60).text("..they will attempt to keep themselves upright").pointAt(util.vector().blockSurface(bearingPos, class_2350.field_11043)).placeNearTarget();
        scene.idle(70);
        scene.overlay().showOutlineWithText(util.select().position(bearingPos.method_10095()), 60).colored(PonderPalette.GREEN).text("Once again, the bearing will attach to the block in front of it").attachKeyFrame().placeNearTarget();
        scene.idle(70);
        ElementLink subContraption = scene.world().showIndependentSection(util.select().fromTo(4, 4, 1, 2, 4, 1), class_2350.field_11035);
        scene.world().configureCenterOfRotation(subContraption, util.vector().centerOf(parentBearingPos));
        scene.world().configureStabilization(subContraption, util.vector().centerOf(bearingPos));
        scene.idle(20);
        scene.overlay().showText(80).text("As a result, the entire sub-Contraption will stay upright");
        scene.world().setKineticSpeed(largeCog, -8.0f);
        scene.world().setKineticSpeed(beltAndBearing, 16.0f);
        scene.world().rotateBearing(parentBearingPos, 720.0f, 148);
        scene.world().rotateSection(contraption, 0.0, 0.0, 720.0, 148);
        scene.world().rotateBearing(bearingPos, -720.0f, 148);
        scene.world().rotateSection(subContraption, 0.0, 0.0, 720.0, 148);
        scene.markAsFinished();
        scene.idle(148);
        scene.world().setKineticSpeed(largeCog, 0.0f);
        scene.world().setKineticSpeed(beltAndBearing, 0.0f);
    }

    public static void clockwork(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("clockwork_bearing", "Animating Structures using Clockwork Bearings");
        scene.configureBasePlate(1, 1, 5);
        scene.setSceneOffsetY(-1.0f);
        Selection kinetics = util.select().fromTo(3, 3, 4, 3, 1, 6);
        Selection largeCog = util.select().position(2, 0, 6);
        class_2338 bearingPos = util.grid().at(3, 3, 3);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(kinetics, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(bearingPos), class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().position(bearingPos.method_10095()), 60).colored(PonderPalette.GREEN).pointAt(util.vector().blockSurface(bearingPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("Clockwork Bearings attach to blocks in front of them");
        scene.idle(50);
        ElementLink plank = scene.world().showIndependentSection(util.select().position(2, 3, 2), class_2350.field_11035);
        scene.world().moveSection(plank, util.vector().of(1.0, 0.0, 0.0), 0);
        scene.idle(20);
        scene.world().rotateSection(plank, 0.0, 0.0, 60.0, 25);
        scene.world().rotateBearing(bearingPos, 60.0f, 25);
        scene.world().setKineticSpeed(kinetics, 8.0f);
        scene.world().setKineticSpeed(largeCog, -4.0f);
        scene.idle(25);
        scene.overlay().showText(80).pointAt(util.vector().blockSurface(bearingPos.method_10095(), class_2350.field_11043)).placeNearTarget().attachKeyFrame().text("Upon receiving Rotational Force, the structure will be rotated according to the hour of the day");
        scene.idle(90);
        scene.overlay().showText(30).pointAt(util.vector().blockSurface(bearingPos.method_10095(), class_2350.field_11043)).placeNearTarget().text("3:00");
        scene.world().rotateSection(plank, 0.0, 0.0, 30.0, 12);
        scene.world().rotateBearing(bearingPos, 30.0f, 12);
        scene.idle(42);
        scene.overlay().showText(30).pointAt(util.vector().blockSurface(bearingPos.method_10095(), class_2350.field_11043)).placeNearTarget().text("4:00");
        scene.world().rotateSection(plank, 0.0, 0.0, 30.0, 12);
        scene.world().rotateBearing(bearingPos, 30.0f, 12);
        scene.idle(42);
        scene.overlay().showControls(util.vector().topOf(bearingPos), Pointing.DOWN, 60).rightClick();
        scene.idle(7);
        scene.world().rotateSection(plank, 0.0, 0.0, -120.0, 0);
        scene.world().rotateBearing(bearingPos, -120.0f, 0);
        scene.overlay().showText(60).pointAt(util.vector().blockSurface(bearingPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("Right-Click the bearing to start or stop animating the structure");
        scene.idle(70);
        scene.world().hideIndependentSection(plank, class_2350.field_11043);
        scene.idle(15);
        scene.world().replaceBlocks(util.select().fromTo(3, 3, 1, 3, 4, 2), class_2246.field_10161.method_9564(), false);
        ElementLink hourHand = scene.world().showIndependentSection(util.select().fromTo(3, 3, 1, 3, 5, 2), class_2350.field_11035);
        scene.world().configureCenterOfRotation(hourHand, util.vector().centerOf(bearingPos));
        scene.idle(15);
        scene.overlay().showControls(util.vector().centerOf(util.grid().at(3, 4, 1)), Pointing.RIGHT, 40).withItem(AllItems.SUPER_GLUE.asStack());
        scene.overlay().showOutlineWithText(util.select().fromTo(3, 3, 1, 3, 4, 2), 80).placeNearTarget().attachKeyFrame().colored(PonderPalette.GREEN).sharedText("movement_anchors");
        scene.idle(90);
        scene.overlay().showControls(util.vector().blockSurface(bearingPos, class_2350.field_11039), Pointing.LEFT, 20).rightClick();
        scene.idle(7);
        scene.world().rotateSection(hourHand, 0.0, 0.0, 120.0, 50);
        scene.world().rotateBearing(bearingPos, 120.0f, 50);
        scene.idle(60);
        scene.overlay().showOutlineWithText(util.select().position(bearingPos.method_10076(3)), 80).placeNearTarget().colored(PonderPalette.BLUE).attachKeyFrame().text("In front of the Hour Hand, a second structure can be added");
        scene.idle(90);
        scene.overlay().showControls(util.vector().blockSurface(bearingPos, class_2350.field_11039), Pointing.LEFT, 20).rightClick();
        scene.idle(7);
        scene.world().rotateSection(hourHand, 0.0, 0.0, -120.0, 0);
        scene.world().rotateBearing(bearingPos, -120.0f, 0);
        scene.idle(10);
        scene.world().setBlock(util.grid().at(3, 3, 0), (class_2680)class_2246.field_10252.method_9564().method_11657((class_2769)class_2544.field_22158, (Comparable)class_4778.field_22180), false);
        ElementLink minuteHand = scene.world().showIndependentSection(util.select().fromTo(3, 3, 0, 3, 6, 0), class_2350.field_11035);
        scene.world().configureCenterOfRotation(minuteHand, util.vector().centerOf(bearingPos));
        scene.idle(30);
        scene.overlay().showOutline(PonderPalette.BLUE, (Object)minuteHand, util.select().fromTo(3, 3, 0, 3, 6, 0), 85);
        scene.overlay().showOutlineWithText(util.select().fromTo(3, 3, 1, 3, 4, 2), 80).placeNearTarget().colored(PonderPalette.GREEN).text("Ensure that the two Structures are not glued to each other");
        scene.idle(90);
        scene.overlay().showControls(util.vector().blockSurface(bearingPos, class_2350.field_11039), Pointing.LEFT, 20).rightClick();
        scene.idle(7);
        scene.world().rotateSection(hourHand, 0.0, 0.0, 120.0, 50);
        scene.world().rotateSection(minuteHand, 0.0, 0.0, 180.0, 75);
        scene.world().rotateBearing(bearingPos, 120.0f, 50);
        scene.idle(90);
        scene.world().rotateSection(minuteHand, 0.0, 0.0, 6.0, 3);
        scene.overlay().showText(80).placeNearTarget().pointAt(util.vector().blockSurface(bearingPos.method_10076(3), class_2350.field_11043)).colored(PonderPalette.GREEN).text("The Second Structure will now rotate as the Minute Hand");
        scene.markAsFinished();
        for (int i = 0; i < 40; ++i) {
            scene.idle(23);
            scene.world().rotateSection(minuteHand, 0.0, 0.0, 6.0, 3);
            if (i != 29) continue;
            scene.world().rotateSection(hourHand, 0.0, 0.0, 30.0, 20);
        }
    }

    public static void sail(SceneBuilder scene, SceneBuildingUtil util) {
        BearingScenes.sails(scene, util, false);
    }

    public static void sailFrame(SceneBuilder scene, SceneBuildingUtil util) {
        BearingScenes.sails(scene, util, true);
    }

    private static void sails(SceneBuilder builder, SceneBuildingUtil util, boolean frame) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        String plural = frame ? "Sail Frames" : "Sails";
        scene.title(frame ? "sail_frame" : "sail", "Assembling Windmills using " + plural);
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 bearingPos = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().position(bearingPos), class_2350.field_11033);
        scene.idle(5);
        ElementLink plank = scene.world().showIndependentSection(util.select().position(bearingPos.method_10084()), class_2350.field_11033);
        scene.idle(10);
        for (int i = 0; i < 3; ++i) {
            for (class_2350 d : Iterate.horizontalDirections) {
                class_2338 location = bearingPos.method_10086(i + 1).method_10093(d);
                if (frame) {
                    scene.world().modifyBlock(location, s -> (class_2680)AllBlocks.SAIL_FRAME.getDefaultState().method_11657((class_2769)SailBlock.field_10927, (Comparable)((class_2350)s.method_11654((class_2769)SailBlock.field_10927))), false);
                }
                scene.world().showSectionAndMerge(util.select().position(location), d.method_10153(), plank);
                scene.idle(2);
            }
        }
        scene.overlay().showText(70).text(plural + " are handy blocks to create Windmills with").pointAt(util.vector().blockSurface(util.grid().at(1, 3, 2), class_2350.field_11039)).placeNearTarget().attachKeyFrame();
        scene.idle(80);
        scene.overlay().showOutlineWithText(util.select().position(bearingPos.method_10084()), 80).colored(PonderPalette.GREEN).text("They will attach to blocks and each other without the need of Super Glue or Chassis Blocks").attachKeyFrame().placeNearTarget();
        scene.idle(40);
        scene.world().configureCenterOfRotation(plank, util.vector().centerOf(bearingPos));
        if (!frame) {
            scene.world().rotateBearing(bearingPos, 180.0f, 75);
            scene.world().rotateSection(plank, 0.0, 180.0, 0.0, 75);
            scene.idle(76);
            scene.world().rotateBearing(bearingPos, 180.0f, 0);
            scene.world().rotateSection(plank, 0.0, 180.0, 0.0, 0);
            scene.rotateCameraY(-30.0f);
            scene.idle(10);
            scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11043), Pointing.RIGHT, 30).withItem(new class_1799((class_1935)class_1802.field_8345));
            scene.idle(7);
            scene.world().setBlock(util.grid().at(2, 3, 1), (class_2680)AllBlocks.DYED_SAILS.get(class_1767.field_7966).getDefaultState().method_11657((class_2769)SailBlock.field_10927, (Comparable)class_2350.field_11039), false);
            scene.idle(10);
            scene.overlay().showText(40).colored(PonderPalette.BLUE).text("Right-Click with Dye to paint them").attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11039)).placeNearTarget();
            scene.idle(20);
            scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11043), Pointing.RIGHT, 30).withItem(new class_1799((class_1935)class_1802.field_8345));
            scene.idle(7);
            scene.world().replaceBlocks(util.select().fromTo(2, 2, 1, 2, 4, 1), (class_2680)AllBlocks.DYED_SAILS.get(class_1767.field_7966).getDefaultState().method_11657((class_2769)SailBlock.field_10927, (Comparable)class_2350.field_11039), false);
            scene.idle(20);
            scene.world().rotateBearing(bearingPos, 90.0f, 33);
            scene.world().rotateSection(plank, 0.0, 90.0, 0.0, 33);
            scene.idle(40);
            scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11043), Pointing.RIGHT, 30).withItem(new class_1799((class_1935)class_1802.field_8868));
            scene.idle(7);
            scene.world().setBlock(util.grid().at(3, 3, 2), (class_2680)AllBlocks.SAIL_FRAME.getDefaultState().method_11657((class_2769)SailBlock.field_10927, (Comparable)class_2350.field_11043), false);
            scene.idle(10);
            scene.overlay().showText(40).text("Right-Click with Shears to turn them back into frames").attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11039)).placeNearTarget();
            scene.idle(20);
            scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 1), class_2350.field_11043), Pointing.RIGHT, 30).withItem(new class_1799((class_1935)class_1802.field_8868));
            scene.idle(7);
            scene.world().replaceBlocks(util.select().fromTo(3, 2, 2, 3, 4, 2), (class_2680)AllBlocks.SAIL_FRAME.getDefaultState().method_11657((class_2769)SailBlock.field_10927, (Comparable)class_2350.field_11043), false);
            scene.idle(20);
        }
        scene.world().rotateBearing(bearingPos, 720.0f, 300);
        scene.world().rotateSection(plank, 0.0, 720.0, 0.0, 300);
    }
}

