/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.test.framework;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class TestResult {
    private final String name;
    private final Status status;
    @Nullable
    private final String error;

    private TestResult(String name, Status status, @Nullable String error) {
        this.name = name;
        this.status = status;
        this.error = error;
    }

    public static TestResult pass(String name) {
        return new TestResult(name, Status.PASSED, null);
    }

    public static TestResult error(String name, String error) {
        return new TestResult(name, Status.FAILED, error);
    }

    public static TestResult skip(String name) {
        return new TestResult(name, Status.SKIPPED, null);
    }

    public String name() {
        return this.name;
    }

    public Status status() {
        return this.status;
    }

    @Nullable
    public String error() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResult that = (TestResult)o;
        return Objects.equals(this.name, that.name) && this.status == that.status && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.status, this.error});
    }

    public String toString() {
        return "[" + String.valueOf((Object)this.status) + "] " + this.name + (String)(this.error != null ? "\n" + this.error : "");
    }

    public static enum Status {
        PASSED,
        FAILED,
        SKIPPED;

    }
}

