/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.client.gui.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import me.roundaround.pickupnotifications.PickupNotificationsMod;
import me.roundaround.pickupnotifications.config.IconAlignment;
import me.roundaround.pickupnotifications.config.PickupNotificationsConfig;
import me.roundaround.pickupnotifications.roundalib.client.gui.GuiUtil;
import me.roundaround.pickupnotifications.roundalib.config.value.GuiAlignment;
import me.roundaround.pickupnotifications.roundalib.config.value.Position;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class PickupNotificationLine {
    public static final int SHOW_DURATION = 120;
    public static final int DURATION_INCREASE_ON_ADD = 60;
    public static final int POP_DURATION = 5;
    public static final int ANIM_DURATION = 6;
    public static final int ANIM_IN_FINISH_TIME = 114;
    public static final int SPRITE_RAW_SIZE = 16;
    public static final int LEFT_PADDING = 1;
    private final class_1799 itemStack;
    private final PickupNotificationsConfig config;
    private final boolean timeless;
    private final class_310 minecraft;
    private int originalTimeRemaining;
    private int timeRemaining;
    private int popTimeRemaining;
    private long lastTick;

    public PickupNotificationLine(class_1799 initialItems) {
        this(initialItems, PickupNotificationsMod.CONFIG, false);
    }

    public PickupNotificationLine(class_1799 initialItems, PickupNotificationsConfig config, boolean timeless) {
        this.itemStack = initialItems.method_7972();
        this.config = config;
        this.timeless = timeless;
        this.minecraft = class_310.method_1551();
        this.originalTimeRemaining = 120;
        this.timeRemaining = 120;
    }

    public void tick() {
        --this.timeRemaining;
        --this.originalTimeRemaining;
        --this.popTimeRemaining;
        this.lastTick = class_156.method_658();
    }

    public void render(class_332 drawContext, int idx) {
        GuiAlignment alignment = (GuiAlignment)this.config.GUI_ALIGNMENT.getValue();
        Position offset = (Position)this.config.GUI_OFFSET.getValue();
        float scale = ((Float)this.config.GUI_SCALE.getValue()).floatValue();
        float x = alignment.getPosX() + offset.x() * alignment.getOffsetMultiplierX();
        float y = alignment.getPosY() + offset.y() * alignment.getOffsetMultiplierY();
        class_5250 text = this.getFormattedDisplayString();
        class_327 textRenderer = this.minecraft.field_1772;
        Objects.requireNonNull(textRenderer);
        int spriteSize = 9 + 1;
        int textWidth = textRenderer.method_27525((class_5348)text);
        int fullWidth = 3 + textWidth + spriteSize;
        float xAdjust = 0.0f;
        float yAdjust = 0.0f;
        if (alignment.getAlignmentX() == GuiAlignment.AlignmentX.RIGHT) {
            xAdjust = -fullWidth;
        }
        if (alignment.getAlignmentY() == GuiAlignment.AlignmentY.BOTTOM) {
            Objects.requireNonNull(textRenderer);
            yAdjust = -9 - 2;
        }
        Objects.requireNonNull(textRenderer);
        this.renderBackgroundAndText(drawContext, idx, x += (xAdjust -= (float)fullWidth * this.getXOffsetPercent() * (float)alignment.getOffsetMultiplierX()) * scale, y += (yAdjust += (float)(idx * (9 + 2) * alignment.getOffsetMultiplierY())) * scale, fullWidth);
        this.renderItem(idx, x, y, fullWidth);
    }

    private void renderBackgroundAndText(class_332 drawContext, int idx, float x, float y, int width) {
        int height;
        boolean guiRight = ((GuiAlignment)this.config.GUI_ALIGNMENT.getValue()).getAlignmentX().equals((Object)GuiAlignment.AlignmentX.RIGHT);
        IconAlignment iconAlignment = (IconAlignment)this.config.ICON_ALIGNMENT.getValue();
        boolean rightAligned = iconAlignment.equals(IconAlignment.RIGHT) || guiRight && iconAlignment.equals(IconAlignment.OUTSIDE);
        float scale = ((Float)this.config.GUI_SCALE.getValue()).floatValue();
        class_5250 text = this.getFormattedDisplayString();
        class_327 textRenderer = this.minecraft.field_1772;
        Objects.requireNonNull(textRenderer);
        int spriteSize = height = 9 + 1;
        int leftPad = rightAligned ? 1 : 2 + spriteSize;
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416(x, y, (float)(800 + idx));
        matrixStack.method_22905(scale, scale, 1.0f);
        if (((Boolean)this.config.RENDER_BACKGROUND.getValue()).booleanValue()) {
            drawContext.method_25294(-1, -1, width, height, GuiUtil.genColorInt(0.0f, 0.0f, 0.0f, ((Float)this.config.BACKGROUND_OPACITY.getValue()).floatValue()));
        }
        matrixStack.method_22903();
        matrixStack.method_46416((float)leftPad, 0.0f, 0.0f);
        RenderSystem.enableBlend();
        drawContext.method_51439(textRenderer, (class_2561)text, 0, 1, GuiUtil.LABEL_COLOR, ((Boolean)this.config.RENDER_SHADOW.getValue()).booleanValue());
        RenderSystem.disableBlend();
        matrixStack.method_22909();
        matrixStack.method_22909();
    }

    private void renderItem(int idx, float x, float y, int width) {
        boolean isNotLit;
        float scale = ((Float)this.config.GUI_SCALE.getValue()).floatValue();
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_46416(x, y, (float)(900 + idx));
        matrixStack.method_22905(scale, scale, 1.0f);
        boolean guiRight = ((GuiAlignment)this.config.GUI_ALIGNMENT.getValue()).getAlignmentX().equals((Object)GuiAlignment.AlignmentX.RIGHT);
        IconAlignment iconAlignment = (IconAlignment)this.config.ICON_ALIGNMENT.getValue();
        boolean rightAligned = iconAlignment.equals(IconAlignment.RIGHT) || guiRight && iconAlignment.equals(IconAlignment.OUTSIDE);
        class_327 textRenderer = this.minecraft.field_1772;
        Objects.requireNonNull(textRenderer);
        int spriteSize = 9 + 1;
        long renderTime = class_156.method_658();
        float partialTick = class_3532.method_15363((float)((float)(renderTime - this.lastTick) / 50.0f), (float)0.0f, (float)1.0f);
        float partialPopTimeRemaining = (float)this.popTimeRemaining - partialTick;
        float xPos = rightAligned ? (float)width - (float)spriteSize / 2.0f - 1.0f - 0.5f : (float)spriteSize / 2.0f + 1.0f - 0.5f;
        float yPos = (float)spriteSize / 2.0f - 0.5f;
        matrixStack.method_22903();
        matrixStack.method_46416(xPos, yPos, 0.0f);
        matrixStack.method_22905((float)spriteSize, (float)(-spriteSize), 1.0f);
        float popScale = 1.0f + class_3532.method_15363((float)partialPopTimeRemaining, (float)0.0f, (float)5.0f) / 5.0f;
        matrixStack.method_22903();
        matrixStack.method_22905(1.0f / popScale, (1.0f + popScale) / 2.0f, 1.0f);
        class_918 itemRenderer = this.minecraft.method_1480();
        class_1060 textureManager = this.minecraft.method_1531();
        class_1087 model = itemRenderer.method_4019(this.itemStack, null, (class_1309)this.minecraft.field_1724, 0);
        textureManager.method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        class_4597.class_4598 immediate = this.minecraft.method_22940().method_23000();
        boolean bl = isNotLit = !model.method_24304();
        if (isNotLit) {
            class_308.method_24210();
        }
        itemRenderer.method_23179(this.itemStack, class_811.field_4317, false, matrixStack2, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
        immediate.method_22993();
        matrixStack.method_22909();
        matrixStack.method_22909();
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        if (isNotLit) {
            class_308.method_24211();
        }
        RenderSystem.enableDepthTest();
    }

    public void pop() {
        this.popTimeRemaining = 5;
    }

    public boolean isExpired() {
        return this.timeRemaining <= 0;
    }

    public boolean attemptAdd(class_1799 addition) {
        if (this.isExpired()) {
            return false;
        }
        if (PickupNotificationLine.areItemStacksMergeable(this.itemStack, addition)) {
            this.itemStack.method_7933(addition.method_7947());
            this.timeRemaining = Math.min(this.timeRemaining + 60, 120);
            return true;
        }
        return false;
    }

    private class_5250 getFormattedDisplayString() {
        class_5250 name = class_2561.method_43473().method_10852(this.itemStack.method_7964());
        if (((Boolean)this.config.SHOW_UNIQUE_INFO.getValue()).booleanValue()) {
            name.method_27692(this.itemStack.method_7932().field_8908);
            if (this.itemStack.method_7938()) {
                name.method_27692(class_124.field_1056);
            }
        }
        return class_2561.method_43470((String)(this.itemStack.method_7947() + "x ")).method_10852((class_2561)name);
    }

    private float getXOffsetPercent() {
        if (this.timeless) {
            return 0.0f;
        }
        long renderTime = class_156.method_658();
        float partialTick = class_3532.method_15363((float)((float)(renderTime - this.lastTick) / 50.0f), (float)0.0f, (float)1.0f);
        float partialTimeRemaining = (float)this.timeRemaining - partialTick;
        if (this.originalTimeRemaining > 114) {
            float animTime = Math.max(0.0f, partialTimeRemaining) - 114.0f;
            float basePercent = class_3532.method_15363((float)(animTime / 6.0f), (float)0.0f, (float)1.0f);
            return basePercent * basePercent;
        }
        if (partialTimeRemaining < 6.0f) {
            float animTime = Math.max(0.0f, partialTimeRemaining);
            float basePercent = class_3532.method_15363((float)(animTime / 6.0f), (float)0.0f, (float)1.0f);
            return 1.0f - basePercent * basePercent;
        }
        return 0.0f;
    }

    private static boolean areItemStacksMergeable(class_1799 a, class_1799 b) {
        return !a.method_7960() && !b.method_7960() && class_1799.method_31577((class_1799)a, (class_1799)b);
    }
}

