/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.config;

import java.util.Arrays;
import me.roundaround.pickupnotifications.config.IconAlignment;
import me.roundaround.pickupnotifications.roundalib.config.ModConfig;
import me.roundaround.pickupnotifications.roundalib.config.option.BooleanConfigOption;
import me.roundaround.pickupnotifications.roundalib.config.option.FloatConfigOption;
import me.roundaround.pickupnotifications.roundalib.config.option.IntConfigOption;
import me.roundaround.pickupnotifications.roundalib.config.option.OptionListConfigOption;
import me.roundaround.pickupnotifications.roundalib.config.option.PositionConfigOption;
import me.roundaround.pickupnotifications.roundalib.config.value.GuiAlignment;
import me.roundaround.pickupnotifications.roundalib.config.value.Position;
import me.roundaround.pickupnotifications.roundalib.shadow.nightconfig.core.Config;

public class PickupNotificationsConfig
extends ModConfig {
    public final BooleanConfigOption MOD_ENABLED = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.builder((ModConfig)this, "modEnabled", "pickupnotifications.mod_enabled.label").setComment("Simple toggle for the mod! Set to false to disable.")).build());
    public final OptionListConfigOption<GuiAlignment> GUI_ALIGNMENT = (OptionListConfigOption)this.registerConfigOption(((OptionListConfigOption.Builder)OptionListConfigOption.builder((ModConfig)this, "guiAlignment", "pickupnotifications.gui_alignment.label", Arrays.asList(GuiAlignment.values()), GuiAlignment.TOP_LEFT).setComment("Where to position the notifications. Can be one of", "'top_left', 'top_right', 'bottom_left', or 'bottom_right'.")).build());
    public final PositionConfigOption GUI_OFFSET = this.registerConfigOption(((PositionConfigOption.Builder)PositionConfigOption.builder((ModConfig)this, "guiOffset", "pickupnotifications.gui_offset.label", new Position(4, 4)).setComment("The amount to offset the notifications from the edge", "of the screen.")).build());
    public final FloatConfigOption GUI_SCALE = this.registerConfigOption(((FloatConfigOption.Builder)FloatConfigOption.sliderBuilder((ModConfig)this, "guiScale", "pickupnotifications.gui_scale.label").setDefaultValue(1.0f).setMinValue(0.1f).setMaxValue(3.0f).setStep(30).setComment("Scale to render notifications at.")).build());
    public final IntConfigOption MAX_NOTIFICATIONS = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "maxNotifications", "pickupnotifications.max_notifications.label").setDefaultValue(4).setComment("How many notifications can be on the screen at a time.", "Additional notifications will be queued up and shown once", "there is room.")).build());
    public final OptionListConfigOption<IconAlignment> ICON_ALIGNMENT = (OptionListConfigOption)this.registerConfigOption(((OptionListConfigOption.Builder)OptionListConfigOption.builder((ModConfig)this, "iconAlignment", "pickupnotifications.icon_alignment.label", Arrays.asList(IconAlignment.values()), IconAlignment.getDefault()).setComment("Whether the item icons should appear on the 'left' or", "'right' of notifications, always on the 'outside' (left for", "left-aligned, right for right-aligned), or always on the", "'inside' of notifications.")).build());
    public final BooleanConfigOption SHOW_UNIQUE_INFO = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "showUniqueInfo", "pickupnotifications.show_unique_info.label").setComment("Whether to show custom names, rarity, and enchantments", "in the notifications.")).build());
    public final BooleanConfigOption RENDER_BACKGROUND = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "renderBackground", "pickupnotifications.render_background.label").setComment("Whether to render the background behind notifications.")).build());
    public final FloatConfigOption BACKGROUND_OPACITY = this.registerConfigOption(((FloatConfigOption.Builder)FloatConfigOption.sliderBuilder((ModConfig)this, "backgroundOpacity", "pickupnotifications.background_opacity.label").setDefaultValue(0.5f).setMinValue(0.0f).setMaxValue(1.0f).setStep(20).setComment("Opacity of the notification background color.")).build());
    public final BooleanConfigOption RENDER_SHADOW = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "renderShadow", "pickupnotifications.render_shadow.label").setDefaultValue(false).setComment("Whether to render text shadow in notifications.")).build());

    public PickupNotificationsConfig() {
        super("pickupnotifications", ModConfig.options("pickupnotifications").setConfigVersion(2));
    }

    @Override
    protected boolean updateConfigVersion(int version, Config config) {
        if (version == 1) {
            config.set("pickupnotifications.guiOffset", (Object)new Position(config.getIntOrElse("pickupnotifications.guiOffsetX", ((Position)this.GUI_OFFSET.getDefault()).x()), config.getIntOrElse("pickupnotifications.guiOffsetY", ((Position)this.GUI_OFFSET.getDefault()).y())).toString());
            return true;
        }
        return false;
    }
}

