/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.shadow.nightconfig.core.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import me.roundaround.pickupnotifications.roundalib.shadow.nightconfig.core.file.FileConfig;
import me.roundaround.pickupnotifications.roundalib.shadow.nightconfig.core.file.FileWatcher;
import me.roundaround.pickupnotifications.roundalib.shadow.nightconfig.core.utils.ConfigWrapper;

final class AutoreloadFileConfig<C extends FileConfig>
extends ConfigWrapper<C>
implements FileConfig {
    private final FileWatcher watcher = FileWatcher.defaultInstance();

    AutoreloadFileConfig(C config) {
        super(config);
        try {
            this.watcher.addWatch(config.getFile(), () -> config.load());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create the autoreloaded config", e);
        }
    }

    @Override
    public File getFile() {
        return ((FileConfig)this.config).getFile();
    }

    @Override
    public Path getNioPath() {
        return ((FileConfig)this.config).getNioPath();
    }

    @Override
    public void save() {
        ((FileConfig)this.config).save();
    }

    @Override
    public void load() {
        ((FileConfig)this.config).load();
    }

    @Override
    public void close() {
        this.watcher.removeWatch(((FileConfig)this.config).getFile());
        ((FileConfig)this.config).close();
    }
}

