/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.config;

import com.moandjiezana.toml.Toml;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ConfigEntry<T> {
    protected final Set<Consumer<T>> updateListeners = new HashSet<Consumer<T>>();
    protected final Type type;
    public final T defaultValue;
    public final String configKey;
    public final String description;
    protected T value;

    public ConfigEntry(T defaultValue, String configKey, String description, Type type) {
        this.defaultValue = defaultValue;
        this.configKey = configKey;
        this.description = description;
        this.type = type;
    }

    public void reset() {
        this.value = this.defaultValue;
        this.pollListeners();
    }

    public T get() {
        return this.value;
    }

    public T set(T value) {
        this.value = value;
        this.pollListeners();
        return value;
    }

    public void load(Toml toml) {
        Object tomlValue = this.type.get(toml, this.configKey);
        if (tomlValue == null) {
            tomlValue = this.defaultValue;
        }
        this.value = tomlValue;
        this.pollListeners();
    }

    protected void pollListeners() {
        this.updateListeners.forEach(c -> c.accept(this.value));
    }

    public Consumer<T> addListener(Consumer<T> consumer) {
        this.updateListeners.add(consumer);
        return consumer;
    }

    public void removeListener(Consumer<?> consumer) {
        this.updateListeners.remove(consumer);
    }

    public String toString() {
        return "# %s\n#\n".formatted(this.description.replace("\n", "\n# ")) + "# Default: %s\n".formatted(this.defaultValue) + "%s = %s\n".formatted(this.configKey, this.type.makeString(this.value));
    }

    public static enum Type {
        INTEGER((t, k) -> t.getLong(k) == null ? null : Integer.valueOf(t.getLong(k).intValue())),
        DOUBLE(Toml::getDouble),
        BOOLEAN(Toml::getBoolean),
        STRING(Toml::getString, o -> "\"" + String.valueOf(o) + "\"");

        private final BiFunction<Toml, String, Object> get;
        private final Function<Object, String> toString;

        private Type(BiFunction<Toml, String, Object> get) {
            this.get = get;
            this.toString = Object::toString;
        }

        private Type(BiFunction<Toml, String, Object> get, Function<Object, String> toString) {
            this.get = get;
            this.toString = toString;
        }

        public Object get(Toml toml, String key) {
            return this.get.apply(toml, key);
        }

        public String makeString(Object object) {
            return this.toString.apply(object);
        }
    }
}

