/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket;

import io.github.blanketmc.blanket.config.ConfigEntry;
import io.github.blanketmc.blanket.config.EntryListener;
import io.github.blanketmc.blanket.config.ExtraProperty;
import io.github.blanketmc.blanket.fixes.RotatePlayerWithMinecart;

public final class Config {
    @ConfigEntry(description="The only internal config. Toggle how much log should blanket create", categories={ConfigEntry.Category.EXPERIMENTAL})
    public static boolean extraLog = true;
    @ConfigEntry(description="Fix inventory can not be closed by mouse button.", issues={"MC-577"}, categories={ConfigEntry.Category.BUGFIX, ConfigEntry.Category.RECOMMENDED, ConfigEntry.Category.UI})
    public static boolean mouseCloseNotHandledFix = true;
    @ConfigEntry(description="Fix chat lag on multiplayer servers", issues={"MC-247973"}, categories={ConfigEntry.Category.BUGFIX, ConfigEntry.Category.RECOMMENDED, ConfigEntry.Category.PERFORMANCE})
    public static boolean chatLagFix = true;
    @ConfigEntry(description="Fix lava damaging entities client-side leading to de-sync", issues={"MC-246465"}, categories={ConfigEntry.Category.BUGFIX, ConfigEntry.Category.EXPERIMENTAL})
    public static boolean lavaDamageDesyncFix = false;
    @ConfigEntry(description="Fix client damaging items & experience orbs leading to de-sync", issues={"MC-53850"}, categories={ConfigEntry.Category.BUGFIX, ConfigEntry.Category.EXPERIMENTAL})
    public static boolean entityDamageDesyncFix = false;
    @ConfigEntry(description="Fix guardian beam not rendering due to world time being too high\nSodium-extra has the same fix", issues={"MC-165595"}, categories={ConfigEntry.Category.BUGFIX, ConfigEntry.Category.RECOMMENDED, ConfigEntry.Category.RENDER})
    public static boolean guardianBeamRenderFix = true;
    @ConfigEntry(description="Fix entity id being shared by the client renderer and integrated server", issues={"MC-238384"}, categories={ConfigEntry.Category.BUGFIX, ConfigEntry.Category.SINGLEPLAYER})
    public static boolean sharedEntityIdFix = true;
    @ConfigEntry(description="Rotate the player with the minecart if it turns", listeners={lockMinecartViewListener.class}, categories={ConfigEntry.Category.TWEAK, ConfigEntry.Category.EXPERIMENTAL}, extraProperties={"rotatePlayerWithMinecart_smartMode", "rotatePlayerWithMinecart_threshold", "rotatePlayerWithMinecart_alwaysLookForward"})
    public static boolean rotatePlayerWithMinecart = false;
    @ExtraProperty(description="Try to detect U-turns and collisions")
    public static boolean rotatePlayerWithMinecart_smartMode = true;
    @ExtraProperty(description="Minimum speed to start following minecart direction")
    public static int rotatePlayerWithMinecart_threshold = 8;
    @ExtraProperty(description="Always look forward")
    public static boolean rotatePlayerWithMinecart_alwaysLookForward = false;
    @ConfigEntry(description="Optimized the getBiome call to be 25% - 75% faster", categories={ConfigEntry.Category.PERFORMANCE, ConfigEntry.Category.RECOMMENDED})
    public static boolean optimizedBiomeAccess = true;
    @ConfigEntry(description="Fix end crystals attempting to heal the ender dragon", issues={"MC-187100"}, categories={ConfigEntry.Category.BUGFIX})
    public static boolean crystalsTargetDeadDragonFix = true;
    @ConfigEntry(description="Fix wolf tail spinning if health is increased", issues={"MC-175622"}, categories={ConfigEntry.Category.BUGFIX, ConfigEntry.Category.RENDER})
    public static boolean wolfTailSpinFix = true;
    @ConfigEntry(description="Fix switched amethyst sound", issues={"MC-248223"}, categories={ConfigEntry.Category.BUGFIX, ConfigEntry.Category.RECOMMENDED})
    public static boolean fixSwappedAmethystSound = true;

    private static class lockMinecartViewListener
    extends EntryListener<Boolean> {
        private lockMinecartViewListener() {
        }

        @Override
        public Boolean onEntryChange(Boolean currentValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                RotatePlayerWithMinecart.onStartRiding();
            }
            return newValue;
        }
    }
}

