/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.channel;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.Channel;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.S2CMessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

public final class S2CChannel<MSG>
extends Channel<MSG> {
    public S2CChannel(class_2960 id, MessageType<MSG> messageType) {
        super(id, messageType);
    }

    @Environment(value=EnvType.CLIENT)
    public void register() {
        ClientNetworking.registerS2CReceiver(this.id, buf -> {
            Object message = this.messageType.decode(buf);
            S2CMessageContext context = new S2CMessageContext(this);
            this.messageType.onReceive(message, context);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void unregister() {
        ClientNetworking.unregisterS2CReceiver(this.id);
    }

    public void sendTo(class_3222 player, MSG message) {
        class_3244 handler = player.field_13987;
        if (handler == null) {
            ShulkerBoxTooltip.LOGGER.error("Cannot send message to the " + this.id + " channel while player " + player.method_5477() + " is not in-game");
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.messageType.encode(message, buf);
        handler.method_14364(ServerNetworking.createS2CPacket(this.id, buf));
    }
}

