/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import bl4ckscor3.mod.biomeinfo.BiomeInfoConfig;
import bl4ckscor3.mod.biomeinfo.PositionPreset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.apache.commons.lang3.StringUtils;

public class BiomeInfo
implements ClientModInitializer,
IdentifiableResourceReloadListener {
    public static final int MARGIN = 3;
    static BiomeInfoConfig config;
    private class_1959 previousBiome;
    private int displayTime = 0;
    private int alpha = 0;
    private boolean fadingIn = false;
    public static final Map<class_5321<class_1959>, class_2561> NAME_CACHE;

    public void onInitializeClient() {
        AutoConfig.register(BiomeInfoConfig.class, JanksonConfigSerializer::new);
        ConfigHolder configHolder = AutoConfig.getConfigHolder(BiomeInfoConfig.class);
        configHolder.registerSaveListener((holder, config) -> {
            NAME_CACHE.clear();
            return class_1269.field_5812;
        });
        BiomeInfo.config = (BiomeInfoConfig)configHolder.getConfig();
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (!this.fadingIn) {
                if (!BiomeInfo.config.fadeOut && this.alpha != 255) {
                    this.alpha = 255;
                } else if (BiomeInfo.config.fadeOut) {
                    if (this.displayTime > 0) {
                        --this.displayTime;
                    } else if (this.alpha > 0) {
                        this.alpha -= 10;
                    }
                }
            } else {
                this.alpha += 10;
                if (this.alpha >= 255) {
                    this.fadingIn = false;
                    this.displayTime = Math.max(0, BiomeInfo.config.displayTime);
                    this.alpha = 255;
                }
            }
        });
        HudRenderCallback.EVENT.register((graphics, delta) -> {
            if (BiomeInfo.config.enabled) {
                class_310 mc = class_310.method_1551();
                if (BiomeInfo.hideBecauseOfF1(mc) || BiomeInfo.hideBecauseOfF3(mc)) {
                    return;
                }
                class_2338 pos = mc.method_1560().method_24515();
                if (mc.field_1687 != null && mc.field_1687.method_8477(pos)) {
                    class_6880 biomeHolder = mc.field_1687.method_23753(pos);
                    if (!biomeHolder.method_40227()) {
                        return;
                    }
                    class_1959 biome = (class_1959)biomeHolder.comp_349();
                    if (this.previousBiome != biome) {
                        this.previousBiome = biome;
                        if (BiomeInfo.config.fadeIn) {
                            this.displayTime = 0;
                            this.alpha = 0;
                            this.fadingIn = true;
                        } else {
                            this.displayTime = Math.max(0, BiomeInfo.config.displayTime);
                            this.alpha = 255;
                        }
                    }
                    if (this.alpha > 0) {
                        biomeHolder.method_40230().ifPresent(key -> {
                            class_2561 biomeName = BiomeInfo.getBiomeName((class_5321<class_1959>)key);
                            float scale = (float)BiomeInfo.config.scale;
                            PositionPreset positionPreset = BiomeInfo.config.positionPreset;
                            int textOffset = positionPreset.textAlignment().getNegativeOffset(mc.field_1772, biomeName);
                            class_4587 pose = graphics.method_51448();
                            class_1041 window = mc.method_22683();
                            pose.method_22903();
                            pose.method_22905(scale, scale, scale);
                            graphics.method_51439(mc.field_1772, biomeName, positionPreset.posX(window) - textOffset, positionPreset.posY(window, mc.field_1772), BiomeInfo.config.color | this.alpha << 24, BiomeInfo.config.textShadow);
                            pose.method_22909();
                        });
                    }
                }
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    private static class_2561 getBiomeName(class_5321<class_1959> key) {
        return NAME_CACHE.computeIfAbsent(key, k -> {
            String modName;
            String displayedText;
            class_5250 biomeName;
            class_2960 location = key.method_29177();
            String translationKey = class_156.method_646((String)"biome", (class_2960)location);
            class_5250 displayName = biomeName = class_2561.method_43471((String)translationKey);
            if (BiomeInfo.config.fallbackOnUntranslatableName && (displayedText = biomeName.getString()).equals(translationKey)) {
                String biomePath = key.method_29177().method_12832();
                String formattedBiomeName = BiomeInfo.snakeCaseToEnglish(biomePath);
                displayName = class_2561.method_43470((String)formattedBiomeName);
            }
            if (BiomeInfo.config.appendModName && (modName = BiomeInfo.getModName(location)) != null) {
                displayName = displayName.method_10852((class_2561)class_2561.method_43470((String)String.format(" (%s)", modName)));
            }
            return displayName;
        });
    }

    private static boolean hideBecauseOfF1(class_310 mc) {
        return mc.field_1690.field_1842 && BiomeInfo.config.hideWithUI;
    }

    private static boolean hideBecauseOfF3(class_310 mc) {
        return mc.field_1690.field_1866 && BiomeInfo.config.hideOnDebugScreen;
    }

    private static String snakeCaseToEnglish(String biomePath) {
        String[] words = biomePath.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            formatted.append(StringUtils.capitalize((String)word)).append(" ");
        }
        return formatted.toString().trim();
    }

    private static String getModName(class_2960 location) {
        String namespace = location.method_12836();
        return FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).filter(meta -> meta.getId().equals(namespace)).findFirst().map(ModMetadata::getName).orElseGet(() -> BiomeInfo.snakeCaseToEnglish(namespace));
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
        return CompletableFuture.runAsync(NAME_CACHE::clear, executor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
    }

    public class_2960 getFabricId() {
        return new class_2960("biomeinfo", "cache_invalidation");
    }

    static {
        NAME_CACHE = new HashMap<class_5321<class_1959>, class_2561>();
    }
}

