/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.annotation.ValueConverter;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class SimpleTypeConverter<T extends Value, R>
implements ValueConverter<R> {
    private static final Map<Class<?>, SimpleTypeConverter<? extends Value, ?>> byResult = new HashMap();
    private final BiFunction<T, Context, R> converter;
    private final Class<T> valueClass;
    private final String typeName;

    public SimpleTypeConverter(Class<T> inputType, Function<T, R> converter, String typeName) {
        this(inputType, (T v, Context c) -> converter.apply(v), typeName);
    }

    public SimpleTypeConverter(Class<T> inputType, BiFunction<T, Context, R> converter, String typeName) {
        this.converter = converter;
        this.valueClass = inputType;
        this.typeName = typeName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    static <R> SimpleTypeConverter<Value, R> get(Class<R> outputType) {
        return byResult.get(outputType);
    }

    @Override
    @Nullable
    public R convert(Value value, @Nullable Context context) {
        return this.valueClass.isInstance(value) ? (R)this.converter.apply(value, context) : null;
    }

    public static <T extends Value, R> void registerType(Class<T> requiredInputType, Class<R> outputType, Function<T, R> converter, String typeName) {
        SimpleTypeConverter.registerType(requiredInputType, outputType, (T val, Context ctx) -> converter.apply(val), typeName);
    }

    public static <T extends Value, R> void registerType(Class<T> requiredInputType, Class<R> outputType, BiFunction<T, Context, R> converter, String typeName) {
        SimpleTypeConverter<T, R> type = new SimpleTypeConverter<T, R>(requiredInputType, converter, typeName);
        byResult.put(outputType, type);
    }

    static {
        SimpleTypeConverter.registerType(Value.class, class_3222.class, (T v, Context c) -> EntityValue.getPlayerByValue(((CarpetContext)c).server(), v), "online player");
        SimpleTypeConverter.registerType(EntityValue.class, class_1297.class, EntityValue::getEntity, "entity");
        SimpleTypeConverter.registerType(Value.class, class_1937.class, (T v, Context c) -> ValueConversions.dimFromValue(v, ((CarpetContext)c).server()), "dimension");
        SimpleTypeConverter.registerType(Value.class, class_2561.class, FormattedTextValue::getTextByValue, "text");
        SimpleTypeConverter.registerType(Value.class, String.class, Value::getString, "string");
        SimpleTypeConverter.registerType(NumericValue.class, Long.class, NumericValue::getLong, "number");
        SimpleTypeConverter.registerType(NumericValue.class, Double.class, NumericValue::getDouble, "number");
        SimpleTypeConverter.registerType(NumericValue.class, Integer.class, NumericValue::getInt, "number");
        SimpleTypeConverter.registerType(Value.class, Boolean.class, Value::getBoolean, "boolean");
    }
}

