/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.emi.ingredient;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.runtime.EmiLog;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.jeed.plugin.emi.ingredient.EffectInstanceStack;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_7923;

public class EffectIngredientSerializer
implements EmiIngredientSerializer<EffectInstanceStack> {
    public static final MapCodec<class_1293> MAP_CODEC = new RecursiveMapCodec<class_1293>("MobEffectInstance.Details", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41174.method_39673().fieldOf("id").forGetter(class_1293::method_5579), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(class_1293::method_5584), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(class_1293::method_5578), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(class_1293::method_5591), (App)Codec.BOOL.optionalFieldOf("visible", (Object)true).forGetter(class_1293::method_5581), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(class_1293::method_5592), (App)codec.optionalFieldOf("hidden_effect").forGetter(e -> Optional.ofNullable(e.field_21830)), (App)class_1293.class_7247.field_38085.optionalFieldOf("factor_data").forGetter(class_1293::method_42129)).apply((Applicative)instance, EffectIngredientSerializer::create)));
    public static final Codec<class_1293> CODEC = MAP_CODEC.codec();

    public String getType() {
        return "mob_effect";
    }

    public EmiIngredient deserialize(JsonElement element) {
        try {
            return (EmiIngredient)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).result().map(a -> new EffectInstanceStack((class_1293)a.getFirst())).orElseThrow(DecoderException::new);
        }
        catch (DecoderException e) {
            EmiLog.error((String)"Error parsing mob effect");
            EmiLog.error((Throwable)e);
            return EmiStack.EMPTY;
        }
    }

    public JsonElement serialize(EffectInstanceStack stack) {
        try {
            return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stack.getEffect()).result().orElseThrow(EncoderException::new);
        }
        catch (EncoderException e) {
            EmiLog.error((String)"Error encoding mob effect");
            EmiLog.error((Throwable)e);
            return new JsonObject();
        }
    }

    private static class_1293 create(class_1291 mobEffect, Integer integer, Integer integer1, Boolean aBoolean, Boolean aBoolean1, Boolean aBoolean2, Optional<class_1293> mobEffectInstance, Optional<class_1293.class_7247> factorData) {
        return new class_1293(mobEffect, integer.intValue(), integer1.intValue(), aBoolean.booleanValue(), aBoolean1.booleanValue(), aBoolean2.booleanValue(), (class_1293)mobEffectInstance.orElse(null), factorData);
    }

    private static class RecursiveMapCodec<A>
    extends MapCodec<A> {
        private final String name;
        private final Supplier<MapCodec<A>> wrapped;

        private RecursiveMapCodec(String name, Function<Codec<A>, MapCodec<A>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (MapCodec)wrapped.apply(this.codec()));
        }

        public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return this.wrapped.get().keys(ops);
        }

        public String toString() {
            return "RecursiveMapCodec[" + this.name + "]";
        }
    }
}

