/*
 * Decompiled with CFR 0.152.
 */
package com.aesefficio.interiors;

import com.aesefficio.interiors.Utils;
import com.aesefficio.interiors.content.registry.CIBlocks;
import com.aesefficio.interiors.content.registry.CIEntities;
import com.aesefficio.interiors.content.registry.CITab;
import com.aesefficio.interiors.content.registry.CITags;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.CreateBuildInfo;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateItemTagsProvider;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.data.extensions.MinecraftExtension;
import java.nio.file.Path;
import java.util.Set;
import net.createmod.catnip.lang.FontHelper;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_542;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateInteriors
implements ModInitializer,
DataGeneratorEntrypoint {
    public static final String ID = "interiors";
    public static final String NAME = "Create: Interiors";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Interiors");
    public static final String VERSION = Utils.getVersion("interiors");
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"interiors");

    public static void init() {
        LOGGER.info("{} v{} initializing! Create version: {} on platform: {}", new Object[]{NAME, VERSION, CreateBuildInfo.VERSION, Utils.platformName()});
        CITags.register();
        CIEntities.register();
        CIBlocks.register();
    }

    public void onInitialize() {
        CITab.register();
        CreateInteriors.init();
        REGISTRATE.register();
    }

    public void onInitializeDataGenerator(FabricDataGenerator gen) {
        LOGGER.info("Initializing data generator");
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> CITags.DYES.values().forEach(arg_0 -> ((RegistrateItemTagsProvider)prov).addTag(arg_0)));
        Path existingResources = Path.of(System.getProperty("porting_lib.datagen.existing_resources"), new String[0]);
        String existingMods = System.getProperty("porting_lib.datagen.existing-mod");
        class_542 config = ((MinecraftExtension)class_310.method_1551()).port_lib$getGameConfig();
        ExistingFileHelper efh = new ExistingFileHelper(Set.of(existingResources), Set.of(existingMods.split(",")), false, config.field_3277.field_3288, config.field_3277.field_3289);
        REGISTRATE.setupDatagen(gen.createPack(), efh);
        CreateInteriors.provideDefaultLang("tooltips");
    }

    private static void provideDefaultLang(String fileName) {
        String path = "assets/interiors/lang/default/" + fileName + ".json";
        JsonObject jsonObject = ((JsonElement)Preconditions.checkNotNull((Object)FilesHelper.loadJsonResource((String)path), (String)"Could not find default lang file: %s", (Object)path)).getAsJsonObject();
        jsonObject.entrySet().forEach(entry -> REGISTRATE.addRawLang((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
    }

    public static class_2960 id(String path) {
        return Utils.id(ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE));
    }
}

