/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.security;

import com.jaquadro.minecraft.storagedrawers.api.security.IInteractionProvider;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SecurityRegistry {
    private final Map<String, ISecurityProvider> registry = new HashMap<String, ISecurityProvider>();
    private final Map<String, IInteractionProvider> interactRegistry = new HashMap<String, IInteractionProvider>();

    public void registerProvider(ISecurityProvider provider) {
        this.registry.put(provider.getProviderID(), provider);
    }

    public void registerProvider(IInteractionProvider provider) {
        this.interactRegistry.put(provider.getProviderID(), provider);
    }

    public ISecurityProvider getProvider(String name) {
        return this.registry.get(name);
    }

    public IInteractionProvider getInteractionProvider(String name) {
        return this.interactRegistry.get(name);
    }

    public Collection<IInteractionProvider> getAllInteractionProviders() {
        return this.interactRegistry.values();
    }
}

