/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.viewfinder;

import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.data.filter.Filters;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ViewfinderShader {
    @Nullable
    private static class_2960 previousShader;

    public static Optional<class_2960> getCurrent() {
        class_279 effect = class_310.method_1551().field_1773.method_3183();
        if (effect != null) {
            return Optional.of(new class_2960(effect.method_1260()));
        }
        return Optional.empty();
    }

    public static void setPrevious(@Nullable class_2960 shader) {
        previousShader = shader;
    }

    public static void restorePrevious() {
        if (previousShader != null && ViewfinderShader.shouldRestorePreviousShaderEffect()) {
            ViewfinderShader.applyShader(previousShader);
            previousShader = null;
        }
    }

    public static void applyShader(class_2960 shader) {
        @Nullable class_279 effect = class_310.method_1551().field_1773.method_3183();
        if (effect != null && effect.method_1260().equals(shader.toString())) {
            return;
        }
        class_310.method_1551().field_1773.method_3168(shader);
    }

    public static void removeShader() {
        class_310.method_1551().field_1773.method_3207();
    }

    public static void update() {
        Optional<Camera<?>> camera = Camera.getCamera((class_1657)class_310.method_1551().field_1724);
        if (camera.isEmpty()) {
            ViewfinderShader.removeShader();
            return;
        }
        ItemAndStack<?> cameraItemAndStack = camera.get().get();
        ((CameraItem)((Object)cameraItemAndStack.getItem())).getAttachment(cameraItemAndStack.getStack(), CameraItem.FILTER_ATTACHMENT).flatMap(Filters::getShaderOf).ifPresentOrElse(ViewfinderShader::applyShader, ViewfinderShader::removeShader);
    }

    public static boolean shouldRestorePreviousShaderEffect() {
        if (PlatformHelper.isModLoaded("cold_sweat") && previousShader != null && previousShader.toString().equals("minecraft:shaders/post/blobs2.json")) {
            return false;
        }
        return previousShader != null;
    }
}

