/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.storage.IClientsideExposureStorage;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.QueryExposureDataC2SP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ClientsideExposureStorage
implements IClientsideExposureStorage {
    private final Map<String, @NotNull ExposureSavedData> CACHE = new HashMap<String, ExposureSavedData>();
    private final List<String> QUERIED_IDS = new ArrayList<String>();
    private final List<String> WAITING_IDS = new ArrayList<String>();

    @Override
    public Optional<ExposureSavedData> getOrQuery(String id) {
        ExposureSavedData exposureData = this.CACHE.get(id);
        if (exposureData == null && !this.WAITING_IDS.contains(id) && !this.QUERIED_IDS.contains(id)) {
            Packets.sendToServer(new QueryExposureDataC2SP(id));
            this.QUERIED_IDS.add(id);
        }
        return Optional.ofNullable(exposureData);
    }

    @Override
    public void put(String id, ExposureSavedData data) {
        this.CACHE.put(id, data);
        this.QUERIED_IDS.remove(id);
        this.WAITING_IDS.remove(id);
    }

    @Override
    public void putOnWaitingList(String exposureId) {
        if (!this.WAITING_IDS.contains(exposureId)) {
            this.WAITING_IDS.add(exposureId);
        }
    }

    @Override
    public List<String> getAllIds() {
        return this.CACHE.keySet().stream().toList();
    }

    @Override
    public void remove(String id) {
        this.CACHE.remove(id);
        this.QUERIED_IDS.remove(id);
        this.WAITING_IDS.remove(id);
    }

    @Override
    public void clear() {
        this.CACHE.clear();
        this.QUERIED_IDS.clear();
        this.WAITING_IDS.clear();
    }
}

