/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.chainConveyor;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.foundation.render.SpecialModels;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import net.minecraft.class_7923;

public class ChainConveyorVisual
extends SingleAxisRotatingVisual<ChainConveyorBlockEntity>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    private final List<TransformedInstance> guards = new ArrayList<TransformedInstance>();
    private final SmartRecycler<class_2960, TransformedInstance> boxes;
    private final SmartRecycler<class_2960, TransformedInstance> rigging;

    public ChainConveyorVisual(VisualizationContext context, ChainConveyorBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Models.partial((PartialModel)AllPartialModels.CHAIN_CONVEYOR_SHAFT));
        this.setupGuards();
        this.boxes = new SmartRecycler(key -> (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.PACKAGES.get(key))).createInstance());
        this.rigging = new SmartRecycler(key -> (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.PACKAGE_RIGGING.get(key))).createInstance());
    }

    @Override
    public void update(float pt) {
        super.update(pt);
        this.setupGuards();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        ((ChainConveyorBlockEntity)this.blockEntity).tickBoxVisuals();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTicks = ctx.partialTick();
        this.boxes.resetCount();
        this.rigging.resetCount();
        for (ChainConveyorPackage chainConveyorPackage : ((ChainConveyorBlockEntity)this.blockEntity).loopingPackages) {
            this.setupBoxVisual((ChainConveyorBlockEntity)this.blockEntity, chainConveyorPackage, partialTicks);
        }
        for (Map.Entry entry : ((ChainConveyorBlockEntity)this.blockEntity).travellingPackages.entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.setupBoxVisual((ChainConveyorBlockEntity)this.blockEntity, box, partialTicks);
            }
        }
        this.boxes.discardExtra();
        this.rigging.discardExtra();
    }

    private void setupBoxVisual(ChainConveyorBlockEntity be, ChainConveyorPackage box, float partialTicks) {
        if (box.worldPosition == null) {
            return;
        }
        if (box.item == null || box.item.method_7960()) {
            return;
        }
        ChainConveyorPackage.ChainConveyorPackagePhysicsData physicsData = box.physicsData((class_1936)be.method_10997());
        if (physicsData.prevPos == null) {
            return;
        }
        class_243 position = physicsData.prevPos.method_35590(physicsData.pos, (double)partialTicks);
        class_243 targetPosition = physicsData.prevTargetPos.method_35590(physicsData.targetPos, (double)partialTicks);
        float yaw = AngleHelper.angleLerp((double)partialTicks, (double)physicsData.prevYaw, (double)physicsData.yaw);
        class_243 offset = new class_243(targetPosition.field_1352 - (double)this.pos.method_10263(), targetPosition.field_1351 - (double)this.pos.method_10264(), targetPosition.field_1350 - (double)this.pos.method_10260());
        class_2338 containingPos = class_2338.method_49638((class_2374)position);
        class_1937 level = be.method_10997();
        int light = class_765.method_23687((int)level.method_8314(class_1944.field_9282, containingPos), (int)level.method_8314(class_1944.field_9284, containingPos));
        if (physicsData.modelKey == null) {
            class_2960 key = class_7923.field_41178.method_10221((Object)box.item.method_7909());
            if (key == null) {
                return;
            }
            physicsData.modelKey = key;
        }
        TransformedInstance rigBuffer = (TransformedInstance)this.rigging.get((Object)physicsData.modelKey);
        TransformedInstance boxBuffer = (TransformedInstance)this.boxes.get((Object)physicsData.modelKey);
        class_243 dangleDiff = VecHelper.rotate((class_243)targetPosition.method_1031(0.0, 0.5, 0.0).method_1020(position), (double)(-yaw), (class_2350.class_2351)class_2350.class_2351.field_11052);
        float zRot = class_3532.method_15393((float)((float)class_3532.method_15349((double)(-dangleDiff.field_1352), (double)dangleDiff.field_1351) * 57.295776f)) / 2.0f;
        float xRot = class_3532.method_15393((float)((float)class_3532.method_15349((double)dangleDiff.field_1350, (double)dangleDiff.field_1351) * 57.295776f)) / 2.0f;
        zRot = class_3532.method_15363((float)zRot, (float)-25.0f, (float)25.0f);
        xRot = class_3532.method_15363((float)xRot, (float)-25.0f, (float)25.0f);
        for (TransformedInstance buf : new TransformedInstance[]{rigBuffer, boxBuffer}) {
            buf.setIdentityTransform();
            buf.translate((class_2382)this.getVisualPosition());
            buf.translate(offset);
            buf.translate(0.0f, 0.625f, 0.0f);
            buf.rotateYDegrees(yaw);
            buf.rotateZDegrees(zRot);
            buf.rotateXDegrees(xRot);
            if (physicsData.flipped && buf == rigBuffer) {
                buf.rotateYDegrees(180.0f);
            }
            buf.uncenter();
            buf.translate(0.0f, -PackageItem.getHookDistance(box.item) + 0.4375f, 0.0f);
            buf.light(light);
            buf.setChanged();
        }
    }

    private void deleteGuards() {
        for (TransformedInstance guard : this.guards) {
            guard.delete();
        }
        this.guards.clear();
    }

    private void setupGuards() {
        this.deleteGuards();
        Instancer wheelInstancer = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.chunkDiffuse(AllPartialModels.CHAIN_CONVEYOR_WHEEL));
        Instancer guardInstancer = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.chunkDiffuse(AllPartialModels.CHAIN_CONVEYOR_GUARD));
        TransformedInstance wheel = (TransformedInstance)wheelInstancer.createInstance();
        ((TransformedInstance)wheel.translate((class_2382)this.getVisualPosition())).light(this.rotatingModel.light).setChanged();
        this.guards.add(wheel);
        for (class_2338 blockPos : ((ChainConveyorBlockEntity)this.blockEntity).connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = ((ChainConveyorBlockEntity)this.blockEntity).connectionStats.get(blockPos);
            if (stats == null) continue;
            class_243 diff = stats.end().method_1020(stats.start());
            double yaw = 57.2957763671875 * class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350);
            TransformedInstance guard = (TransformedInstance)guardInstancer.createInstance();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)guard.translate((class_2382)this.getVisualPosition())).center()).rotateYDegrees((float)yaw)).uncenter()).light(this.rotatingModel.light).setChanged();
            this.guards.add(guard);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        for (TransformedInstance guard : this.guards) {
            this.relight(new FlatLit[]{guard});
        }
    }

    @Override
    protected void _delete() {
        super._delete();
        this.deleteGuards();
        this.boxes.delete();
        this.rigging.delete();
    }
}

