/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.train.PortalTrackProvider;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.betterend.BetterEndPortalCompat;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import io.github.fabricators_of_create.porting_lib.entity.ITeleporter;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class AllPortalTracks {
    public static void tryRegisterIntegration(class_2960 id, PortalTrackProvider provider) {
        if (class_7923.field_41175.method_10250(id)) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
            PortalTrackProvider.REGISTRY.register(block, provider);
        } else {
            Create.LOGGER.warn("Portal for integration wasn't found: {}. Compat outdated?", (Object)id);
        }
    }

    public static void registerDefaults() {
        PortalTrackProvider.REGISTRY.register(class_2246.field_10316, AllPortalTracks::nether);
        if (Mods.AETHER.isLoaded()) {
            AllPortalTracks.tryRegisterIntegration(Mods.AETHER.rl("aether_portal"), AllPortalTracks::aether);
        }
        if (Mods.BETTEREND.isLoaded()) {
            AllPortalTracks.tryRegisterIntegration(Mods.BETTEREND.rl("end_portal_block"), AllPortalTracks::betterend);
        }
    }

    private static PortalTrackProvider.Exit nether(class_3218 level, BlockFace face) {
        MinecraftServer minecraftServer = level.method_8503();
        if (!minecraftServer.method_3839()) {
            return null;
        }
        return PortalTrackProvider.fromTeleporter(level, face, (class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)class_1937.field_25180, l -> (ITeleporter)l.method_14173());
    }

    private static PortalTrackProvider.Exit aether(class_3218 level, BlockFace face) {
        class_5321 aetherLevelKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)Mods.AETHER.rl("the_aether"));
        return PortalTrackProvider.fromTeleporter(level, face, (class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)aetherLevelKey, serverLevel -> {
            try {
                return (ITeleporter)Class.forName("com.aetherteam.aether.block.portal.AetherPortalForcer").getDeclaredConstructor(class_3218.class, Boolean.TYPE).newInstance(serverLevel, true);
            }
            catch (Exception e) {
                Create.LOGGER.error("Failed to create Aether teleporter: ", (Throwable)e);
                return (ITeleporter)serverLevel.method_14173();
            }
        });
    }

    private static PortalTrackProvider.Exit betterend(class_3218 level, BlockFace face) {
        return AllPortalTracks.fromProbe(level, face, (class_5321<class_1937>)class_1937.field_25179, (class_5321<class_1937>)class_1937.field_25181, BetterEndPortalCompat::getBetterEndPortalInfo);
    }

    public static PortalTrackProvider.Exit fromTeleporter(class_3218 level, BlockFace inboundTrack, class_5321<class_1937> firstDimension, class_5321<class_1937> secondDimension, Function<class_3218, ITeleporter> customPortalForcer) {
        return PortalTrackProvider.fromProbe(level, inboundTrack, firstDimension, secondDimension, (otherLevel, probe) -> {
            ITeleporter teleporter = (ITeleporter)customPortalForcer.apply((class_3218)otherLevel);
            return teleporter.getPortalInfo((class_1297)probe, otherLevel, probe::method_30329);
        });
    }

    public static PortalTrackProvider.Exit fromProbe(class_3218 level, BlockFace inboundTrack, class_5321<class_1937> firstDimension, class_5321<class_1937> secondDimension, BiFunction<class_3218, SuperGlueEntity, class_5454> portalInfoProvider) {
        class_5321<class_1937> resourceKey = level.method_27983() == secondDimension ? firstDimension : secondDimension;
        MinecraftServer minecraftServer = level.method_8503();
        class_3218 otherLevel = minecraftServer.method_3847(resourceKey);
        if (otherLevel == null) {
            return null;
        }
        class_2338 portalPos = inboundTrack.getConnectedPos();
        class_2680 portalState = level.method_8320(portalPos);
        SuperGlueEntity probe = new SuperGlueEntity((class_1937)level, new class_238(portalPos));
        probe.method_36456(inboundTrack.getFace().method_10144());
        probe.setPortalEntrancePos();
        class_5454 portalInfo = portalInfoProvider.apply(otherLevel, probe);
        if (portalInfo == null) {
            return null;
        }
        class_2338 otherPortalPos = class_2338.method_49638((class_2374)portalInfo.field_25879);
        class_2680 otherPortalState = otherLevel.method_8320(otherPortalPos);
        if (!otherPortalState.method_27852(portalState.method_26204())) {
            return null;
        }
        class_2350 targetDirection = inboundTrack.getFace();
        if (targetDirection.method_10166() == otherPortalState.method_11654((class_2769)class_2741.field_12529)) {
            targetDirection = targetDirection.method_10170();
        }
        class_2338 otherPos = otherPortalPos.method_10093(targetDirection);
        return new PortalTrackProvider.Exit(otherLevel, new BlockFace(otherPos, targetDirection.method_10153()));
    }
}

