/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.debugInfo;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.compat.pojav.PojavChecker;
import com.simibubi.create.foundation.mixin.accessor.SystemReportAccessor;
import com.simibubi.create.infrastructure.debugInfo.element.DebugInfoSection;
import com.simibubi.create.infrastructure.debugInfo.element.InfoElement;
import com.simibubi.create.infrastructure.debugInfo.element.InfoEntry;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.api.backend.BackendManager;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_4494;
import net.minecraft.class_5365;
import net.minecraft.class_6396;

public class DebugInformation {
    private static final List<DebugInfoSection> client = new ArrayList<DebugInfoSection>();
    private static final List<DebugInfoSection> server = new ArrayList<DebugInfoSection>();
    private static final ImmutableMap<String, String> mcSystemInfo = (ImmutableMap)class_156.method_656(() -> {
        class_6396 systemReport = new class_6396();
        SystemReportAccessor access = (SystemReportAccessor)systemReport;
        return ImmutableMap.copyOf(access.getEntries());
    });

    public static void registerClientInfo(DebugInfoSection section) {
        client.add(section);
    }

    public static void registerServerInfo(DebugInfoSection section) {
        server.add(section);
    }

    public static void registerBothInfo(DebugInfoSection section) {
        DebugInformation.registerClientInfo(section);
        DebugInformation.registerServerInfo(section);
    }

    public static List<DebugInfoSection> getClientInfo() {
        return client;
    }

    public static List<DebugInfoSection> getServerInfo() {
        return server;
    }

    public static String getVersionOfMod(String id) {
        return FabricLoader.getInstance().getModContainer(id).map(mod -> mod.getMetadata().getVersion().toString()).orElse("None");
    }

    public static Collection<InfoElement> listAllOtherMods() {
        ArrayList<InfoElement> mods = new ArrayList<InfoElement>();
        FabricLoader.getInstance().getAllMods().forEach(mod -> {
            ModMetadata meta = mod.getMetadata();
            String id = meta.getId();
            if (!(id.equals("create") || id.equals("fabric-api") || id.equals("minecraft") || id.equals("flywheel") || id.equals("ponder"))) {
                String name = meta.getName();
                String version = meta.getVersion().toString();
                mods.add(new InfoEntry(name, version));
            }
        });
        return mods;
    }

    public static Collection<InfoElement> listAllGraphicsCards() {
        ArrayList<InfoElement> cards = new ArrayList<InfoElement>();
        for (int i = 0; i < 10; ++i) {
            String name = DebugInformation.getMcSystemInfo("Graphics card #" + i + " name");
            String vendor = DebugInformation.getMcSystemInfo("Graphics card #" + i + " vendor");
            String vram = DebugInformation.getMcSystemInfo("Graphics card #" + i + " VRAM (MB)");
            if (name == null || vendor == null || vram == null) break;
            String key = "Graphics card #" + i;
            String value = String.format("%s (%s); %s MB of VRAM", name, vendor, vram);
            cards.add(new InfoEntry(key, value));
        }
        return cards.isEmpty() ? List.of(new InfoEntry("Graphics cards", "none")) : cards;
    }

    public static String getTotalRam() {
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long usedMemory = totalMemory - availableMemory;
        return String.format("%s bytes (%s MiB) / %s bytes (%s MiB)", usedMemory, usedMemory / 0x100000L, totalMemory, totalMemory / 0x100000L);
    }

    public static String getCpuInfo() {
        String name = DebugInformation.tryTrim(DebugInformation.getMcSystemInfo("Processor Name"));
        String freq = DebugInformation.getMcSystemInfo("Frequency (GHz)");
        String sockets = DebugInformation.getMcSystemInfo("Number of physical packages");
        String cores = DebugInformation.getMcSystemInfo("Number of physical CPUs");
        String threads = DebugInformation.getMcSystemInfo("Number of logical CPUs");
        return String.format("%s @ %s GHz; %s cores / %s threads on %s socket(s)", name, freq, cores, threads, sockets);
    }

    @Nullable
    public static String getMcSystemInfo(String key) {
        return (String)mcSystemInfo.get((Object)key);
    }

    public static String getIndent(int depth) {
        return Stream.generate(() -> "\t").limit(depth).collect(Collectors.joining());
    }

    @Nullable
    public static String tryTrim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    static {
        DebugInfoSection.builder("Create").put("Mod Version", DebugInformation.getVersionOfMod("create")).put("Fabric API Version", DebugInformation.getVersionOfMod("fabric-api")).put("Ponder Version", DebugInformation.getVersionOfMod("ponder")).put("Minecraft Version", class_155.method_16673().method_48019()).buildTo(DebugInformation::registerBothInfo);
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> DebugInfoSection.builder("Graphics").put("Flywheel Version", FabricLoader.getInstance().getModContainer("flywheel").map(c -> c.getMetadata().getVersion().toString()).orElse("None")).put("Flywheel Backend", () -> Backend.REGISTRY.getIdOrThrow((Object)BackendManager.currentBackend()).toString()).put("OpenGL Renderer", class_4494::method_22090).put("OpenGL Version", class_4494::method_22091).put("Graphics Mode", () -> ((class_5365)class_310.method_1551().field_1690.method_42534().method_41753()).name().toLowerCase(Locale.ROOT)).put("PojavLauncher Detected", () -> String.valueOf(PojavChecker.IS_PRESENT)).buildTo(DebugInformation::registerClientInfo));
        DebugInfoSection.builder("System Information").put("Operating System", SystemReportAccessor.getOPERATING_SYSTEM()).put("Java Version", SystemReportAccessor.getJAVA_VERSION()).put("JVM Flags", DebugInformation.getMcSystemInfo("JVM Flags")).put("Memory", () -> DebugInformation.getMcSystemInfo("Memory")).put("Total Memory", DebugInformation.getTotalRam()).put("CPU", DebugInformation.getCpuInfo()).putAll(DebugInformation.listAllGraphicsCards()).buildTo(DebugInformation::registerBothInfo);
        DebugInfoSection.builder("Other Mods").putAll(DebugInformation.listAllOtherMods()).buildTo(DebugInformation::registerBothInfo);
    }
}

